/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client.dialog;

import bitel.billing.module.contract.PaymentDistributePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelPluginControls;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.balance.client.PaymentAndChargeTreeTablePanel;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.AbstractBalanceBean;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.BGSwingUtilites;

public class PaymentAndChargeEditor
extends BGDialog {
    private int id;
    private int mode = 0;
    private int contractId = -1;
    private String pluginExtensionPoint;
    private JTextArea comment = new JTextArea();
    private BGControlPanelDateNoB date = new BGControlPanelDateNoB();
    private BGFloatTextField summa = new BGFloatTextField();
    private PaymentAndChargeTreeTablePanel pcPanel = new PaymentAndChargeTreeTablePanel();
    private BGButtonPanelRestoreOkCancelHelp okPanel = new BGButtonPanelRestoreOkCancelHelp();
    private BGControlPanelPluginControls bgPluginnedPanel;
    private PaymentDistributePanel paymentDictributePanel;

    public PaymentAndChargeEditor(int id, int contractId, String pluginExtensionPoint) {
        this.id = id;
        this.contractId = contractId;
        this.pluginExtensionPoint = pluginExtensionPoint;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.pack();
        this.setSize(600, 500);
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        this.date.setButtonMove(true);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.comment.setLineWrap(true);
        this.comment.setWrapStyleWord(true);
        this.comment.setMargin(new Insets(3, 3, 3, 3));
        this.summa.setMinimumSize(new Dimension(110, 24));
        this.summa.setPreferredSize(new Dimension(110, 24));
        this.summa.setColumns(10);
        this.okPanel.addActionListener(e -> {
            try {
                this.okPanelActionPerformed(e);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        JPanel typePanel = new JPanel(new GridBagLayout());
        typePanel.add((Component)this.pcPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JTabbedPane typeAndComment = new JTabbedPane();
        typeAndComment.addTab("\u0422\u0438\u043f", typePanel);
        typeAndComment.addTab("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", commentPanel);
        JPanel summaPanel = new JPanel(new GridBagLayout());
        summaPanel.setBorder(new BGTitleBorder(" \u0421\u0443\u043c\u043c\u0430 "));
        summaPanel.add((Component)this.summa, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel datePanel = new JPanel(new GridBagLayout());
        datePanel.setBorder(new BGTitleBorder(" \u0414\u0430\u0442\u0430 "));
        datePanel.add((Component)this.date, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel dateAndSummaPanel = new JPanel(new GridBagLayout());
        dateAndSummaPanel.add((Component)summaPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        dateAndSummaPanel.add((Component)datePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)dateAndSummaPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)typeAndComment, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.bgPluginnedPanel = new BGControlPanelPluginControls(this.pluginExtensionPoint, this, new Object[0]);
        this.add((Component)this.bgPluginnedPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.okPanel, new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                PaymentAndChargeEditor.this.summa.requestFocusInWindow();
            }
        });
        this.bgPluginnedPanel.invokeInitBGPanel(null, -1);
        this.summa.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updated();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updated();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updated();
            }

            private void updated() {
                if (PaymentAndChargeEditor.this.paymentDictributePanel != null) {
                    PaymentAndChargeEditor.this.paymentDictributePanel.summaChanged(PaymentAndChargeEditor.this.summa.getText());
                }
            }
        });
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.pcPanel.setMode(mode);
    }

    public int getMode() {
        return this.mode;
    }

    @Override
    public void setData() {
        String nowDateStr = TimeUtils.format((Calendar)new GregorianCalendar(), "dd.MM.yyyy");
        this.pcPanel.setData();
        if (this.id > 0) {
            try {
                AbstractBalanceBean balanceBean = this.mode == 0 ? this.getContext().getPort(PaymentService.class).paymentGet(this.id) : this.getContext().getPort(ChargeService.class).chargeGet(this.id);
                this.summa.setText(Utils.formatCost(balanceBean.getSum()));
                this.date.setLocalDate(TimeUtils.convertDateToLocalDate(balanceBean.getDate()));
                this.comment.setText(balanceBean.getComment());
                this.pcPanel.setSelected(balanceBean.getTypeId());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else {
            this.date.setDateString(nowDateStr);
            this.summa.setText("");
            this.comment.setText("");
            this.pcPanel.setSelected(0);
        }
        if (this.mode == 0 && this.id <= 0) {
            this.paymentDictributePanel = new PaymentDistributePanel(1, this);
            this.paymentDictributePanel.init("contract", 0);
            this.paymentDictributePanel.setContractId(this.contractId);
            this.paymentDictributePanel.setData();
            if (this.paymentDictributePanel.getRowCount() > 1) {
                this.add((Component)this.paymentDictributePanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            } else {
                this.paymentDictributePanel = null;
            }
        }
        this.bgPluginnedPanel.invokeSetData(new Object[0]);
    }

    private void okPanelActionPerformed(ActionEvent e) throws Exception {
        switch (e.getActionCommand()) {
            case "reset": {
                this.setData();
                break;
            }
            case "ok": {
                Integer type = this.pcPanel.getSelectedId();
                if (type == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f");
                    return;
                }
                if (this.date.getDateCalendar() == null) {
                    ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                    return;
                }
                if (Utils.isBlankString(this.summa.getText())) {
                    ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0441\u0443\u043c\u043c\u0443");
                    return;
                }
                if (!this.bgPluginnedPanel.invokeBeforeAction(this.id, this.summa.getText(), this.mode, type)) {
                    return;
                }
                if (this.mode == 0) {
                    List<Integer> listId;
                    Payment payment = Payment.builder().setId(this.id).setUserId(0).setContractId(this.contractId).setTypeId(type).setDate(this.date.getDateCalendar().getTime()).setComment(this.comment.getText().trim()).setSum(Utils.parseBigDecimal(this.summa.getText(), BigDecimal.ZERO)).build();
                    String distribution = null;
                    if (this.paymentDictributePanel != null) {
                        String check = this.paymentDictributePanel.checkValidDistribution(this.summa.getText().trim());
                        if (!"ok".equals(check)) {
                            ClientUtils.showErrorMessageDialog(check);
                            return;
                        }
                        distribution = this.paymentDictributePanel.getDistribution();
                    }
                    if ((listId = this.getContext().getPort(PaymentService.class).paymentUpdate(payment, distribution)).size() == 0) {
                        ClientUtils.showMessageDialog("\u041d\u0435 \u043f\u0440\u0438\u0448\u0451\u043b id \u043f\u043b\u0430\u0442\u0435\u0436\u0430(-\u0435\u0439), \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u043d\u0435 \u0441\u0440\u0430\u0431\u043e\u0442\u0430\u044e\u0442");
                    }
                    this.bgPluginnedPanel.invokeDoAction(Utils.toString(listId), this.summa.getText(), this.mode, type);
                } else if (this.mode == 1 || this.mode == 2) {
                    Charge charge = new Charge(this.id, 0, this.contractId, type, this.date.getDateCalendar().getTime(), this.comment.getText().trim(), Utils.parseBigDecimal(this.summa.getText(), BigDecimal.ZERO), null);
                    charge.setPayback(this.mode == 2);
                    int idCharge = this.getContext().getPort(ChargeService.class).chargeUpdate(charge);
                    this.bgPluginnedPanel.invokeDoAction(String.valueOf(idCharge), this.summa.getText(), this.mode, type);
                }
                EventBus.publish((Object)new UpdateContractTreeEvent(0, this.contractId));
            }
            case "cancel": {
                this.dispose();
                break;
            }
            case "help": {
                this.openHelp(PaymentAndChargeEditor.class.getName());
            }
        }
    }

    public void setSumma(String fullSumma) {
        this.summa.setText(fullSumma);
    }

    public BGFloatTextField getSummaTextField() {
        return this.summa;
    }

    public int getContractId() {
        return this.contractId;
    }

    public void setButtonPanelEnabled(boolean value) {
        BGSwingUtilites.setEnabled(this.okPanel, true);
    }

    public PaymentAndChargeTreeTablePanel getPcPanel() {
        return this.pcPanel;
    }

    public int getId() {
        return this.id;
    }

    public BGControlPanelDateNoB getDatePanel() {
        return this.date;
    }
}

