/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.server.bean;

import java.lang.reflect.Method;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.common.Utils;

public class WebUtils {
    public static JSONObject getActionOperations() {
        JSONObject json = new JSONObject();
        JSONArray modules = new JSONArray();
        json.put("modules", (Object)modules);
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            JSONObject moduleJson = new JSONObject();
            moduleJson.put("name", (Object)module.getName());
            JSONArray moduleActions = new JSONArray();
            moduleJson.put("actions", (Object)moduleActions);
            modules.put((Object)moduleJson);
            WebUtils.doPackageClasses(module.getInstalledModule().getPackageServer() + ".action.web", moduleActions);
        }
        JSONArray plugins = new JSONArray();
        json.put("plugins", (Object)plugins);
        for (Map.Entry<String, BGPluginServer> entry : BGPluginManagerServer.getManager().getPluginsMap().entrySet()) {
            JSONObject pluginJson = new JSONObject();
            pluginJson.put("name", (Object)entry.getKey());
            JSONArray pluginActions = new JSONArray();
            pluginJson.put("actions", (Object)pluginActions);
            plugins.put((Object)pluginJson);
            WebUtils.doPackageClasses(entry.getValue().getPackServer() + ".action.web", pluginActions);
        }
        return json;
    }

    private static void doPackageClasses(String packageName, JSONArray actions) {
        for (Class clazz : Utils.getClassList((String)packageName)) {
            if (!clazz.isAnnotationPresent(WebAction.class)) continue;
            WebAction webAction = clazz.getAnnotation(WebAction.class);
            try {
                Class<AbstractAction> abstractActionClass = clazz.asSubclass(AbstractAction.class);
                JSONObject action = new JSONObject();
                action.put("action", (Object)clazz.getSimpleName().substring(6));
                action.put("title", (Object)webAction.title());
                JSONArray actionOperations = new JSONArray();
                action.put("operations", (Object)actionOperations);
                actions.put((Object)action);
                for (Method method : abstractActionClass.getMethods()) {
                    if (!method.isAnnotationPresent(WebOperation.class)) continue;
                    WebOperation webOperation = method.getAnnotation(WebOperation.class);
                    JSONObject operation = new JSONObject();
                    operation.put("operation", (Object)method.getName());
                    operation.put("title", (Object)webOperation.title());
                    actionOperations.put((Object)operation);
                }
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }
    }
}

