/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import jakarta.jws.WebService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.CustomerParameterProviderService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider.CustomerParameterProvider;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider.CustomerParameterProviderDaData;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.parameter.provider.CustomerParameterProviderPB;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.CustomerParameterProviderService")
public class CustomerParameterProviderServiceImpl
extends AbstractService
implements CustomerParameterProviderService {
    private static final Map<String, CustomerParameterProvider> CACHE = new HashMap<String, CustomerParameterProvider>();

    @Override
    public String searchParameters(String data, String searchImplementation) throws Exception {
        if (Utils.isBlankString(data)) {
            throw new RuntimeException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0418\u041d\u041d \u0438\u043b\u0438 \u041e\u0413\u0420\u041d \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430! ");
        }
        CustomerParameterProvider parameterProvider = this.defineParameterProvider(searchImplementation);
        JSONObject companyData = data.length() == 10 ? parameterProvider.searchDataByINN(data) : parameterProvider.searchDataByOGRN(data);
        companyData.put("bgMapping", (Object)this.parametersMapping());
        return companyData.toString();
    }

    private CustomerParameterProvider defineParameterProvider(String className) throws Exception {
        if (CACHE.isEmpty()) {
            this.initCache();
        }
        if (Utils.isBlankString(className)) {
            return CustomerParameterProviderDaData.getInstance();
        }
        return CACHE.getOrDefault(className, CustomerParameterProviderDaData.getInstance());
    }

    private JSONObject parametersMapping() {
        Setup setup = Setup.getSetup();
        JSONObject bgMapping = new JSONObject();
        bgMapping.put("title", setup.getInt("pb.title", -1));
        bgMapping.put("fullTitle", setup.getInt("pb.fullTitle", -1));
        bgMapping.put("regDate", setup.getInt("pb.regDate", -1));
        bgMapping.put("ogrn", setup.getInt("pb.ogrn", -1));
        bgMapping.put("inn", setup.getInt("pb.inn", -1));
        bgMapping.put("kpp", setup.getInt("pb.kpp", -1));
        bgMapping.put("address", setup.getInt("pb.address", -1));
        bgMapping.put("postIndex", setup.getInt("pb.postIndex", -1));
        bgMapping.put("supervisor.name", setup.getInt("pb.supervisor", -1));
        bgMapping.put("supervisor.position", setup.getInt("pb.supervisorPosition", -1));
        return bgMapping;
    }

    private void initCache() throws Exception {
        CACHE.put(CustomerParameterProviderDaData.getInstance().getGuiTitle(), CustomerParameterProviderDaData.getInstance());
        CACHE.put(CustomerParameterProviderPB.getInstance().getGuiTitle(), CustomerParameterProviderPB.getInstance());
        DynamicCodeService dynamicCodeService = this.context.getService(DynamicCodeService.class, 0);
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        dynamicCodeService.getDynamicClassesByInterface(CustomerParameterProvider.class.getName()).forEach(clazz -> {
            try {
                CustomerParameterProvider implClass = dynamicClassManager.newInstance(CustomerParameterProvider.class, clazz.getClassName());
                CACHE.put(implClass.getGuiTitle(), implClass);
            }
            catch (BGException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public List<String> getParametersSearchImplementation() throws Exception {
        if (CACHE.isEmpty()) {
            this.initCache();
        }
        return CACHE.keySet().stream().toList();
    }

    @Override
    public void updateContractParameters(int contractId, String parameters) throws Exception {
        JSONObject data = new JSONObject(parameters);
        JSONObject bgMapping = data.optJSONObject("bgMapping");
        ContractService contractService = this.context.getService(ContractService.class, 0);
        this.updateParameterText(contractService, bgMapping.optInt("title", -1), contractId, data.optString("title"));
        this.updateParameterText(contractService, bgMapping.optInt("fullTitle"), contractId, data.optString("fullTitle"));
        this.updateParameterDate(contractService, bgMapping.optInt("regDate"), contractId, data.optString("regDate"));
        this.updateParameterText(contractService, bgMapping.optInt("ogrn"), contractId, data.optString("ogrn"));
        this.updateParameterText(contractService, bgMapping.optInt("inn"), contractId, data.optString("inn"));
        this.updateParameterText(contractService, bgMapping.optInt("address"), contractId, data.optString("address"));
        this.updateParameterText(contractService, bgMapping.optInt("postIndex"), contractId, data.optString("postIndex"));
        this.updateParameterText(contractService, bgMapping.optInt("supervisor.name"), contractId, data.optString("supervisor.name"));
        this.updateParameterText(contractService, bgMapping.optInt("supervisor.position"), contractId, data.optString("supervisor.position"));
    }

    private void updateParameterText(ContractService contractService, int pid, int contractId, String value) throws Exception {
        if (pid <= 0 || contractId <= 0 || Utils.isBlankString(value)) {
            return;
        }
        contractService.contractParameterTextUpdate(contractId, new EntityAttrText(contractId, pid, value));
    }

    private void updateParameterDate(ContractService contractService, int contractId, int pid, String value) throws Exception {
        if (pid <= 0 && Utils.isBlankString(value)) {
            return;
        }
        Date date = TimeUtils.parseDate(value, "dd.MM.yyyy");
        if (date == null) {
            return;
        }
        contractService.contractParameterDateUpdate(contractId, new EntityAttrDate(contractId, pid, date));
    }
}

