/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.pattern.editors;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigBaseEditor;
import ru.bitel.bgbilling.client.common.pattern.editors.ConfigTitle;
import ru.bitel.common.Utils;

public class ConfigMultiDynamicEditor
extends ConfigBaseEditor {
    private BGTextField textField = new BGTextField();

    public ConfigMultiDynamicEditor() {
        this.addComp(this.textField);
    }

    public String showDialog(ConfigTitle selectTitle) {
        this.moveWindowToCenterScreen();
        this.originalValue = selectTitle.getValue();
        this.textField.setText(selectTitle.getValue());
        this.result = "cancel";
        this.defaultValue = selectTitle.getDefaultValue();
        if (!selectTitle.isBold()) {
            this.textField.setEnabled(false);
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
            this.textField.setEnabled(true);
        }
        return super.showDialog();
    }

    @Override
    public boolean checkValue(String keys) {
        return ConfigMultiDynamicEditor.checkValue(keys, null);
    }

    public static boolean checkValue(String valueStr, String validText) {
        Pattern pattern = Pattern.compile("((([A-Za-z0-9]+)((-[0-9]+)*)(;[A-Za-z0-9]+)*)+)([|](([A-Za-z0-9]+)((-[0-9]+)*)(;[A-Za-z0-9]+)*)+)*");
        Matcher m = pattern.matcher(valueStr);
        if (m.matches()) {
            return true;
        }
        pattern = Pattern.compile("(([0-9]+-[0-9]+)(;[0-9]+-[0-9]+)*)([|]([0-9]+-[0-9]+)(;[0-9]+-[0-9]+)*)+");
        m = pattern.matcher(valueStr);
        return m.matches();
    }

    public String[] getValues(String valueStr) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.checkValue(valueStr)) {
            Pattern pattern = Pattern.compile("([A-Za-z0-9]+)(;[A-Za-z0-9]+)*");
            Matcher m = pattern.matcher(valueStr);
            if (m.matches()) {
                return valueStr.split(";");
            }
            for (String limit : valueStr.split(";")) {
                int dounLimit = Utils.parseInt(limit.split("-")[0], -9999);
                int upLimit = Utils.parseInt(limit.split("-")[1], -9999);
                if (dounLimit == -9999 || upLimit == -9999) continue;
                for (int i = dounLimit; i < upLimit + 1; ++i) {
                    list.add(Integer.toString(i));
                }
            }
            return list.toArray(new String[list.size()]);
        }
        return null;
    }
}

