/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server;

import bitel.billing.server.ModuleBase;
import bitel.billing.server.contract.bean.CommentPatternManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractCommentUpdateEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.BGFutureTaskEvent;
import ru.bitel.bgbilling.kernel.event.worker.BGFutureTaskWorker;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.enums.ComponentType;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskStatus;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskType;
import ru.bitel.bgbilling.kernel.task.server.bean.BGFutureTaskDao;
import ru.bitel.bgbilling.server.WebMenu;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.xsl.server.worker.XslPatterWorker;

public class Module
extends ModuleBase {
    @Override
    public String[] getServerPackages() {
        return null;
    }

    @Override
    public void start(Connection con, BGModule module) throws BGException {
        new BGFutureTaskWorker().start();
        new XslPatterWorker().start();
        EventProcessor.getInstance().addListener(new EventListener<BGFutureTaskEvent>(){

            @Override
            public void notify(BGFutureTaskEvent futureTaskEvent, EventListenerContext ctx) throws BGException {
                try (Connection con1 = Setup.getSetup().getDBConnectionFromPool();){
                    BGFutureTaskDao futureTaskDao = new BGFutureTaskDao(con1);
                    int futureTaskId = futureTaskEvent.getFutureTask().getId();
                    BGFutureTask futureTask = (BGFutureTask)futureTaskDao.get(futureTaskId);
                    if (futureTask != null) {
                        switch (futureTask.getType()) {
                            case CONTRACT_STATUS: {
                                ContractStatus contractStatus = ContractStatus.fromJson(new JSONObject(futureTask.getData()));
                                ServerContext context = (ServerContext)ServerContext.get();
                                context.newService(ContractStatusService.class, 0).changeContractStatus(new int[]{contractStatus.getContractId()}, 0, contractStatus.getStatus(), contractStatus.getDateFrom(), contractStatus.getDateTo(), contractStatus.getComment(), true);
                                context.commit();
                                break;
                            }
                        }
                        futureTaskDao.updateStatus(BGFutureTaskType.CONTRACT_STATUS, futureTaskId, BGFutureTaskStatus.EXECUTED);
                        futureTaskDao.deleteOld(BGFutureTaskType.CONTRACT_STATUS, Setup.getSetup().getModuleSetup(ctx.getModuleId()).getInt("contract.status.task.period.days", 365));
                    }
                }
                catch (Exception ex) {
                    Module.this.logError(ex);
                }
            }
        }, BGFutureTaskEvent.class);
        EventProcessor.getInstance().addListener(new EventListener<ContractCommentUpdateEvent>(){

            @Override
            public void notify(final ContractCommentUpdateEvent event, EventListenerContext ctx) throws Exception {
                new Thread(){

                    @Override
                    public void run() {
                        try (Connection con1 = Setup.getSetup().getDBConnectionFromPool();){
                            new CommentPatternManager(con1).updateContractComment(event.getContractId());
                        }
                        catch (Exception ex) {
                            Module.this.logError(ex);
                        }
                    }
                }.start();
            }
        }, ContractCommentUpdateEvent.class);
    }

    @Override
    public List<MenuItem> getWebMenuItems(Connection con, String module, int moduleId, boolean all) throws Exception {
        BGInstalledModule kernel = new BGInstalledModule().setType(ComponentType.MODULE).setPackageServer(Module.class.getPackage().getName()).setName(module);
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        Element extension = kernel.getServerExtensionMap().get(WebMenu.class.getName());
        if (extension != null) {
            Setup setup = Setup.getSetup();
            Setup moduleSetup = moduleId == 0 ? setup : setup.getModuleSetup(moduleId);
            for (Element itemElement : XMLUtils.selectElements((Node)extension, (String)"item")) {
                int id = Utils.parseInt((String)itemElement.getAttribute("id"));
                MenuItem menuItem = new MenuItem().setId(id).setAction(itemElement.getAttribute("action")).setTitle(moduleSetup.get("web.menuItem" + id, itemElement.getAttribute("titleDefault"))).setModule(XMLUtils.getAttribute((Element)itemElement, (String)"module", (String)module)).setModuleId(moduleId).setIcon(itemElement.getAttribute("icon")).setDescription(itemElement.getAttribute("description")).setDefaultMenu(itemElement.getAttribute("defaultMenu"));
                if (!all && "none".equals(menuItem.getTitle())) continue;
                list.add(menuItem);
            }
        }
        return list;
    }
}

