/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.common.event;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Date;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;

@XmlRootElement
public class ProductPeriodModifiedEvent
extends Event {
    private static final long serialVersionUID = 1L;
    private final int accountId;
    private final int productSpecId;
    private final int productId;
    private final int activationModeId;
    private final Date productTimeFrom;
    private final Date productTimeTo;
    private final int productPeriodId;
    private final Date oldProductPeriodTimeFrom;
    private final Date oldProductPeriodTimeTo;
    private final Date prolongationTime;
    private final Date newProductPeriodTimeFrom;
    private final Date newProductPeriodTimeTo;
    private final int version;

    protected ProductPeriodModifiedEvent() {
        this.accountId = -1;
        this.productSpecId = -1;
        this.productId = -1;
        this.activationModeId = -1;
        this.productTimeFrom = null;
        this.productTimeTo = null;
        this.productPeriodId = -1;
        this.oldProductPeriodTimeFrom = null;
        this.oldProductPeriodTimeTo = null;
        this.prolongationTime = null;
        this.newProductPeriodTimeFrom = null;
        this.newProductPeriodTimeTo = null;
        this.version = -1;
    }

    public ProductPeriodModifiedEvent(int moduleId, int contractId, int userId, Product product, ProductPeriod oldProductPeriod, ProductPeriod newProductPeriod) {
        super(moduleId, contractId, userId);
        this.accountId = product.getAccountId();
        this.productSpecId = product.getProductSpecId();
        this.productId = product.getId();
        this.activationModeId = product.getActivationModeId();
        this.productTimeFrom = product.getTimeFrom();
        this.productTimeTo = product.getTimeTo();
        if (oldProductPeriod != null) {
            this.productPeriodId = oldProductPeriod.getId();
            this.oldProductPeriodTimeFrom = oldProductPeriod.getTimeFrom();
            this.oldProductPeriodTimeTo = oldProductPeriod.getTimeTo();
        } else {
            this.productPeriodId = newProductPeriod.getId();
            this.oldProductPeriodTimeFrom = null;
            this.oldProductPeriodTimeTo = null;
        }
        if (newProductPeriod != null) {
            this.newProductPeriodTimeFrom = newProductPeriod.getTimeFrom();
            this.newProductPeriodTimeTo = newProductPeriod.getTimeTo();
            this.prolongationTime = newProductPeriod.getProlongationTime();
            this.version = newProductPeriod.getVersion();
        } else {
            this.newProductPeriodTimeFrom = null;
            this.newProductPeriodTimeTo = null;
            this.prolongationTime = oldProductPeriod.getProlongationTime();
            this.version = oldProductPeriod.getVersion() + 1;
        }
    }

    public ProductPeriodModifiedEvent(int moduleId, int contractId, int accountId, int productSpecId, int productId, int activationModeId, Date productTimeFrom, Date productTimeTo, int productPeriodId, Date oldProductPeriodTimeFrom, Date oldProductPeriodTimeTo, Date newProductPeriodTimeFrom, Date newProductPeriodTimeTo, Date prolongationTime, int version) {
        super(moduleId, contractId, 0);
        this.accountId = accountId;
        this.productSpecId = productSpecId;
        this.productId = productId;
        this.activationModeId = activationModeId;
        this.productTimeFrom = productTimeFrom;
        this.productTimeTo = productTimeTo;
        this.productPeriodId = productPeriodId;
        this.oldProductPeriodTimeFrom = oldProductPeriodTimeFrom;
        this.oldProductPeriodTimeTo = oldProductPeriodTimeTo;
        this.prolongationTime = prolongationTime;
        this.newProductPeriodTimeFrom = newProductPeriodTimeFrom;
        this.newProductPeriodTimeTo = newProductPeriodTimeTo;
        this.version = version;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public int getProductSpecId() {
        return this.productSpecId;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getActivationModeId() {
        return this.activationModeId;
    }

    public Date getProductTimeFrom() {
        return this.productTimeFrom;
    }

    public Date getProductTimeTo() {
        return this.productTimeTo;
    }

    public int getProductPeriodId() {
        return this.productPeriodId;
    }

    public Date getOldProductPeriodTimeFrom() {
        return this.oldProductPeriodTimeFrom;
    }

    public Date getOldProductPeriodTimeTo() {
        return this.oldProductPeriodTimeTo;
    }

    public Date getProlongationTime() {
        return this.prolongationTime;
    }

    public Date getNewProductPeriodTimeFrom() {
        return this.newProductPeriodTimeFrom;
    }

    public Date getNewProductPeriodTimeTo() {
        return this.newProductPeriodTimeTo;
    }

    public int getVersion() {
        return this.version;
    }
}

