/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class CostAdditionTariffTreeNode
extends DefaultTariffTreeNode {
    public static final String NAME = "cost_addition";
    public static final int OPERATION_ADDITION = 1;
    public static final int OPERATION_SUBTRACTION = 2;
    public static final int SUBJECT_MINUTE = 1;
    public static final int SUBJECT_SESSION = 2;
    private float value;
    private int operation;
    private int subject;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> map = this.getDataInHash();
        this.value = Utils.parseFloat((String)map.get("value"), (float)0.0f);
        String oper = map.get("operation");
        if ("+".equals(oper)) {
            this.operation = 1;
        } else if ("-".equals(oper)) {
            this.operation = 2;
        }
        this.subject = Utils.parseInt((String)map.get("subject"), (int)0);
        if (this.value <= 0.0f || this.operation != 1 && this.operation != 2 || this.subject != 1 && this.subject != 2) {
            this.value = 0.0f;
            this.operation = 0;
            this.subject = 0;
        } else if (this.operation == 2) {
            this.value = -this.value;
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        if (this.operation != 0) {
            request.setResponseParam(NAME, this);
        }
    }

    public float getValue() {
        return this.value;
    }

    public int getSubject() {
        return this.subject;
    }
}

