/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.ip.dynamic;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.worker.WorkerThreadFactory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpCategoryRuntime;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntime;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntimeManager;

public class IpResourceReserveManager
extends AbstarctDaoConstant
implements Runnable {
    private DefaultServerSetup setup;
    private ReentrantLock lock = new ReentrantLock();
    public Set<String> names = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile int minFetchSize;
    private volatile int maxFetchSize;
    private volatile int fetchSize;
    private volatile int needFetchSize;
    private final int timeout = 10;
    private final LinkedHashSet<Integer> ipResourceCategoryIds;
    private final IpResourceRuntimeManager manager;
    private volatile ScheduledFuture<?> task = null;
    private static final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(8, (ThreadFactory)new WorkerThreadFactory("ip-dyn-reserve", null, null));
    private final ArrayBlockingQueue<IpResourceReserve> reserved;
    private final ConcurrentLinkedQueue<IpResourceReserve> free = new ConcurrentLinkedQueue();
    private int mode = 2;
    private volatile double alarmFreePercent = 10.0;
    private volatile int alarmFreeCount = 300;
    private boolean categoryRoundRobin = false;
    private boolean categoryRoundRobinLeastConn = false;
    private boolean microPool = false;
    private volatile boolean manyIpResources = false;
    private static final ReentrantLock MAIN_LOCK = new ReentrantLock();
    private volatile long reserveErrorLastTime;
    private volatile long reserveErrorCount;
    private volatile long reloadLastTime;

    IpResourceReserveManager(Setup setup, int moduleId, LinkedHashSet<Integer> categories, IpResourceRuntimeManager manager) {
        super(null, "inv_ip_resource_dyn_reserve", moduleId);
        this.setup = setup;
        this.ipResourceCategoryIds = categories;
        this.manager = manager;
        ModuleSetup moduleSetup = setup.getModuleSetup(moduleId);
        if (moduleSetup == null) {
            this.minFetchSize = 20;
            this.maxFetchSize = 180;
        } else {
            this.minFetchSize = setup.getInt("ipResource.reserve.minFetchSize", moduleSetup.getInt("ipResource.reserve.minFetchSize", 20));
            this.maxFetchSize = setup.getInt("ipResource.reserve.maxFetchSize", moduleSetup.getInt("ipResource.reserve.maxFetchSize", 180));
        }
        this.mode = setup.getInt("ipResource.reserve.mode", moduleSetup.getInt("ipResource.reserve.mode", 1));
        this.getLogger().info("minFetchSize: {}; maxFetchSize: {}; mode: {}", new Object[]{this.minFetchSize, this.maxFetchSize, this.mode});
        this.fetchSize = 50;
        this.needFetchSize = this.fetchSize / 5;
        this.reserved = new ArrayBlockingQueue(this.maxFetchSize * 10);
        new Thread(() -> {
            try {
                this.microPool = this.manager.getSize(this.ipResourceCategoryIds) <= 40L;
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }, "ip-resource-reserve-manager-init").start();
        AnnotatedMBean.register((Object)this, (String)Utils.toString(categories, (String)"-"));
    }

    public IpResourceReserve reserve() {
        IpResourceReserve result = this.reserveImpl();
        if (result != null) {
            result.setReserveTime(System.currentTimeMillis());
            this.free.add(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IpResourceReserve reserveImpl() {
        long millis = System.currentTimeMillis();
        IpResourceReserve reserve = this.reserveImpl0(millis);
        if (reserve != null) {
            return reserve;
        }
        try {
            if (!this.lock.tryLock(9L, TimeUnit.SECONDS)) {
                this.getLogger().error("Timeout waiting ipResourceReserveManager lock!");
                return null;
            }
            try {
                reserve = this.reserveImpl0(millis);
                if (reserve != null) {
                    IpResourceReserve ipResourceReserve = reserve;
                    return ipResourceReserve;
                }
                this.reserveBatch(true);
                reserve = this.reserved.poll();
                while (reserve != null && reserve.getTimeout() < millis) {
                    reserve = this.reserved.poll();
                }
                if (reserve != null) {
                    IpResourceReserve ipResourceReserve = reserve;
                    return ipResourceReserve;
                }
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException ex) {
            BGLogger.error(ex);
            return null;
        }
        reserve = this.reserved.poll();
        while (reserve != null && reserve.getTimeout() < millis) {
            reserve = this.reserved.poll();
        }
        if (reserve == null) return null;
        return reserve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpResourceReserve reserveImpl0(long millis) {
        IpResourceReserve reserve;
        block12: {
            reserve = this.reserved.poll();
            while (reserve != null && reserve.getTimeout() < millis) {
                this.free.add(reserve);
                reserve = this.reserved.poll();
            }
            if (reserve == null) {
                return null;
            }
            if (this.reserved.size() < this.needFetchSize) {
                try {
                    if (this.lock.tryLock(1L, TimeUnit.SECONDS)) {
                        this.getLogger().debug("Force reserveBatch.");
                        try {
                            ScheduledFuture<?> task = this.task;
                            if (task != null && !task.isDone()) {
                                if (task.getDelay(TimeUnit.MILLISECONDS) > 60L) {
                                    task.cancel(false);
                                    this.task = scheduler.schedule(this, 0L, TimeUnit.MILLISECONDS);
                                }
                            } else {
                                this.task = scheduler.schedule(this, 0L, TimeUnit.MILLISECONDS);
                            }
                            break block12;
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                    this.getLogger().debug("Timeout wait lock for force reserveBatch.");
                }
                catch (InterruptedException ex) {
                    BGLogger.error(ex);
                }
            }
        }
        return reserve;
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            this.reserveBatch(false);
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean reserveBatchStandalone(int max, boolean force) throws Exception {
        long now = System.currentTimeMillis();
        long lastMinute = now - 60000L;
        int result = 0;
        long millis = System.currentTimeMillis();
        IpResourceReserve reserve = this.reserved.peek();
        while (reserve != null && reserve.getTimeout() < millis) {
            reserve = this.reserved.poll();
            reserve.setReserveTime(millis);
            this.free.add(reserve);
            reserve = this.reserved.peek();
        }
        reserve = this.free.poll();
        while (reserve != null) {
            reserve.setTimeout(millis);
            ConcurrentMap resource = (ConcurrentMap)IpResourceRuntime.staticReserved.get(reserve.getIpResourceId());
            if (resource != null) {
                resource.put(new IpAddress(reserve.getAddress()), reserve.getTimeout());
            }
            reserve = this.free.poll();
        }
        this.freeByTimeout(lastMinute);
        ArrayList<IpResourceReserve> list = new ArrayList<IpResourceReserve>(max > 10 ? max : 10);
        if (this.categoryRoundRobin) {
            max = this.categoryRoundRobinReserve(max, now, list);
        } else {
            this.manager.reserve(list, this.ipResourceCategoryIds, now, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES), max);
        }
        result += list.size();
        for (IpResourceReserve res : list) {
            this.reserved.add(res);
        }
        return result >= max || result >= 20;
    }

    private void freeByTimeout(long lastMinute) {
        if (!this.manyIpResources && IpResourceRuntime.staticReserved.size() > 100) {
            this.manyIpResources = true;
        }
        if (this.manyIpResources) {
            for (Integer categoryId : this.ipResourceCategoryIds) {
                IpCategoryRuntime categoryRuntime = (IpCategoryRuntime)this.manager.getLoadedCategoryMap().get(categoryId);
                if (categoryRuntime == null) continue;
                IpResourceRuntime[] resources = categoryRuntime.getIpResources();
                for (int i = 0; i < resources.length; ++i) {
                    IpResourceRuntime resource = resources[i];
                    ConcurrentMap map = (ConcurrentMap)IpResourceRuntime.staticReserved.get(resource.id);
                    if (map == null) continue;
                    Iterator iter = map.values().iterator();
                    while (iter.hasNext()) {
                        Long time = (Long)iter.next();
                        if (time >= lastMinute) continue;
                        iter.remove();
                    }
                }
            }
        } else {
            for (ConcurrentMap resource : IpResourceRuntime.staticReserved.values()) {
                Iterator iter = resource.values().iterator();
                while (iter.hasNext()) {
                    Long time = (Long)iter.next();
                    if (time >= lastMinute) continue;
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reserveBatch(Connection con, int max) throws Exception {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("LOCK TABLES " + this.tableName + " WRITE");
        long now = System.currentTimeMillis();
        long lastMinute = now - 60000L;
        int result = 0;
        try {
            PreparedStatement ps = con.prepareStatement("DELETE FROM " + this.tableName + " WHERE timeout<?");
            ps.setLong(1, lastMinute);
            int deleteCount = ps.executeUpdate();
            this.getLogger().debug("Deleted " + deleteCount + " old IPs");
            ps.close();
            long millis = System.currentTimeMillis();
            IpResourceReserve reserve = this.reserved.peek();
            while (reserve != null && reserve.getTimeout() < millis) {
                reserve = this.reserved.poll();
                reserve.setReserveTime(millis);
                this.free.add(reserve);
                reserve = this.reserved.peek();
            }
            PreparedStatement updatePS = con.prepareStatement("UPDATE " + this.tableName + " SET timeout=? WHERE timeout=? AND ipResourceId=? AND address=?");
            PreparedStatement deletePS = con.prepareStatement("DELETE FROM " + this.tableName + " WHERE timeout=? AND ipResourceId=? AND address=?");
            reserve = this.free.poll();
            while (reserve != null) {
                long reserveTimeout = reserve.getTimeout();
                long reserveTime = reserve.getReserveTime();
                if (reserveTimeout < lastMinute || reserveTime > 0L && reserveTime < lastMinute) {
                    deletePS.setLong(1, reserveTimeout);
                    deletePS.setInt(2, reserve.getIpResourceId());
                    deletePS.setBytes(3, reserve.getAddress());
                    deletePS.executeUpdate();
                } else if (now < reserveTimeout && reserveTime == 0L || reserveTime < reserveTimeout) {
                    if (reserveTime > 0L) {
                        updatePS.setLong(1, reserveTime);
                    } else {
                        updatePS.setLong(1, now);
                    }
                    updatePS.setLong(2, reserveTimeout);
                    updatePS.setInt(3, reserve.getIpResourceId());
                    updatePS.setBytes(4, reserve.getAddress());
                    updatePS.executeUpdate();
                }
                reserve = this.free.poll();
            }
            updatePS.close();
            deletePS.close();
            int currentIpResourceId = -1;
            ConcurrentMap currentResource = null;
            ResultSet rs = stmt.executeQuery("SELECT ipResourceId, address, timeout FROM " + this.tableName + " ORDER BY ipResourceId");
            while (rs.next()) {
                int ipResourceId = rs.getInt(1);
                byte[] address = rs.getBytes(2);
                long timeout = rs.getLong(3);
                if (currentIpResourceId != ipResourceId) {
                    currentResource = (ConcurrentMap)IpResourceRuntime.staticReserved.get(ipResourceId);
                    currentIpResourceId = ipResourceId;
                }
                if (currentResource == null) continue;
                currentResource.put(new IpAddress(address), timeout);
            }
            for (ConcurrentMap resource : IpResourceRuntime.staticReserved.values()) {
                Iterator iter = resource.values().iterator();
                while (iter.hasNext()) {
                    Long time = (Long)iter.next();
                    if (time >= lastMinute) continue;
                    iter.remove();
                }
            }
            ArrayList<IpResourceReserve> list = new ArrayList<IpResourceReserve>(max);
            if (this.categoryRoundRobin) {
                max = this.categoryRoundRobinReserve(max, now, list);
            } else {
                this.manager.reserve(list, this.ipResourceCategoryIds, now, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES), max);
            }
            PreparedStatement ps2 = con.prepareStatement("INSERT INTO " + this.tableName + " (ipResourceId, address, timeout) VALUES (?,?,?)");
            result += list.size();
            for (IpResourceReserve res : list) {
                ps2.setInt(1, res.getIpResourceId());
                ps2.setBytes(2, res.getAddress());
                ps2.setLong(3, res.getTimeout());
                ps2.executeUpdate();
                this.reserved.add(res);
            }
            ps2.close();
        }
        finally {
            stmt.executeUpdate("UNLOCK TABLES");
        }
        stmt.close();
        return result >= max || result >= 20;
    }

    private int categoryRoundRobinReserve(int max, long now, List<IpResourceReserve> result) throws Exception {
        int cmax = max / this.ipResourceCategoryIds.size();
        max = cmax * this.ipResourceCategoryIds.size();
        int count = 0;
        ArrayList clistList = new ArrayList();
        for (Integer c : this.ipResourceCategoryIds) {
            if (this.categoryRoundRobinLeastConn) {
                cmax = this.getCmaxLeastConn(max, c);
            }
            ArrayList<IpResourceReserve> clist = new ArrayList<IpResourceReserve>(cmax);
            this.manager.reserve(clist, Collections.singleton(c), now, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES), cmax);
            count += clist.size();
            clistList.add(clist);
        }
        IpResourceReserveManager.merge(clistList, result);
        if (max > count + 13 && !this.categoryRoundRobinLeastConn) {
            this.manager.reserve(result, this.ipResourceCategoryIds, now, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES), max - count);
        }
        return max;
    }

    private static <T> List<T> merge(List<List<T>> lists, List<T> result) {
        int max = 0;
        int lsize = lists.size();
        for (int i = 0; i < lsize; ++i) {
            List<T> l = lists.get(i);
            int size = l.size();
            if (size <= max) continue;
            max = size;
        }
        for (int c = 0; c < max; ++c) {
            int lsize2 = lists.size();
            for (int i = 0; i < lsize2; ++i) {
                List<T> l = lists.get(i);
                if (l.size() <= c) continue;
                result.add(l.get(c));
            }
        }
        return result;
    }

    private int getCmaxLeastConn(int max, int categoryId) throws Exception {
        long occupiedCount;
        int cmax = max / this.ipResourceCategoryIds.size();
        long maxOccupiedCount = occupiedCount = this.manager.getOccupiedCount(Collections.singleton(categoryId));
        for (Integer c : this.ipResourceCategoryIds) {
            if (c == categoryId) continue;
            maxOccupiedCount = Math.max(this.manager.getOccupiedCount(Collections.singleton(c)), occupiedCount);
        }
        if (maxOccupiedCount > occupiedCount && maxOccupiedCount - occupiedCount > (long)cmax) {
            cmax *= 2;
        }
        return cmax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void reserveBatch(boolean force) throws Exception {
        block40: {
            mainLock = IpResourceReserveManager.MAIN_LOCK;
            mainLock.lock();
            try {
                if (this.reserved.size() >= this.fetchSize * 2) break block40;
                millis = System.currentTimeMillis();
                if (this.reserveErrorLastTime > 0L && millis - 8000L < this.reserveErrorLastTime) {
                    if (!this.microPool || force) {
                        this.getLogger().error("Skip batch reserve for IP-addresses due to almost empty pull.");
                        if (this.reserveErrorCount > 2L && millis > this.reloadLastTime + TimeUnit.HOURS.toMillis(3L)) {
                            this.reloadLastTime = millis;
                            this.getLogger().error("Another error when batch reserve. Try reload IP-resources from DB");
                            this.manager.reload(this.ipResourceCategoryIds);
                        }
                    }
                    return;
                }
                if (force) {
                    if (this.fetchSize < this.maxFetchSize) {
                        this.fetchSize = this.fetchSize >= 50 ? Math.min(this.fetchSize + 20, this.maxFetchSize) : Math.min(this.fetchSize + 10, this.maxFetchSize);
                        this.needFetchSize = this.fetchSize / 5;
                    }
                    max = this.fetchSize;
                } else {
                    if (this.fetchSize > this.minFetchSize && (double)this.reserved.size() > (double)this.needFetchSize * 1.5 && ThreadLocalRandom.current().nextBoolean()) {
                        this.fetchSize = Math.max(this.fetchSize - 1, this.minFetchSize);
                        this.needFetchSize = this.fetchSize / 5;
                    }
                    max = Math.max(this.fetchSize * 2 - this.reserved.size(), this.fetchSize);
                }
                switch (this.mode) {
                    case 0: {
                        try {
                            if (this.reserveBatchStandalone(max, force)) {
                                this.reserveErrorLastTime = 0L;
                                this.reserveErrorCount = 0L;
                                ** break;
lbl31:
                                // 1 sources

                            } else {
                                this.reserveErrorLastTime = System.currentTimeMillis();
                                ++this.reserveErrorCount;
                                ** break;
                            }
lbl35:
                            // 1 sources

                            break;
                        }
                        catch (SQLException e) {
                            throw new BGException((Throwable)e);
                        }
                    }
                    case 2: {
                        con = this.setup.getDBConnectionFromPool();
                        try {
                            con.setAutoCommit(false);
                            if (this.reserveBatch(con, max)) {
                                this.reserveErrorLastTime = 0L;
                                this.reserveErrorCount = 0L;
                            } else {
                                this.reserveErrorLastTime = System.currentTimeMillis();
                                ++this.reserveErrorCount;
                            }
                            con.commit();
                            break;
                        }
                        catch (SQLException e) {
                            throw new BGException((Throwable)e);
                        }
                        finally {
                            ServerUtils.closeConnection(con);
                        }
                    }
                    default: {
                        con = this.setup.getDBConnectionFromPool();
                        try {
                            if (this.reserveBatch(con, max)) {
                                this.reserveErrorLastTime = 0L;
                                this.reserveErrorCount = 0L;
                            } else {
                                this.reserveErrorLastTime = System.currentTimeMillis();
                                ++this.reserveErrorCount;
                            }
                            break;
                        }
                        catch (SQLException e) {
                            throw new BGException((Throwable)e);
                        }
                        finally {
                            ServerUtils.closeConnection(con);
                        }
                    }
                }
            }
            finally {
                mainLock.unlock();
            }
        }
        try {
            size = this.manager.getSize(this.ipResourceCategoryIds);
            occupiedCount = this.manager.getOccupiedCount(this.ipResourceCategoryIds);
            percent = (double)occupiedCount * 100.0 / (double)size;
            if (percent > 100.0 - this.alarmFreePercent && size - occupiedCount < (long)this.alarmFreeCount) {
                key = "inet.ipResource.fullness.alarm";
                message = "\u0412 \u043f\u0443\u043b\u0435 IP-\u0430\u0434\u0440\u0435\u0441\u043e\u0432 " + Utils.toString(this.ipResourceCategoryIds) + ", \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0435\u043c\u0441\u044f \u0432 " + String.valueOf(this.names) + " \u0437\u0430\u043d\u044f\u0442\u043e " + occupiedCount + " \u0438\u0437 " + size + " \u0430\u0434\u0440\u0435\u0441\u043e\u0432.";
                AlarmSender.sendAlarm(key, 180000L, "\u041f\u0443\u043b IP-\u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0438\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043d\u0430 " + ((int)percent - 1) + " \u043f\u0440\u043e\u0446\u0435\u043d\u0442\u043e\u0432", message);
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        this.lock.lock();
        try {
            task = this.task;
            if (task != null && !task.isDone()) {
                task.cancel(false);
            }
            this.task = IpResourceReserveManager.scheduler.schedule(this, 9L, TimeUnit.MINUTES);
        }
        finally {
            this.lock.unlock();
        }
    }

    public LinkedHashSet<Integer> getIpResourceCategoryIds() throws BGException {
        return this.ipResourceCategoryIds;
    }

    @MBeanAttribute
    public long getSize() throws Exception {
        return this.manager.getSize(this.ipResourceCategoryIds);
    }

    @MBeanAttribute
    public long getOccupiedCount() throws Exception {
        return this.manager.getOccupiedCount(this.ipResourceCategoryIds);
    }

    @MBeanAttribute
    public long getLocalReservedCount() throws BGException {
        return this.reserved.size();
    }

    @MBeanAttribute
    public long getReservedCount() throws Exception {
        return this.manager.getReservedCount(this.ipResourceCategoryIds);
    }

    @MBeanAttribute
    public Set<String> getNames() {
        return this.names;
    }

    @MBeanAttribute
    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @MBeanAttribute
    public double getAlarmFreePercent() {
        return this.alarmFreePercent;
    }

    public void setAlarmFreePercent(double alarmFreePercent) {
        if (alarmFreePercent < 0.0) {
            return;
        }
        this.alarmFreePercent = alarmFreePercent;
    }

    @MBeanAttribute
    public int getAlarmFreeCount() {
        return this.alarmFreeCount;
    }

    public void setAlarmFreeCount(int alarmFreeCount) {
        if (alarmFreeCount < 0) {
            return;
        }
        this.alarmFreeCount = alarmFreeCount;
    }

    @MBeanAttribute
    public boolean isCategoryRoundRobin() {
        return this.categoryRoundRobin;
    }

    public void setCategoryRoundRobin(boolean roundRobin) {
        this.categoryRoundRobin = roundRobin;
    }

    @MBeanAttribute
    public int getMinFetchSize() {
        return this.minFetchSize;
    }

    public void setMinFetchSize(int minFetchSize) {
        this.minFetchSize = minFetchSize;
    }

    @MBeanAttribute
    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public void pauseBatchReserve() {
        this.lock.lock();
        try {
            ScheduledFuture<?> task = this.task;
            if (task != null && !task.isDone()) {
                task.cancel(false);
            }
            this.task = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @MBeanAttribute
    public boolean isCategoryRoundRobinLeastConn() {
        return this.categoryRoundRobinLeastConn;
    }

    public void setCategoryRoundRobinLeastConn(boolean categoryRoundRobinLeastConn) {
        this.categoryRoundRobinLeastConn = categoryRoundRobinLeastConn;
    }

    public void setConfig(IpResourceReserveManagerConfig config) {
        this.setAlarmFreePercent(config.alarmFreePercent);
        this.setAlarmFreeCount(config.alarmFreeCount);
        this.setCategoryRoundRobin(config.categoryRoundRobin);
        this.setCategoryRoundRobinLeastConn(config.categoryRoundRobinLeastConn);
    }

    public static final class IpResourceReserveManagerConfig {
        public double alarmFreePercent = 10.0;
        public int alarmFreeCount = 300;
        public boolean categoryRoundRobin = false;
        public boolean categoryRoundRobinLeastConn = false;
    }
}

