/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import bitel.billing.common.XMLStreamResolver;
import bitel.billing.module.admin.resource.ResourceCategoriesTreePanel;
import bitel.billing.module.admin.resource.ResourceUseHistory;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLStreamReader;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;

public abstract class ResourceManager
extends BGPanel {
    protected BGTable table = new BGTable();
    protected ResourceCategoriesTreePanel categoriesTree;
    protected ResourceUseHistory historyPanel;
    protected String actionPrefix;
    protected int count = 0;

    public ResourceManager() {
        this.init();
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.categoriesTree, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.categoriesTree.setMinimumSize(new Dimension(300, 100));
        this.categoriesTree.setPreferredSize(new Dimension(300, 100));
        this.initManager();
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.categoriesTree.init(module, mid);
        this.historyPanel.init(module, mid);
    }

    @Override
    public void setData() {
        this.categoriesTree.setData();
    }

    protected void showForCategory() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction(this.actionPrefix + "Table");
        req.setModuleId(this.getModuleId());
        req.setAttribute("category_id", this.categoriesTree.getSelectedId());
        if (this.addFilterParams(req)) {
            InputStream is = this.getInputStream(req);
            XMLStreamResolver.XMLStreamResolverParam tableRes = new XMLStreamResolver.XMLStreamResolverParam("/data/table/data/row", new XMLStreamResolver(){

                @Override
                public void resolveElement(XMLStreamReader r) throws BGException {
                    ResourceManager.this.table.addRow(r);
                    if (++ResourceManager.this.count == 10000 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a \u0434\u043e\u0441\u0442\u0438\u0433\u043b\u043e 10000. \u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 1) {
                        throw new BGException("break");
                    }
                }
            }){

                @Override
                protected void startDocument() {
                    ResourceManager.this.count = 0;
                    ResourceManager.this.table.removeRows();
                }
            };
            XMLStreamResolver.XMLStreamResolverReader.processAndCheckStatus(is, this, tableRes);
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean addFilterParams(Request req) {
        return true;
    }

    protected abstract void init();

    protected abstract void initManager();

    protected BGButton createSyncButton() {
        BGButton syncButton = new BGButton("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043d\u044f\u0442\u044b\u0435");
        syncButton.addActionListener(actionEvent -> {
            Request request;
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043d\u044f\u0442\u044b\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u044b?", "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f", 0) == 0 && ClientUtils.checkStatus(this.getDocument(request = new Request().setModule(this.module).setAction("SynchronizeResources").setModuleId(this.getModuleId())))) {
                this.showForCategory();
            }
        });
        return syncButton;
    }
}

