/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;

public class AddressParamCache
extends BGLogger {
    private static final Object mutex = new Object();
    private static volatile AddressParamCache cache;
    private Map<Integer, Map<Integer, List<Map<String, Object>>>> addressMap = new HashMap<Integer, Map<Integer, List<Map<String, Object>>>>();
    private Map<Integer, List<Map<String, Object>>> houseMap = new HashMap<Integer, List<Map<String, Object>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddressParamCache getCache(Connection con) {
        Object object = mutex;
        synchronized (object) {
            if (cache == null) {
                cache = new AddressParamCache(con);
            }
        }
        return cache;
    }

    public static final void dropCache() {
        cache = null;
    }

    private AddressParamCache(Connection con) {
        int paramCount = 0;
        int houseCount = 0;
        long time = System.currentTimeMillis();
        try {
            String query = "SELECT cid, pid, hid, flat, room, pod, floor FROM contract_parameter_type_2";
            PreparedStatement ps = con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.addItem(rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getString(4), rs.getString(5), rs.getInt(6), rs.getInt(7));
                ++paramCount;
            }
            rs.close();
            ps.close();
            query = "SELECT id, streetid, areaid, quarterid, house, frac FROM address_house";
            ps = con.prepareStatement(query);
            rs = ps.executeQuery();
            while (rs.next()) {
                this.addHouseItem(rs.getInt(1), rs.getInt(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), rs.getString(6));
                ++houseCount;
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        this.getLogger().debug("Rebuild AddressParamCache on {} ms. ( {}/{} record )", new Object[]{System.currentTimeMillis() - time, paramCount, houseCount});
    }

    private void addItem(int cid, int pid, int hid, String flat, String room, int pod, int floor) {
        List<Map<String, Object>> items;
        Map<Integer, List<Map<String, Object>>> params = this.addressMap.get(hid);
        if (params == null) {
            params = new HashMap<Integer, List<Map<String, Object>>>(5, 0.9f);
            this.addressMap.put(hid, params);
        }
        if ((items = params.get(pid)) == null) {
            items = new ArrayList<Map<String, Object>>();
            params.put(pid, items);
        }
        HashMap<String, Object> itemMap = new HashMap<String, Object>(5);
        itemMap.put("flat", flat);
        if (room != null && room.length() > 0) {
            itemMap.put("room", room);
        }
        if (pod > 0) {
            itemMap.put("pod", pod);
        }
        if (floor > 0) {
            itemMap.put("floor", floor);
        }
        itemMap.put("cid", cid);
        items.add(itemMap);
    }

    private void addHouseItem(int id, int streetId, int areaId, int quarterId, int house, String frac) {
        List<Map<String, Object>> houses = this.houseMap.get(streetId);
        if (houses == null) {
            houses = new ArrayList<Map<String, Object>>();
            this.houseMap.put(streetId, houses);
        }
        HashMap<String, Object> itemMap = new HashMap<String, Object>(5);
        itemMap.put("house", house);
        if (frac != null) {
            itemMap.put("frac", frac);
        }
        if (areaId > 0) {
            itemMap.put("areaId", areaId);
        }
        if (quarterId > 0) {
            itemMap.put("quarterId", quarterId);
        }
        itemMap.put("id", id);
        houses.add(itemMap);
    }

    public Set<Integer> findContract(int hid, String flat, String room, int pod, int floor, Set<Integer> parameters) {
        long time = System.currentTimeMillis();
        HashSet<Integer> result = new HashSet<Integer>();
        Map<Integer, List<Map<String, Object>>> params = this.addressMap.get(hid);
        if (params != null) {
            for (Map.Entry<Integer, List<Map<String, Object>>> me : params.entrySet()) {
                if (!parameters.contains(me.getKey())) continue;
                for (Map<String, Object> itemMap : me.getValue()) {
                    Integer itemPod = (Integer)itemMap.get("pod");
                    Integer itemFloor = (Integer)itemMap.get("floor");
                    boolean flag = flat == null ? true : flat.equals((String)itemMap.get("flat"));
                    flag &= room == null ? true : room.equals((String)itemMap.get("room"));
                    flag &= pod < 1 ? true : itemPod == null || itemPod == pod;
                    if (!(flag &= floor < 1 ? true : itemFloor == null || itemFloor == floor)) continue;
                    result.add((Integer)itemMap.get("cid"));
                }
            }
        }
        this.getLogger().debug("FindContract on {} ms. ( {} record )", (Object)(System.currentTimeMillis() - time), (Object)result.size());
        return result;
    }

    public Set<Integer> findHouse(int streetId, int areaId, int quarterId, int house, String frac) {
        long time = System.currentTimeMillis();
        HashSet<Integer> result = new HashSet<Integer>();
        List<Map<String, Object>> houses = this.houseMap.get(streetId);
        if (houses != null) {
            for (Map<String, Object> itemMap : houses) {
                boolean flag;
                Integer itemHouse = (Integer)itemMap.get("house");
                Integer itemAreaId = (Integer)itemMap.get("areaId");
                Integer itemQuarterId = (Integer)itemMap.get("quarterId");
                boolean bl = flag = frac == null ? true : frac.equals((String)itemMap.get("frac"));
                flag &= house < 1 ? true : itemHouse == null || itemHouse == house;
                flag &= areaId < 1 ? true : itemAreaId == null || itemAreaId == areaId;
                if (!(flag &= quarterId < 1 ? true : itemQuarterId == null || itemQuarterId == quarterId)) continue;
                result.add((Integer)itemMap.get("id"));
            }
        }
        this.getLogger().debug("FindHouse on {} ms. ( {} record )", (Object)(System.currentTimeMillis() - time), (Object)result.size());
        return result;
    }
}

