/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@WebFilter(filterName="XSSFilter", urlPatterns={"/webexecuter"})
public class XSSFilter
implements Filter {
    private static final Pattern pattern = Pattern.compile("<img|<script|<a |<iframe");
    protected static final Logger logger = LogManager.getLogger();

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.debug("init filter " + filterConfig.getFilterName());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)new RequestWrapper((HttpServletRequest)request), response);
    }

    static final class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest servletRequest) {
            super(servletRequest);
        }

        public String[] getParameterValues(String parameter) {
            String[] values = super.getParameterValues(parameter);
            if (values == null) {
                return null;
            }
            int count = values.length;
            String[] encodedValues = new String[count];
            for (int i = 0; i < count; ++i) {
                encodedValues[i] = this.cleanXSS(values[i]);
            }
            return encodedValues;
        }

        public String getParameter(String parameter) {
            String value = super.getParameter(parameter);
            if (value == null) {
                return null;
            }
            return this.cleanXSS(value);
        }

        public String getHeader(String name) {
            String value = super.getHeader(name);
            if (value == null) {
                return null;
            }
            return this.cleanXSS(value);
        }

        private String cleanXSS(String value) {
            return pattern.matcher(value).replaceAll("");
        }
    }
}

