/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.common.Utils;

public class ContractAccountDao
extends AbstarctDaoConstant {
    public ContractAccountDao(Connection con) {
        super(con, "contract_account", 0);
    }

    public List<Integer> getContractIds(List<Integer> contractIds, int year, int mount, List<Integer> serviceIds) throws SQLException {
        if (serviceIds == null || serviceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> resultContractIds = new ArrayList<Integer>();
        String query = "SELECT DISTINCT cid FROM contract_account WHERE sid IN ( " + Utils.toString(serviceIds) + " ) AND yy=? AND mm=?";
        if (contractIds != null && !contractIds.isEmpty()) {
            query = query + " AND cid IN ( " + Utils.toString(contractIds) + " )";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, year);
            ps.setInt(2, mount);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    resultContractIds.add(rs.getInt(1));
                }
            }
        }
        return resultContractIds;
    }

    public void deleteContractAccounts(List<Integer> contractIds, int year, int mount, List<Integer> serviceIds) throws SQLException {
        if (serviceIds == null || serviceIds.isEmpty()) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE sid IN ( " + Utils.toString(serviceIds) + " ) AND yy=? AND mm=?";
        if (contractIds != null && !contractIds.isEmpty()) {
            query = query + " AND cid IN ( " + Utils.toString(contractIds) + " )";
        }
        try (PreparedStatement psDelete = this.con.prepareStatement(query);){
            psDelete.setInt(1, year);
            psDelete.setInt(2, year);
            psDelete.executeUpdate();
        }
    }
}

