/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.client.CostMapTree;
import ru.bitel.bgbilling.kernel.base.phone.client.CostMapTreeEditor;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMap;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public abstract class ServiceConfigCostMap
extends ServiceConfigTabbedPanel {
    private BGEditor bgEditor;
    CostMapTable table;
    private CostMapTreeEditor costMapTreeEditor;

    public ServiceConfigCostMap() {
        this.jbInit();
    }

    protected void jbInit() {
        this.bgEditor = new BGEditor("table");
        this.setLayout(new BorderLayout());
        this.add((Component)this.bgEditor, "Center");
        this.bgEditor.addPropertyChangeListener("edit", e -> {
            if (Boolean.FALSE.equals(e.getNewValue())) {
                this.setData();
            }
        });
        this.table = new CostMapTable();
        this.bgEditor.addForm((JComponent)((Object)this.table));
        this.costMapTreeEditor = new CostMapTreeEditor(this, this.getCostMapTree());
        this.bgEditor.addForm((JComponent)((Object)this.costMapTreeEditor));
    }

    public void setData() {
        this.table.setData();
    }

    public void deleteItem() {
        this.bgEditor.performAction("delete");
    }

    public void editItem() {
        this.bgEditor.performAction("edit");
    }

    public void newItem() {
        this.bgEditor.performAction("new");
    }

    protected abstract List<CostMap> getCostMapList();

    protected abstract CostMapTree getCostMapTree();

    class CostMapTable
    extends BGUPanel {
        BGTableModel<CostMap> model;
        private BGUTable table;
        private BGEditor bgEditor;
        private CostMapEditor costMapEditor;

        public CostMapTable() {
            super((LayoutManager)new GridBagLayout());
            this.setName("table");
            this.build();
        }

        protected void jbInit() {
            this.model = new BGTableModel<CostMap>("costMap"){

                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u041a\u0430\u0440\u0442\u0430 \u0446\u0435\u043d", -1, 150, -1, "title", true);
                }
            };
            this.table = new BGUTable(this.model);
            this.table.setSelectionMode(0);
            this.table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ServiceConfigCostMap.this.costMapTreeEditor.setData();
                    }
                }
            });
            this.costMapEditor = new CostMapEditor();
            this.bgEditor = new BGEditor();
            this.bgEditor.setBorder((Border)new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
            this.bgEditor.addForm((JComponent)((Object)this.costMapEditor), (Object)"editor");
            this.bgEditor.setVisible(false);
            this.bgEditor.addPropertyChangeListener("edit", e -> {
                this.table.setEnabled(((Boolean)e.getOldValue()).booleanValue());
                if (Boolean.FALSE.equals(e.getNewValue())) {
                    ServiceConfigCostMap.this.setData();
                }
            });
            this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)this.bgEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        }

        public void setData() {
            try {
                this.model.setData(ServiceConfigCostMap.this.getCostMapList());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private class CostMapEditor
    extends BGUPanel {
        private int currentId;
        private BGTextField title;

        private CostMapEditor() {
        }

        protected void jbInit() {
            this.title = new BGTextField();
            this.setLayout(new GridBagLayout());
            this.add(new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 5), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 3, 3), 0, 0));
        }

        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    try {
                        CostMapEditor.this.performActionClose();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            };
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                this.currentId = -1;
                this.title.setText("");
                this.performActionOpen();
            });
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                CostMap costMap = (CostMap)((Object)((Object)ServiceConfigCostMap.this.table.model.getSelectedRow()));
                if (costMap != null) {
                    this.currentId = costMap.getId();
                    try {
                        if (costMap != null) {
                            this.title.setText(costMap.getTitle());
                            this.performActionOpen();
                        }
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                CostMap costMap = (CostMap)((Object)((Object)ServiceConfigCostMap.this.table.model.getSelectedRow()));
                if (costMap != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                    try {
                        ServiceConfigCostMap.this.setData();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            });
        }
    }
}

