/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.calc;

import bitel.billing.server.tariff.voice.bean.ZoneMap;
import bitel.billing.server.tariff.voice.bean.ZoneMapItem;
import bitel.billing.server.tariff.voice.bean.ZoneMapItemManager;
import bitel.billing.server.tariff.voice.bean.ZoneMapManager;
import bitel.billing.server.tariff.voice.calc.CodeFinder;
import bitel.billing.server.tariff.voice.calc.ZoneDestFindRequest;
import bitel.billing.server.tariff.voice.calc.ZoneFinder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ZoneDestFinder {
    private static Map<Integer, ZoneDestFinder> finderMap = Collections.synchronizedMap(new HashMap());
    private Calendar modTime;
    private CodeFinder codeFinder;
    private Map<Integer, ZoneFinder> mapFinders = new HashMap<Integer, ZoneFinder>();

    public static synchronized ZoneDestFinder getZoneFinder(Connection con, int moduleId) {
        ZoneDestFinder result = finderMap.get(moduleId);
        Calendar dbModTime = ServerUtils.getLastModificationTime(con, "zone_map_" + moduleId);
        if (!(dbModTime == null || result != null && result.getModTime().equals(dbModTime))) {
            try {
                result = new ZoneDestFinder(con, moduleId, dbModTime);
                finderMap.put(moduleId, result);
            }
            catch (Exception ex) {
                BGLogger.error(ex);
            }
        }
        return result;
    }

    private ZoneDestFinder(Connection con, int mid, Calendar modTime) throws SQLException {
        this.modTime = modTime;
        this.codeFinder = new CodeFinder(con, mid);
        this.load(con, mid);
    }

    private void load(Connection con, int moduleId) throws SQLException {
        List<ZoneMap> mapList = new ZoneMapManager(con, moduleId).getZoneMapList();
        ZoneMapItemManager itemManager = new ZoneMapItemManager(con, moduleId);
        for (ZoneMap zoneMap : mapList) {
            List<ZoneMapItem> itemList = itemManager.getItemList(zoneMap.getId());
            ZoneFinder finder = new ZoneFinder(itemList);
            this.mapFinders.put(zoneMap.getId(), finder);
        }
    }

    public Calendar getModTime() {
        return this.modTime;
    }

    public void find(ZoneDestFindRequest req) {
        req.numberLength = req.number.length();
        this.codeFinder.find(req);
        ZoneFinder finder = this.mapFinders.get(req.mapId);
        if (finder != null) {
            finder.find(req);
        }
    }
}

