/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.call;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import bitel.billing.module.services.call.RadiusLogViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.CalendarDialog;

public class CallServiceConfigMonitor
extends ServiceConfigTabbedPanel {
    protected boolean nasListLoad = false;
    protected int from = -1;
    protected int to = 0;
    protected Calendar date = null;
    protected JPopupMenu popup = new JPopupMenu();
    private BGControlPanelListSelect nas = new BGControlPanelListSelect();
    private JButton clearButton = new JButton("X");
    private JButton openButton = new JButton("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
    private JButton findButton = new JButton(">>>");
    private RadiusLogViewer radiusLog = new RadiusLogViewer();
    private JTextField balance = new JTextField();
    private JTextField mode = new JTextField();
    private JTextField limit = new JTextField();
    private JTextField value = new JTextField();
    private BGTable tableFindResult = new BGTable();
    protected BGTable tableLog = new BGTable();
    private BGTable tableErr = new BGTable();
    private JLabel contractLabel = new JLabel();
    private JScrollPane tableScroll = new JScrollPane();
    private JToggleButton dayButton = new JToggleButton();
    private ButtonGroup showModeButtonGroup = new ButtonGroup();
    private ButtonGroup findModeButtonGroup = new ButtonGroup();
    private JToggleButton currentButton = new JToggleButton("\u0422\u0435\u043a\u0443\u0449\u0438\u0435");
    private JPanel voipFilterPanel = new JPanel(new GridBagLayout());
    private JCheckBox onlyNoZeroTime = new JCheckBox("\u043d\u0435 0");
    private JCheckBox onlyNoZeroCost = new JCheckBox("\u043f\u043b\u0430\u0442\u043d.");
    private JPanel numberFilterPanel = new JPanel(new GridBagLayout());
    private BGIntTextField numberA = new BGIntTextField();
    private BGIntTextField numberB = new BGIntTextField();
    private JPanel filterPanel = new JPanel(new GridBagLayout());
    private ButtonGroup unitButtonGroup = new ButtonGroup();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JPanel errorFilterPanel = new JPanel(new GridBagLayout());
    private JCheckBox onlyLogin = new JCheckBox("'\u041b\u043e\u0433\u0438\u043d \u0438 \u043a\u0430\u0440\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b'");
    private JLabel totalLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e: ");
    private JButton doButton = new JButton(ClientUtils.getIcon("do.gif"));

    public CallServiceConfigMonitor() {
        this.tryCall(() -> this.jbInit());
        this.pagePanel.setKey(this.getClass().getName());
        GregorianCalendar date = new GregorianCalendar();
        ((Calendar)date).add(5, -2);
        TimeUtils.clearCalendarHour(date);
        this.dayButton.putClientProperty("date", date);
        this.dayButton.setText(TimeUtils.format((Calendar)date, "dd.MM.yyyy"));
        this.tableFindResult.setHeader(this.rb_name, "lac");
        this.tableLog.setHeader(this.rb_name, this.moduleDoc, "logs");
        this.tableErr.setHeader(this.rb_name, "error");
        this.tableLog.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && this.radiusLog.isVisible()) {
                this.getRadiusLogInfo(this.tableLog);
            }
        });
        this.tableErr.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && this.radiusLog.isVisible()) {
                this.getRadiusLogInfo(this.tableErr);
            }
        });
        ActionListener al = e -> this.popupMenu_actionPerformed((JMenuItem)e.getSource());
        JMenuItem item = null;
        item = new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        item.setActionCommand("contractOpen");
        item.addActionListener(al);
        this.popup.add(item);
        this.popup.addSeparator();
        item = new JMenuItem("\u041b\u043e\u0433\u0438 RADIUS\u0430");
        item.setActionCommand("logRadius");
        item.addActionListener(al);
        this.popup.add(item);
        JMenuItem[] addItems = this.getMenuItems();
        if (addItems.length > 0) {
            this.popup.addSeparator();
            for (JMenuItem it : addItems) {
                this.popup.add(it);
            }
        }
        item = new JMenuItem("\u041b\u043e\u0433\u0438 RADIUS\u0430");
        item.setActionCommand("logRadiusError");
        item.addActionListener(al);
        this.tableErr.getPopupMenu().add(item);
        item = new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        item.setActionCommand("contractOpenError");
        item.addActionListener(al);
        this.tableErr.getPopupMenu().add(item);
    }

    private void jbInit() throws Exception {
        JRadioButton findByLoginRadio = new JRadioButton("\u041b\u043e\u0433\u0438\u043d");
        JRadioButton findByAliasRadio = new JRadioButton("\u0410\u043b\u0438\u0430\u0441");
        JRadioButton findByContractRadio = new JRadioButton("\u0414\u043e\u0433\u043e\u0432\u043e\u0440");
        JToggleButton errorButton = new JToggleButton("\u041e\u0448\u0438\u0431\u043a\u0438");
        JToggleButton logButton = new JToggleButton("\u041b\u043e\u0433\u0438");
        ButtonGroup periodButtonGroup = new ButtonGroup();
        JSplitPane mainSplit = new JSplitPane();
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JPanel rightPanel = new JPanel(new GridBagLayout());
        JPanel findModePanel = new JPanel(new GridBagLayout());
        JPanel findLoginPanel = new JPanel(new GridBagLayout());
        JPanel jPanel9 = new JPanel(new GridBagLayout());
        JPanel showModePanel = new JPanel(new GridBagLayout());
        JPanel periodFilterPanel = new JPanel(new GridBagLayout());
        JPanel contractInfoPanel = new JPanel(new GridBagLayout());
        JScrollPane findScrollPane = new JScrollPane();
        this.setLayout(new GridBagLayout());
        mainSplit.setDividerSize(5);
        findByContractRadio.setActionCommand("contract");
        findLoginPanel.setBorder(new BGTitleBorder(" \u041b\u043e\u0433\u0438\u043d/\u0410\u043b\u0438\u0430\u0441/\u0414\u043e\u0433\u043e\u0432\u043e\u0440 "));
        findByLoginRadio.setActionCommand("login");
        findByLoginRadio.setSelected(true);
        this.value.setMinimumSize(new Dimension(110, 20));
        this.value.setColumns(10);
        this.value.setHorizontalAlignment(0);
        this.value.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                CallServiceConfigMonitor.this.value_keyPressed(e);
            }
        });
        findByAliasRadio.setActionCommand("alias");
        this.findButton.setMargin(new Insets(2, 2, 2, 2));
        this.findButton.addActionListener(e -> this.findButton_actionPerformed(e));
        this.clearButton.setMargin(new Insets(2, 2, 2, 2));
        this.clearButton.addActionListener(e -> this.clearButton_actionPerformed(e));
        JToggleButton bGButton5 = new JToggleButton("2 - 4");
        bGButton5.setToolTipText("2 - 4  \u0447\u0430\u0441\u0430 \u043d\u0430\u0437\u0430\u0434");
        bGButton5.setMargin(new Insets(2, 2, 2, 2));
        bGButton5.addActionListener(e -> this.setPeriod(-4, -2, null));
        showModePanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0436\u0438\u043c "));
        periodFilterPanel.setBorder(new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        JToggleButton bGButton3 = new JToggleButton("-1 \u0447\u0430\u0441");
        bGButton3.setToolTipText("0 - 1  \u0447\u0430\u0441\u0430 \u043d\u0430\u0437\u0430\u0434");
        bGButton3.setMargin(new Insets(2, 2, 2, 2));
        bGButton3.setSelected(true);
        bGButton3.setText("0 - 1");
        bGButton3.addActionListener(e -> this.setPeriod(-1, 0, null));
        errorButton.setActionCommand("error");
        errorButton.setMargin(new Insets(2, 2, 2, 2));
        errorButton.setSelected(true);
        errorButton.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.radiusLog.setVisible(false);
            }
        });
        errorButton.addActionListener(e -> this.showErrors(e));
        JToggleButton bGButton6 = new JToggleButton("4 - 8");
        bGButton6.setToolTipText("4 - 8  \u0447\u0430\u0441\u043e\u0432 \u043d\u0430\u0437\u0430\u0434");
        bGButton6.setVerifyInputWhenFocusTarget(true);
        bGButton6.setMargin(new Insets(2, 2, 2, 2));
        bGButton6.addActionListener(e -> this.setPeriod(-8, -4, null));
        JToggleButton bGButton4 = new JToggleButton("1 - 2");
        bGButton4.setToolTipText(" 1 - 2  \u0447\u0430\u0441\u0430 \u043d\u0430\u0437\u0430\u0434");
        bGButton4.setMargin(new Insets(2, 2, 2, 2));
        bGButton4.addActionListener(e -> this.setPeriod(-2, -1, null));
        JToggleButton bGButton7 = new JToggleButton("8 - 24");
        bGButton7.setToolTipText("8 - 24  \u0447\u0430\u0441\u043e\u0432 \u043d\u0430\u0437\u0430\u0434");
        bGButton7.setMargin(new Insets(2, 2, 2, 2));
        bGButton7.addActionListener(e -> this.bGButton7_actionPerformed(e));
        logButton.setActionCommand("logs");
        logButton.setMargin(new Insets(2, 2, 2, 2));
        logButton.setSelected(false);
        logButton.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.radiusLog.setVisible(false);
            }
        });
        logButton.addActionListener(e -> this.showLogs(e));
        this.openButton.addActionListener(e -> ClientUtils.openContract(this.tableFindResult, "0"));
        this.contractLabel.setFont(new Font("Dialog", 0, 14));
        this.contractLabel.setText(" ");
        this.limit.setMinimumSize(new Dimension(77, 22));
        this.limit.setEditable(false);
        this.limit.setColumns(7);
        this.limit.setHorizontalAlignment(0);
        this.balance.setMinimumSize(new Dimension(77, 22));
        this.balance.setEditable(false);
        this.balance.setColumns(7);
        this.balance.setHorizontalAlignment(0);
        this.dayButton.setToolTipText("\u0432\u044b\u0431\u043e\u0440 \u0441\u0443\u0442\u043e\u043a");
        this.dayButton.setMargin(new Insets(2, 2, 2, 2));
        this.dayButton.setSelected(false);
        this.dayButton.addActionListener(e -> this.bGButton1_actionPerformed(e));
        this.currentButton.setActionCommand("active");
        this.currentButton.setMargin(new Insets(2, 2, 2, 2));
        this.currentButton.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.radiusLog.setVisible(false);
            }
        });
        this.currentButton.addActionListener(e -> this.showLogs(e));
        JToggleButton bytesButton = new JToggleButton("B");
        bytesButton.setActionCommand("b");
        JToggleButton mbytesButton = new JToggleButton("MB");
        mbytesButton.setActionCommand("mb");
        JToggleButton gbytesButton = new JToggleButton("GB");
        gbytesButton.setActionCommand("gb");
        this.unitButtonGroup.add(bytesButton);
        this.unitButtonGroup.add(mbytesButton);
        this.unitButtonGroup.add(gbytesButton);
        ActionListener unitListener = e -> {
            this.pagePanel.init();
            this.trySetData();
        };
        bytesButton.setSelected(true);
        bytesButton.addActionListener(unitListener);
        mbytesButton.addActionListener(unitListener);
        gbytesButton.addActionListener(unitListener);
        this.filterPanel.setBorder(new BGTitleBorder("\u0415\u0434. \u0438\u0437\u043c."));
        this.filterPanel.add((Component)bytesButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)mbytesButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)gbytesButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.pagePanel.init();
        this.pagePanel.addToHandler(a -> this.trySetData());
        this.radiusLog.setVisible(false);
        BGSwingUtilites.handleLDMouseClicked(this.tableFindResult, e -> this.trySetData());
        this.tableLog.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CallServiceConfigMonitor.this.bGTable2_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                int index = CallServiceConfigMonitor.this.tableLog.getSelectedRow();
                Point p = e.getPoint();
                if (SwingUtilities.isRightMouseButton(e) && CallServiceConfigMonitor.this.popup.isPopupTrigger(e) && index > -1) {
                    CallServiceConfigMonitor.this.popup.show(e.getComponent(), p.x, p.y);
                }
            }
        });
        this.tableErr.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CallServiceConfigMonitor.this.bGTable3_mousePressed(e);
            }
        });
        this.onlyLogin.addActionListener(e -> this.trySetData());
        this.doButton.addActionListener(e -> this.trySetData());
        this.doButton.setToolTipText("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c \u0444\u0438\u043b\u044c\u0442\u0440 \u0438 \u0432\u044b\u0432\u0435\u0441\u0442\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
        this.numberA.addActionListener(e -> this.trySetData());
        this.numberB.addActionListener(e -> this.trySetData());
        this.mode.setMinimumSize(new Dimension(77, 22));
        this.mode.setEditable(false);
        this.mode.setColumns(7);
        this.mode.setHorizontalAlignment(0);
        this.nas.setBorder(null);
        this.nas.setTitledBorder1(new BGTitleBorder(" NAS "));
        leftPanel.setBorder(BorderFactory.createEmptyBorder());
        rightPanel.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)mainSplit, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        mainSplit.add((Component)leftPanel, "top");
        mainSplit.add((Component)rightPanel, "bottom");
        this.tableScroll.setViewportView(this.tableErr);
        mainSplit.setDividerLocation(250);
        jPanel9.add((Component)this.value, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel9.add((Component)this.clearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        jPanel9.add((Component)this.findButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        leftPanel.add((Component)this.nas, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)findScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(2, 2, 0, 0), 0, 0));
        leftPanel.add((Component)this.onlyLogin, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        leftPanel.add((Component)this.openButton, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        findScrollPane.setViewportView(this.tableFindResult);
        findLoginPanel.add((Component)findModePanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        findLoginPanel.add((Component)jPanel9, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        findModePanel.add((Component)findByLoginRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        findModePanel.add((Component)findByAliasRadio, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        findModePanel.add((Component)findByContractRadio, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        leftPanel.add((Component)findLoginPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        showModePanel.add((Component)logButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        showModePanel.add((Component)errorButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        showModePanel.add((Component)this.currentButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        contractInfoPanel.add((Component)this.contractLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 0), 0, 0));
        contractInfoPanel.add((Component)new JLabel("\u041b\u0438\u043c\u0438\u0442: "), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        contractInfoPanel.add((Component)this.limit, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        contractInfoPanel.add((Component)new JLabel("\u0411\u0430\u043b\u0430\u043d\u0441: "), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        contractInfoPanel.add((Component)this.balance, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 3, 5), 0, 0));
        contractInfoPanel.add((Component)this.mode, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        contractInfoPanel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.voipFilterPanel.setBorder(new BGTitleBorder(" \u0422\u043e\u043b\u044c\u043a\u043e "));
        this.voipFilterPanel.add((Component)this.onlyNoZeroCost, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.voipFilterPanel.add((Component)this.onlyNoZeroTime, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.errorFilterPanel.setBorder(new BGTitleBorder(" \u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438 "));
        this.errorFilterPanel.add(this.onlyLogin);
        JPanel totalAndPagePanel = new JPanel(new GridBagLayout());
        totalAndPagePanel.setBorder(new BGTitleBorder(" \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 "));
        totalAndPagePanel.add((Component)this.totalLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        totalAndPagePanel.add((Component)this.pagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.voipFilterPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.errorFilterPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)totalAndPagePanel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.doButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.numberFilterPanel.setBorder(BorderFactory.createTitledBorder("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0430\u043c"));
        this.numberFilterPanel.add((Component)new JLabel("\u0421 \u043d\u043e\u043c\u0435\u0440\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.numberFilterPanel.add((Component)this.numberA, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.numberFilterPanel.add((Component)new JLabel("\u041d\u0430 \u043d\u043e\u043c\u0435\u0440"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.numberFilterPanel.add((Component)this.numberB, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel modeAndPeriodFilterPanel = new JPanel(new GridBagLayout());
        modeAndPeriodFilterPanel.add((Component)showModePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        modeAndPeriodFilterPanel.add((Component)filterPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        modeAndPeriodFilterPanel.add((Component)this.numberFilterPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        modeAndPeriodFilterPanel.add((Component)periodFilterPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        modeAndPeriodFilterPanel.add((Component)filterPanel, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        periodFilterPanel.add((Component)bGButton3, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        periodFilterPanel.add((Component)bGButton4, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        periodFilterPanel.add((Component)bGButton5, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        periodFilterPanel.add((Component)bGButton6, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        periodFilterPanel.add((Component)bGButton7, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 5), 0, 0));
        periodFilterPanel.add((Component)this.dayButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        rightPanel.add((Component)this.tableScroll, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)this.radiusLog, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)contractInfoPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        rightPanel.add((Component)modeAndPeriodFilterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.findModeButtonGroup.add(findByLoginRadio);
        this.findModeButtonGroup.add(findByAliasRadio);
        this.findModeButtonGroup.add(findByContractRadio);
        this.showModeButtonGroup.add(errorButton);
        this.showModeButtonGroup.add(logButton);
        this.showModeButtonGroup.add(this.currentButton);
        periodButtonGroup.add(bGButton3);
        periodButtonGroup.add(bGButton4);
        periodButtonGroup.add(bGButton5);
        periodButtonGroup.add(bGButton6);
        periodButtonGroup.add(bGButton7);
        periodButtonGroup.add(this.dayButton);
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.radiusLog.init(module, mid);
    }

    @Override
    public void setData() throws Exception {
        int selectRowIndex = this.tableFindResult.getSelectedRow();
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetLogAndError");
        request.setModuleId(this.getModuleId());
        request.setPageIndex(this.pagePanel.getPageIndex());
        request.setPageSize(this.pagePanel.getPageSize());
        request.setAttribute("mode", this.showModeButtonGroup.getSelection().getActionCommand());
        request.setAttribute("units", this.unitButtonGroup.getSelection().getActionCommand());
        request.setAttribute("numberA", String.valueOf(this.numberA.getValue()));
        request.setAttribute("numberB", String.valueOf(this.numberB.getValue()));
        if (selectRowIndex > -1) {
            request.setAttribute("cid", (String)this.tableFindResult.getValueAt(selectRowIndex, 0));
            request.setAttribute("lid", (String)this.tableFindResult.getValueAt(selectRowIndex, 2));
        }
        if (this.from < 1) {
            request.setAttribute("from", this.from);
        }
        if (this.to < 1) {
            request.setAttribute("to", this.to);
        }
        if (this.date != null) {
            request.setAttribute("date", TimeUtils.format(this.date, "dd.MM.yyyy HH:mm"));
        }
        request.setAttribute("value", this.value.getText().trim());
        if (!this.nasListLoad) {
            request.setAttribute("nasList", "1");
        } else {
            request.setAttribute("nas", this.nas.getListValues());
        }
        if (this.onlyNoZeroCost.isSelected()) {
            request.setAttribute("no_zero_cost", 1);
        }
        if (this.onlyNoZeroTime.isSelected()) {
            request.setAttribute("no_zero_time", 1);
        }
        if (this.onlyLogin.isSelected()) {
            request.setAttribute("only_login", 1);
        }
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) throws Exception {
        if (ClientUtils.checkStatus(doc)) {
            String actionCommand = this.showModeButtonGroup.getSelection().getActionCommand();
            Element tablElement = XMLUtils.selectElement(doc, "//table");
            if ("error".equals(actionCommand)) {
                this.tableErr.updateData(tablElement);
            } else if ("logs".equals(actionCommand)) {
                this.tableLog.updateData(tablElement);
            } else if ("active".equals(actionCommand)) {
                this.tableLog.updateData(tablElement);
            }
            this.pagePanel.setPageInfo(tablElement);
            this.totalLabel.setText("\u0412\u0441\u0435\u0433\u043e: " + tablElement.getAttribute("recordCount"));
            Element contract = XMLUtils.selectElement(doc, "//contract");
            StringBuffer buf = new StringBuffer();
            buf.append(XMLUtils.getAttribute(contract, "title", "???"));
            buf.append(" [");
            buf.append(XMLUtils.getAttribute(contract, "comment", ""));
            buf.append("]");
            this.contractLabel.setText(buf.toString());
            String modeValue = XMLUtils.getAttribute(contract, "mode", null);
            if (modeValue == null) {
                this.mode.setText("");
            } else {
                this.mode.setText(modeValue.equals("1") ? "\u0414\u0435\u0431\u0435\u0442" : "\u041a\u0440\u0435\u0434\u0438\u0442");
            }
            this.limit.setText(XMLUtils.getAttribute(contract, "limit", ""));
            this.balance.setText(XMLUtils.getAttribute(contract, "balance", ""));
            Element nasNode = XMLUtils.selectElement(doc, "//nas");
            if (nasNode != null && nasNode.hasChildNodes()) {
                this.nasListLoad = true;
                ClientUtils.buildList(this.nas, (Node)nasNode);
            }
        }
    }

    private void clearButton_actionPerformed(ActionEvent e) {
        this.value.setText("");
        this.tableFindResult.removeRows();
    }

    private void findButton_actionPerformed(ActionEvent e) {
        this.findContractLoginAlias();
    }

    private void findContractLoginAlias() {
        if (this.findModeButtonGroup.getSelection().getActionCommand().equals("login") && !this.value.getText().trim().matches("\\d+")) {
            ClientUtils.showErrorMessageDialog("\u041b\u043e\u0433\u0438\u043d \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0446\u0438\u0444\u0440\u043e\u0432\u044b\u043c");
        }
        Request request = new Request();
        request.setModule("call");
        request.setAction("FindContractLoginAlias");
        request.setModuleId(this.getModuleId());
        request.setAttribute("type", this.findModeButtonGroup.getSelection().getActionCommand());
        request.setAttribute("value", this.value.getText().trim());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.tryCall(() -> this.tableFindResult.updateData(XMLUtils.selectNode(doc, "//table")));
        }
    }

    private void showErrors(ActionEvent e) {
        this.pagePanel.init();
        this.tableScroll.setViewportView(this.tableErr);
        this.trySetData();
    }

    private void showLogs(ActionEvent e) {
        this.pagePanel.init();
        this.tableScroll.setViewportView(this.tableLog);
        this.tableScroll.setVisible(false);
        this.tableScroll.setVisible(true);
        this.trySetData();
    }

    private void setPeriod(int from, int to, Calendar date) {
        this.from = from;
        this.to = to;
        this.date = date;
        this.pagePanel.init();
        this.trySetData();
    }

    private void bGButton7_actionPerformed(ActionEvent e) {
        this.setPeriod(-24, -8, null);
    }

    private void bGButton1_actionPerformed(ActionEvent e) {
        Calendar date2 = (Calendar)this.dayButton.getClientProperty("date");
        CalendarDialog dialog = new CalendarDialog();
        dialog.setCalendar(date2);
        if (dialog.showDialog().equals("ok")) {
            date2 = dialog.getCalendar();
            if (date2 == null) {
                date2 = new GregorianCalendar();
                date2.add(5, -2);
                TimeUtils.clearCalendarHour(date2);
            }
            this.dayButton.setText(TimeUtils.format(date2, "dd.MM.yyyy"));
        }
        this.setPeriod(1, 1, date2);
    }

    private void value_keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '\n' && !this.value.getText().equals("")) {
            this.findContractLoginAlias();
        }
    }

    private void bGTable2_mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2 && this.tableLog.getSelectedRow() > -1) {
            this.radiusLog.setVisible(true);
            this.getRadiusLogInfo(this.tableLog);
        }
    }

    private void bGTable3_mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2 && this.tableErr.getSelectedRow() > -1) {
            this.radiusLog.setVisible(true);
            this.getRadiusLogInfo(this.tableErr);
        }
    }

    private void getRadiusLogInfo(BGTable table) {
        int row = table.getSelectedRow();
        if (row > -1) {
            int cid = Utils.parseInt(table.getValueAt(row, 1).toString(), -1);
            int id = Utils.parseInt(table.getValueAt(row, 0).toString(), -1);
            this.radiusLog.setContractId(cid);
            this.radiusLog.setId(id);
            if (this.date != null) {
                this.radiusLog.setDate(this.date);
            }
            this.radiusLog.showLog();
        }
    }

    private void popupMenu_actionPerformed(JMenuItem item) {
        String actionCommand = item.getActionCommand();
        if ("contractOpen".equals(actionCommand)) {
            ClientUtils.openContract(this.tableLog, "cid");
        } else if ("logRadius".equals(actionCommand)) {
            this.radiusLog.setVisible(true);
            this.getRadiusLogInfo(this.tableLog);
        } else if ("contractOpenError".equals(actionCommand)) {
            ClientUtils.openContract(this.tableErr, "1");
        } else if ("logRadiusError".equals(actionCommand)) {
            this.radiusLog.setVisible(true);
            this.getRadiusLogInfo(this.tableErr);
        }
    }

    protected void hidePart() {
        this.currentButton.setVisible(false);
        this.filterPanel.setVisible(false);
    }

    protected void hideVoipPart() {
        this.voipFilterPanel.setVisible(false);
        this.numberFilterPanel.setVisible(false);
    }

    protected JMenuItem[] getMenuItems() {
        return new JMenuItem[0];
    }
}

