/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.datalog.netflow.nat;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogUtils;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.Netflow9DataLogReader;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.CiscoHslNatLogProcessor;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.NatLogExportParameters;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.SeNatLogProcessor;
import ru.bitel.bgbilling.kernel.network.datalog.netflow.nat.SimpleNatLogProcessor;
import ru.bitel.bgbilling.kernel.network.flow.NetFlow9Template;
import ru.bitel.bgbilling.kernel.network.flow.Netflow9Processor;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.Recyclable;

public abstract class NatLogProcessor
implements Netflow9Processor,
Flushable,
AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private Netflow9Processor processor;

    protected abstract Netflow9Processor newProcessor(int var1) throws IOException;

    @Override
    public void process(ByteBuffer readBuffer, int offset, long millis, NetFlow9Template template) throws Exception {
        if (this.processor == null) {
            if (template.seNatLog) {
                this.processor = this.newProcessor(2);
            } else if (template.hslNatLog) {
                this.processor = this.newProcessor(1);
            } else if (template.natLog) {
                this.processor = this.newProcessor(0);
            } else {
                return;
            }
        }
        this.processor.process(readBuffer, offset, millis, template);
    }

    @Override
    public void close() throws Exception {
        if (this.processor instanceof Recyclable) {
            ((Recyclable)((Object)this.processor)).recycle();
        }
        if (this.processor instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.processor)).close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.processor instanceof Flushable) {
            ((Flushable)((Object)this.processor)).flush();
        }
    }

    protected static SortedSet<Calendar> getLogHours(NatLogExportParameters exportParameters) {
        TreeSet<Calendar> result = new TreeSet<Calendar>();
        Calendar hour = new GregorianCalendar();
        hour.setTime(exportParameters.timeFrom);
        TimeUtils.clear_MIN_MIL_SEC(hour);
        hour.add(11, -exportParameters.logHourDelta);
        GregorianCalendar end = new GregorianCalendar();
        end.setTime(exportParameters.timeTo);
        ((Calendar)end).add(11, exportParameters.logHourDelta);
        while (TimeUtils.compare(hour, end, 11) <= 0) {
            result.add(hour);
            hour = (Calendar)hour.clone();
            hour.add(11, 1);
        }
        return result;
    }

    public static void process(ParameterMap setup, NatLogExportParameters exportParameters, Netflow9Processor processor) {
        if (Utils.notBlankString(exportParameters.directory)) {
            Preferences prefs = new Preferences();
            prefs.set(exportParameters.directoryKey, exportParameters.directory);
            setup = prefs;
        }
        SortedSet<Calendar> hours = NatLogProcessor.getLogHours(exportParameters);
        Iterable<IPHourlyDataLog> hourlyDataLogIterable = IPDataLogUtils.newIPHourlyDataLogIterable(setup, exportParameters.directoryKey, exportParameters.agentDeviceId, new ArrayList<Calendar>(hours));
        for (IPHourlyDataLog dataLog : hourlyDataLogIterable) {
            FlowReader flowReader;
            if (log.isDebugEnabled()) {
                log.debug("IPHourlyDataLog.getHour() = " + String.valueOf(dataLog.getHour().getTime()));
                log.debug("IPHourlyDataLog.exists() = " + dataLog.exists());
                log.debug("IPHourlyDataLog.length() = " + dataLog.length());
                log.debug("IPHourlyDataLog.getLogFiles() = " + String.valueOf(dataLog.getLogFiles()));
            }
            while ((flowReader = (FlowReader)dataLog.nextReader(null, false)) != null) {
                if (!(flowReader instanceof Netflow9DataLogReader)) continue;
                while (((Netflow9DataLogReader)flowReader).processChunk(processor)) {
                }
            }
        }
    }

    public static void export(ParameterMap setup, NatLogExportParameters exportParameters, Writer writer) throws Exception {
        NatLogProcessor.export(setup, exportParameters, false, writer);
    }

    public static void export(ParameterMap setup, final NatLogExportParameters exportParameters, boolean skipTimeFilter, final Writer writer) throws Exception {
        SimpleDateFormat format;
        int timeZoneDelta;
        TimeZone timeZone;
        if (!Utils.isEmptyString(exportParameters.timeZoneName)) {
            timeZone = TimeZone.getTimeZone(exportParameters.timeZoneName);
            TimeZone currentTimeZone = TimeZone.getDefault();
            timeZoneDelta = timeZone.getRawOffset() - currentTimeZone.getRawOffset();
        } else {
            timeZone = null;
            timeZoneDelta = 0;
        }
        if (Utils.isBlankString(exportParameters.timestampFormat)) {
            format = null;
        } else {
            format = new SimpleDateFormat(exportParameters.timestampFormat);
            if (timeZone != null) {
                format.setTimeZone(timeZone);
            }
        }
        if (skipTimeFilter) {
            exportParameters.timeFromMillis = 0L;
            exportParameters.timeToMillis = 0L;
        } else {
            exportParameters.timeFromMillis = exportParameters.timeFrom != null ? exportParameters.timeFrom.getTime() - (long)timeZoneDelta : 0L;
            long l = exportParameters.timeToMillis = exportParameters.timeTo != null ? exportParameters.timeTo.getTime() - (long)timeZoneDelta : 0L;
            if (log.isDebugEnabled()) {
                log.debug("timeFromMillis = " + String.valueOf(new Date(exportParameters.timeFromMillis)));
                log.debug("timeToMillis = " + String.valueOf(new Date(exportParameters.timeToMillis)));
            }
        }
        NatLogProcessor processor = new NatLogProcessor(){

            @Override
            protected Netflow9Processor newProcessor(int type) throws IOException {
                switch (type) {
                    case 1: {
                        return new CiscoHslNatLogProcessor.ExportCiscoNatLogProcessor(exportParameters, writer, format);
                    }
                    case 2: {
                        return new SeNatLogProcessor.ExportSENatLogProcessor(exportParameters, writer, format);
                    }
                }
                return new SimpleNatLogProcessor.ExportSimpleNatLogProcessor(exportParameters, writer, format);
            }
        };
        if (exportParameters.logHourDelta < 0) {
            exportParameters.logHourDelta = exportParameters.address != null ? 2 : 1;
        }
        NatLogProcessor.process(setup, exportParameters, processor);
        processor.flush();
        processor.close();
        writer.flush();
    }

    public static void main(String[] args) throws Exception, BGException {
        NatLogProcessor.export(null, args);
    }

    protected static void export(ParameterMap setup, String[] args) throws Exception, BGException {
        NatLogExportParameters exportParameters = new NatLogExportParameters();
        int i = 0;
        while (i < args.length) {
            String k;
            if ("-s".equals(k = args[i++])) {
                exportParameters.agentDeviceId = Utils.parseInt(args[i++]);
                continue;
            }
            if ("-h".equals(k)) {
                exportParameters.timeFrom = TimeUtils.parseDate(args[i++], "yyyy-MM-dd-HH");
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(exportParameters.timeFrom);
                ((Calendar)calendar).add(11, 1);
                ((Calendar)calendar).add(14, -1);
                exportParameters.timeTo = calendar.getTime();
                continue;
            }
            if ("-tFrom".equals(k)) {
                exportParameters.timeFrom = TimeUtils.parseDate(args[i++], "yyyy-MM-dd'T'HH:mm:ss");
                continue;
            }
            if ("-tTo".equals(k)) {
                exportParameters.timeTo = TimeUtils.parseDate(args[i++], "yyyy-MM-dd'T'HH:mm:ss");
                continue;
            }
            if ("-a".equals(k)) {
                exportParameters.address = InetAddress.getByName(args[i++]).getAddress();
                continue;
            }
            if ("-p".equals(k)) {
                exportParameters.ports.addAll(Utils.toIntegerList(args[i++]));
                continue;
            }
            if ("-f".equals(k)) {
                exportParameters.fileName = args[i++];
                continue;
            }
            if ("-tFmt".equals(k)) {
                exportParameters.timestampFormat = args[i++];
                continue;
            }
            if ("-dir".equals(k)) {
                exportParameters.directory = args[i++];
                continue;
            }
            if ("-tZone".equals(k)) {
                exportParameters.timeZoneName = args[i++];
                continue;
            }
            if (!"-logHourDelta".equals(k)) continue;
            exportParameters.logHourDelta = Utils.parseInt(args[i++]);
        }
        if (setup == null && Utils.isBlankString(exportParameters.directory)) {
            throw new BGException("Parameter -dir (data log directory) must not be empty. For example, -dir data/flow");
        }
        if (Utils.isBlankString(exportParameters.fileName)) {
            throw new BGException("Parameter -f (file name) must not be empty.");
        }
        if (exportParameters.agentDeviceId <= 0) {
            throw new BGException("Parameter -s (id of flow agent device) must not be empty.");
        }
        if (exportParameters.timeFrom == null || exportParameters.timeTo == null) {
            throw new BGException("Parameter -h (or -tFrom and -tTo) must not be empty.");
        }
        exportParameters.directoryKey = "datalog.flow.dir";
        NatLogProcessor.export(setup, exportParameters);
    }

    public static void export(ParameterMap setup, NatLogExportParameters exportParameters) throws Exception {
        NatLogProcessor.export(setup, exportParameters, false);
    }

    public static void export(ParameterMap setup, NatLogExportParameters exportParameters, boolean skipTimeFilter) throws Exception {
        FileWriter fileWriter = new FileWriter(exportParameters.fileName);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter, 65536);
        NatLogProcessor.export(setup, exportParameters, skipTimeFilter, fileWriter);
        bufferedWriter.flush();
        fileWriter.flush();
        fileWriter.close();
    }

    public static void export(ParameterMap setup, String command) throws Exception, BGException {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = Pattern.compile("(?:\\A|[\\s]*)(?:(?:\"(.+?)\")|(?:(.+?)))(?:[\\s]|\\z)").matcher(command);
        while (m.find()) {
            String k = m.group(1);
            if (k == null) {
                k = m.group(2);
            }
            args.add(k);
        }
        NatLogProcessor.export(setup, args.toArray(new String[args.size()]));
    }
}

