/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.util.ArrayList;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import ru.bitel.common.io.Base64;

public class PEMCertificate {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";

    public static X509Certificate getPemCertificate(File pemFile) throws FileNotFoundException, IOException, CertificateException {
        X509Certificate x509Certificate;
        FileInputStream pemFileInputStream = new FileInputStream(pemFile);
        try {
            x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(pemFileInputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pemFileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("pem-certificate file not found: " + e.getMessage());
            }
            catch (IOException e) {
                throw new IOException("pem-certificate file " + pemFile.getAbsolutePath() + " error read: " + e.toString());
            }
            catch (CertificateException e) {
                throw new CertificateException("pem file " + pemFile.getAbsolutePath() + " error certificate: " + e.toString());
            }
        }
        pemFileInputStream.close();
        return x509Certificate;
    }

    public static PrivateKey getPemPrivateKey(File pemFile) throws Exception {
        return PEMCertificate.getPemPrivateKey(pemFile, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey getPemPrivateKey(File pemFile, String password) throws FileNotFoundException, IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(new FileInputStream(pemFile)));){
            Object obj = pemParser.readObject();
            if (obj instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)obj;
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
                return privateKey;
            }
            if (obj instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair encryptedKeyPair = (PEMEncryptedKeyPair)obj;
                PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
                PEMKeyPair pemKeyPair = encryptedKeyPair.decryptKeyPair(decryptorProvider);
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                PrivateKey privateKey = converter.getPrivateKey(pemKeyPair.getPrivateKeyInfo());
                return privateKey;
            }
            if (!(obj instanceof PEMKeyPair)) throw new IOException("error object in pem file (" + obj.toString() + ")");
            PEMKeyPair pemKeyPair = (PEMKeyPair)obj;
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PrivateKey privateKey = converter.getPrivateKey(pemKeyPair.getPrivateKeyInfo());
            return privateKey;
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("pem-privatekey file not found: " + e.getMessage());
        }
        catch (PEMException e) {
            throw new IOException("pem-privatekey file " + pemFile.getAbsolutePath() + " error parse: " + e.toString());
        }
        catch (IOException e) {
            throw new IOException("pem-privatekey file " + pemFile.getAbsolutePath() + " error read/parse: " + e.toString());
        }
    }

    public static X509Certificate _getPemCertificate(File f) throws CertificateException, IOException {
        FileInputStream fis = new FileInputStream(f);
        DataInputStream dis = new DataInputStream(fis);
        byte[] keyBytes = new byte[(int)f.length()];
        dis.readFully(keyBytes);
        dis.close();
        String temp = new String(keyBytes);
        String certificatePEM = temp.replace(BEGIN_CERT, "").replace(END_CERT, "").replace("\n", "");
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Base64.decode(certificatePEM.getBytes())));
    }

    public static PrivateKey _getPemPrivateKey(File f) throws Exception {
        String END = "END";
        String RSA = "RSA";
        String DSA = "DSA";
        String BEGIN = "BEGIN";
        String MARKER = "-----";
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        byte[] keyBytes = new byte[(int)f.length()];
        dis.readFully(keyBytes);
        dis.close();
        String temp = new String(keyBytes);
        boolean rsaKey = temp.contains("-----BEGIN RSA");
        boolean dsaKey = temp.contains("-----BEGIN DSA");
        temp = temp.replace("\n", "");
        int beginPos = temp.indexOf("-----BEGIN");
        beginPos = temp.indexOf("-----", beginPos + "-----".length() + "BEGIN".length()) + "-----".length();
        int endPos = temp.indexOf("-----END", beginPos);
        String privKeyPEM = temp.substring(beginPos, endPos);
        byte[] privKeyBytes = Base64.decode(privKeyPEM.getBytes());
        PEMCertificate pemCertificate = new PEMCertificate();
        if (!rsaKey && !dsaKey) {
            ASN1Object privateKeyInfoSequence = new ASN1Object(pemCertificate);
            PEMCertificate.initASN1Object(privKeyBytes, 0, privateKeyInfoSequence);
            ASN1Object integerObject = new ASN1Object(pemCertificate);
            int pos = PEMCertificate.initASN1Object(privateKeyInfoSequence.getValue(), 0, integerObject);
            ASN1Object algorithmIdentifierSequence = new ASN1Object(pemCertificate);
            pos = PEMCertificate.initASN1Object(privateKeyInfoSequence.getValue(), pos, algorithmIdentifierSequence);
            ASN1ObjectIdentifier oidObject = new ASN1ObjectIdentifier(pemCertificate);
            int algorithmIdentifierPos = PEMCertificate.initASN1Object(algorithmIdentifierSequence.getValue(), 0, oidObject);
            if ("1.2.840.10040.4.1".equals(oidObject.getOID())) {
                DSAPrivateKeyData dsaPrivateKeyData = new DSAPrivateKeyData(pemCertificate);
                ASN1Object dssParamsSequence = new ASN1Object(pemCertificate);
                PEMCertificate.initASN1Object(algorithmIdentifierSequence.getValue(), algorithmIdentifierPos, dssParamsSequence);
                int dssParamPos = PEMCertificate.initASN1Object(dssParamsSequence.getValue(), 0, integerObject);
                dsaPrivateKeyData.setQ(new BigInteger(1, integerObject.getValue()));
                dssParamPos = PEMCertificate.initASN1Object(dssParamsSequence.getValue(), dssParamPos, integerObject);
                dsaPrivateKeyData.setG(new BigInteger(1, integerObject.getValue()));
                dssParamPos = PEMCertificate.initASN1Object(dssParamsSequence.getValue(), dssParamPos, integerObject);
                dsaPrivateKeyData.setP(new BigInteger(1, integerObject.getValue()));
                ASN1Object privateKey = new ASN1Object(pemCertificate);
                pos = PEMCertificate.initASN1Object(privateKeyInfoSequence.getValue(), pos, privateKey);
                PEMCertificate.initASN1Object(privateKey.getValue(), 0, integerObject);
                dsaPrivateKeyData.setX(new BigInteger(1, integerObject.getValue()));
                return KeyFactory.getInstance("DSA").generatePrivate(new DSAPrivateKeySpec(dsaPrivateKeyData.getX(), dsaPrivateKeyData.getP(), dsaPrivateKeyData.getQ(), dsaPrivateKeyData.getG()));
            }
            if ("1.2.840.113549.1.1.1".equals(oidObject.getOID())) {
                ASN1Object privateKey = new ASN1Object(pemCertificate);
                pos = PEMCertificate.initASN1Object(privateKeyInfoSequence.getValue(), pos, privateKey);
                privKeyBytes = privateKey.getValue();
                rsaKey = true;
            }
        }
        if (dsaKey) {
            ASN1Object dsaPrivateKeySequence = new ASN1Object(pemCertificate);
            PEMCertificate.initASN1Object(privKeyBytes, 0, dsaPrivateKeySequence);
            DSAPrivateKeyData dsaPrivateKeyData = new DSAPrivateKeyData(pemCertificate);
            ASN1Object integerObject = new ASN1Object(pemCertificate);
            int pos = PEMCertificate.initASN1Object(dsaPrivateKeySequence.getValue(), 0, integerObject);
            pos = PEMCertificate.initASN1Object(dsaPrivateKeySequence.getValue(), pos, integerObject);
            dsaPrivateKeyData.setP(new BigInteger(1, integerObject.getValue()));
            pos = PEMCertificate.initASN1Object(dsaPrivateKeySequence.getValue(), pos, integerObject);
            dsaPrivateKeyData.setQ(new BigInteger(1, integerObject.getValue()));
            pos = PEMCertificate.initASN1Object(dsaPrivateKeySequence.getValue(), pos, integerObject);
            dsaPrivateKeyData.setG(new BigInteger(1, integerObject.getValue()));
            pos = PEMCertificate.initASN1Object(dsaPrivateKeySequence.getValue(), pos, integerObject);
            pos = PEMCertificate.initASN1Object(dsaPrivateKeySequence.getValue(), pos, integerObject);
            dsaPrivateKeyData.setX(new BigInteger(1, integerObject.getValue()));
            return KeyFactory.getInstance("DSA").generatePrivate(new DSAPrivateKeySpec(dsaPrivateKeyData.getX(), dsaPrivateKeyData.getP(), dsaPrivateKeyData.getQ(), dsaPrivateKeyData.getG()));
        }
        if (rsaKey) {
            ASN1Object rsaPrivateKeySequence = new ASN1Object(pemCertificate);
            PEMCertificate.initASN1Object(privKeyBytes, 0, rsaPrivateKeySequence);
            RSAPrivateKeyData rsaPrivateKeyData = new RSAPrivateKeyData(pemCertificate);
            ASN1Object integerObject = new ASN1Object(pemCertificate);
            int pos = PEMCertificate.initASN1Object(rsaPrivateKeySequence.getValue(), 0, integerObject);
            pos = PEMCertificate.initASN1Object(rsaPrivateKeySequence.getValue(), pos, integerObject);
            rsaPrivateKeyData.setModulus(new BigInteger(1, integerObject.getValue()));
            pos = PEMCertificate.initASN1Object(rsaPrivateKeySequence.getValue(), pos, integerObject);
            pos = PEMCertificate.initASN1Object(rsaPrivateKeySequence.getValue(), pos, integerObject);
            rsaPrivateKeyData.setPrivateExponent(new BigInteger(1, integerObject.getValue()));
            return KeyFactory.getInstance("RSA").generatePrivate(new RSAPrivateKeySpec(rsaPrivateKeyData.getModulus(), rsaPrivateKeyData.getPrivateExponent()));
        }
        return null;
    }

    public static int initASN1Object(byte[] data, int pos, ASN1Object object) throws Exception {
        if (pos >= data.length) {
            throw new Exception("pos >= data.length");
        }
        byte b = data[pos++];
        object.setLabelClass((byte)((b & 0xC0) >> 6));
        object.setPrimitiveFlag((byte)(b & 0x20) == 0);
        object.setLabelType((byte)(b & 0x1F));
        if (object.getLabelType() == 31) {
            throw new Exception("object.getLabelType() == 31!!!");
        }
        b = data[pos++];
        int a = b & 0x7F;
        byte[] lengthBytes = null;
        if (b > 0) {
            lengthBytes = new byte[]{a};
        } else {
            lengthBytes = new byte[a];
            for (int c = 0; c < a; ++c) {
                lengthBytes[c] = data[pos++];
            }
        }
        object.setLength(new BigInteger(1, lengthBytes).intValue());
        ArrayList<Byte> value = new ArrayList<Byte>();
        for (int c = 0; c < object.getLength(); ++c) {
            value.add(data[pos++]);
        }
        byte[] aa = new byte[value.size()];
        for (int c = 0; c < aa.length; ++c) {
            aa[c] = (Byte)value.get(c);
        }
        object.setValue(aa);
        return pos;
    }

    class ASN1Object {
        private byte labelClass = 0;
        private boolean primitiveFlag = true;
        private int labelType;
        private int length;
        private byte[] value;

        public ASN1Object(PEMCertificate this$0) {
        }

        public byte getLabelClass() {
            return this.labelClass;
        }

        public void setLabelClass(byte labelClass) {
            this.labelClass = labelClass;
        }

        public boolean isPrimitiveFlag() {
            return this.primitiveFlag;
        }

        public void setPrimitiveFlag(boolean primitiveFlag) {
            this.primitiveFlag = primitiveFlag;
        }

        public int getLabelType() {
            return this.labelType;
        }

        public void setLabelType(int labelType) {
            this.labelType = labelType;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public byte[] getValue() {
            return this.value;
        }

        public void setValue(byte[] value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder str = new StringBuilder("labelClass = ").append(this.labelClass).append("; primitiveFlag=").append(this.primitiveFlag).append("; labelType=").append(this.labelType).append("; length=").append(this.length).append("; value=").append(this.value);
            return str.toString();
        }
    }

    class ASN1ObjectIdentifier
    extends ASN1Object {
        ASN1ObjectIdentifier(PEMCertificate this$0) {
            super(this$0);
        }

        public String getOID() {
            StringBuffer buffer = new StringBuffer();
            if (this.getLabelType() == 6) {
                byte[] value = this.getValue();
                if (value.length > 0) {
                    if (value[0] < 40) {
                        buffer.append("0." + value[0]);
                    } else if (value[0] > 39 && value[0] < 80) {
                        buffer.append("1." + (value[0] - 40));
                    } else {
                        buffer.append("2." + (value[0] - 80));
                    }
                }
                int pos = 1;
                while (pos < value.length) {
                    long sid = 0L;
                    do {
                        sid <<= 7;
                        sid |= (long)(value[pos] & 0x7F);
                    } while ((value[pos++] & 0x80) != 0);
                    buffer.append("." + sid);
                }
            }
            return buffer.toString();
        }
    }

    class DSAPrivateKeyData {
        private BigInteger x;
        private BigInteger p;
        private BigInteger q;
        private BigInteger g;

        DSAPrivateKeyData(PEMCertificate this$0) {
        }

        public BigInteger getX() {
            return this.x;
        }

        public void setX(BigInteger x) {
            this.x = x;
        }

        public BigInteger getP() {
            return this.p;
        }

        public void setP(BigInteger p) {
            this.p = p;
        }

        public BigInteger getQ() {
            return this.q;
        }

        public void setQ(BigInteger q) {
            this.q = q;
        }

        public BigInteger getG() {
            return this.g;
        }

        public void setG(BigInteger g) {
            this.g = g;
        }
    }

    class RSAPrivateKeyData {
        private BigInteger version;
        private BigInteger modulus;
        private BigInteger publicExponent;
        private BigInteger privateExponent;
        private BigInteger prime1;
        private BigInteger prime2;
        private BigInteger exponent1;
        private BigInteger exponent2;
        private BigInteger coefficient;

        RSAPrivateKeyData(PEMCertificate this$0) {
        }

        public BigInteger getVersion() {
            return this.version;
        }

        public void setVersion(BigInteger version) {
            this.version = version;
        }

        public BigInteger getModulus() {
            return this.modulus;
        }

        public void setModulus(BigInteger modulus) {
            this.modulus = modulus;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public void setPublicExponent(BigInteger publicExponent) {
            this.publicExponent = publicExponent;
        }

        public BigInteger getPrivateExponent() {
            return this.privateExponent;
        }

        public void setPrivateExponent(BigInteger privateExponent) {
            this.privateExponent = privateExponent;
        }

        public BigInteger getPrime1() {
            return this.prime1;
        }

        public void setPrime1(BigInteger prime1) {
            this.prime1 = prime1;
        }

        public BigInteger getPrime2() {
            return this.prime2;
        }

        public void setPrime2(BigInteger prime2) {
            this.prime2 = prime2;
        }

        public BigInteger getExponent1() {
            return this.exponent1;
        }

        public void setExponent1(BigInteger exponent1) {
            this.exponent1 = exponent1;
        }

        public BigInteger getExponent2() {
            return this.exponent2;
        }

        public void setExponent2(BigInteger exponent2) {
            this.exponent2 = exponent2;
        }

        public BigInteger getCoefficient() {
            return this.coefficient;
        }

        public void setCoefficient(BigInteger coefficient) {
            this.coefficient = coefficient;
        }
    }
}

