/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.common.util.FrequencyCounter;
import ru.bitel.common.util.TimeoutMap;
import ru.bitel.common.worker.WorkerThreadFactory;

public class RadiusBan {
    private static final Logger logger = LogManager.getLogger();
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR_SERVICE = Executors.newScheduledThreadPool(4, (ThreadFactory)new WorkerThreadFactory("rad-ban-service", null, null));
    private final TimeoutMap<String, FrequencyCounter> frequencyCounterMap = new TimeoutMap(SCHEDULED_EXECUTOR_SERVICE, 180L, 30L, TimeUnit.SECONDS);
    private volatile boolean working = true;
    private final TimeoutMap<String, Long> banMap = new TimeoutMap(SCHEDULED_EXECUTOR_SERVICE, 180L, 30L, TimeUnit.SECONDS);
    private List<RadiusAttributeInfo<?>> keyAttributes = new ArrayList();
    private final long period;
    private final Set<Integer> accessCodes;
    private final long maxRejectCount;
    private final long banTime;

    public RadiusBan(TimeUnit timeUnit, long period, long maxRejectCount, List<String> keyAttributes, Set<Integer> accessCodes, long banTime) {
        this.period = timeUnit.toMillis(period);
        this.maxRejectCount = maxRejectCount;
        this.accessCodes = accessCodes;
        this.banTime = timeUnit.toMillis(banTime);
        for (String attrName : keyAttributes) {
            RadiusAttributeInfo<?> attr = RadiusDictionary.findAttributeInfo(attrName);
            if (attr == null) {
                logger.error("RadiusBan init attr " + attrName + " notfound!");
                return;
            }
            this.keyAttributes.add(attr);
        }
        if (period <= 0L || maxRejectCount <= 0L || banTime <= 999L) {
            this.working = false;
        }
    }

    private String getKey(RadiusPacket packet) {
        StringBuilder key = new StringBuilder(30);
        for (RadiusAttributeInfo<?> attr : this.keyAttributes) {
            Object attrValue = packet.getAttribute(attr.vendor, attr.type);
            if (attrValue != null) {
                key.append(((RadiusAttribute)attrValue).toString());
            } else {
                key.append("null");
            }
            key.append(" ");
        }
        return key.toString();
    }

    public boolean isBanned(RadiusPacket packet, long millis) {
        if (!this.working) {
            return false;
        }
        String key = this.getKey(packet);
        Long expire = (Long)this.banMap.get((Object)key);
        if (expire != null) {
            if (millis < expire) {
                return true;
            }
            this.banMap.remove((Object)key);
        }
        return false;
    }

    public void reject(RadiusPacket packet, int accessCode, long millis) {
        long count;
        FrequencyCounter newCounter;
        if (!this.working || !this.accessCodes.contains(accessCode) && !this.accessCodes.contains(-1)) {
            return;
        }
        String key = this.getKey(packet);
        FrequencyCounter counter = (FrequencyCounter)this.frequencyCounterMap.get((Object)key);
        if (counter == null && (counter = (FrequencyCounter)this.frequencyCounterMap.putIfAbsent((Object)key, (Object)(newCounter = new FrequencyCounter(this.period, TimeUnit.MILLISECONDS)), this.period)) == null) {
            counter = newCounter;
        }
        if ((count = counter.addAndGet(millis, 1L)) >= this.maxRejectCount) {
            logger.info("Add to ban: " + key);
            long expire = millis + this.banTime;
            this.banMap.put((Object)key, (Object)expire, expire);
            this.frequencyCounterMap.remove((Object)key);
        }
    }

    public void shutdown() {
        this.working = false;
        this.frequencyCounterMap.shutdown();
        this.frequencyCounterMap.clear();
        this.banMap.shutdown();
        this.banMap.clear();
    }
}

