/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class ReserveTypeDao
extends AbstractDirectoryIdDao<ReserveType> {
    public ReserveTypeDao(Connection con) {
        super(con, 0, "contract_reserve_types");
    }

    @Override
    public ReserveType get(String title) throws BGException {
        return null;
    }

    @Override
    public List<ReserveType> list() throws BGException {
        return this.list(false);
    }

    public List<ReserveType> list(boolean used) throws BGException {
        if (used) {
            return super.list("used=?", null, true);
        }
        return super.list(null, null, new Object[0]);
    }

    public Map<Integer, ReserveType> getTypeMapByIds(List<Integer> typeIds) throws BGException {
        HashMap<Integer, ReserveType> resultMap = new HashMap<Integer, ReserveType>();
        for (ReserveType reserveType : this.list((String)(typeIds != null && typeIds.size() > 0 ? "id IN ( " + Utils.toString(typeIds) + " )" : ""), null, new Object[0])) {
            resultMap.put(reserveType.getId(), reserveType);
        }
        return resultMap;
    }

    @Override
    protected ReserveType getFromRS(ResultSet rs) throws SQLException, BGException {
        return new ReserveType(rs.getInt("id"), rs.getString("title"), rs.getBoolean("used"));
    }

    @Override
    protected void updateImpl(ReserveType reserveType) throws BGException, SQLException {
        StringBuilder query = new StringBuilder();
        query.append("INSERT INTO " + this.tableName + " (id, title, used) VALUES (?,?,?) ON DUPLICATE KEY UPDATE title=?, used=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, reserveType.getId() < 1 ? 0 : reserveType.getId());
        ps.setString(2, reserveType.getTitle());
        ps.setBoolean(3, reserveType.isUsed());
        ps.setString(4, reserveType.getTitle());
        ps.setBoolean(5, reserveType.isUsed());
        ps.executeUpdate();
        ps.close();
    }
}

