/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server.bean;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.script.server.dev.GlobalScript;
import ru.bitel.bgbilling.kernel.script.server.dev.GlobalScriptBase;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class GlobalScriptInvoker {
    private static final Logger logger = LogManager.getLogger();

    public static void invoke(String className, ConnectionSet set, PrintStream out, PrintStream err, ParameterMap params) throws Throwable {
        GlobalScript script = DynamicClassManager.getInstance().newInstance(GlobalScript.class, className);
        if (script instanceof GlobalScriptBase) {
            ((GlobalScriptBase)script).setErrorStream(err);
            ((GlobalScriptBase)script).setOutputStream(out);
            ((GlobalScriptBase)script).setParams(params);
        }
        script.execute(Setup.getSetup(), set);
    }

    public static void invoke(String command) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = Pattern.compile("(?:\\A|[\\s]*)(?:(?:\"(.+?)\")|(?:(.+?)))(?:[\\s]|\\z)").matcher(command);
        while (m.find()) {
            String k = m.group(1);
            if (k == null) {
                k = m.group(2);
            }
            args.add(k);
        }
        if (args.size() == 0) {
            throw new IllegalArgumentException(command);
        }
        String className = (String)args.remove(0);
        GlobalScriptInvoker.invoke(className, args.toArray(new String[args.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(String className, String[] args) throws Exception {
        Class<?> clazz = DynamicClassManager.getInstance().loadClass(className);
        if (GlobalScript.class.isAssignableFrom(clazz)) {
            GlobalScript script = (GlobalScript)clazz.newInstance();
            Setup setup = Setup.getSetup();
            ServerContext context = new ServerContext(setup, 0, 0);
            ThreadContext parentContext = ServerContext.push((ThreadContext)context);
            ByteArrayOutputStream outBaos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(outBaos);
            ByteArrayOutputStream errBaos = new ByteArrayOutputStream();
            PrintStream err = new PrintStream(errBaos);
            try {
                if (script instanceof GlobalScriptBase) {
                    ((GlobalScriptBase)script).setErrorStream(err);
                    ((GlobalScriptBase)script).setOutputStream(out);
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    for (String arg : args) {
                        data.put(arg, null);
                    }
                    ((GlobalScriptBase)script).setParams((ParameterMap)new ParameterMap.DefaultParameterMap(data));
                }
                script.execute(setup, context.getConnectionSet());
                context.commit();
            }
            finally {
                ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
                out.flush();
                err.flush();
                if (outBaos.size() > 0) {
                    logger.info(outBaos.toString());
                }
                if (errBaos.size() > 0) {
                    logger.error(outBaos.toString());
                }
            }
        }
        Setup setup = Setup.getSetup();
        ServerContext context = new ServerContext(setup, 0, 0);
        ThreadContext parentContext = ServerContext.push((ThreadContext)context);
        try {
            Method main = clazz.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
            context.commit();
        }
        finally {
            ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
        }
    }
}

