/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class ClosedTabs {
    private static final int TABS_CACHE_CAPACITY = 10;
    private static final ClosedTabs instance = new ClosedTabs();
    private final ClosedTabsDialog closedTabsDialog = new ClosedTabsDialog();
    private final Map<String, AbstractTabPanel> closedTabsCache = new LinkedHashMap<String, AbstractTabPanel>();
    private AbstractTabPanel lastClosedTab = null;

    private ClosedTabs() {
    }

    public static ClosedTabs getInstance() {
        return instance;
    }

    public void put(AbstractTabPanel tab) {
        this.lastClosedTab = tab;
        if (this.closedTabsCache.get(tab.getTabId()) != null) {
            this.closedTabsCache.remove(tab.getTabId());
        }
        this.closedTabsCache.put(tab.getTabId(), tab);
        if (this.closedTabsCache.size() > 10) {
            this.trimToSize();
        }
    }

    private void trimToSize() {
        LinkedHashMap<String, AbstractTabPanel> map = new LinkedHashMap<String, AbstractTabPanel>();
        ArrayList<AbstractTabPanel> values = new ArrayList<AbstractTabPanel>(this.closedTabsCache.values());
        int offset = values.size() - 10;
        for (int i = 0; i < 10; ++i) {
            AbstractTabPanel tabPanel = (AbstractTabPanel)values.get(offset);
            map.put(tabPanel.getTabId(), tabPanel);
            ++offset;
        }
        this.closedTabsCache.clear();
        this.closedTabsCache.putAll(map);
    }

    public void openTab(String tabId) {
        AbstractTabPanel tabPanel = this.closedTabsCache.get(tabId);
        if (tabPanel != null) {
            BGClientBase.getFrame().getTabbedPane().addTab(tabId, tabPanel);
        }
    }

    public void openLastClosedTab() {
        if (this.lastClosedTab != null) {
            this.openTab(this.lastClosedTab.getTabId());
        }
    }

    public void showClosedTabsDialog() {
        this.closedTabsDialog.showDialog();
    }

    private final class ClosedTabsDialog
    extends BGDialog {
        private final BGUList<ClosedTab> tabsList = new BGUList();
        private final List<ClosedTab> data = new ArrayList<ClosedTab>();

        ClosedTabsDialog() {
            this.setTitle("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435 \u0432\u043a\u043b\u0430\u0434\u043a\u0438");
            this.setSize(400, 350);
            this.setResizable(true);
            this.getContentPane().add(new JScrollPane(this.tabsList));
            this.tabsList.setSelectionMode(0);
            this.tabsList.setCellRenderer(new ClosedTabListRenderer());
            this.tabsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ClosedTab selectedTab;
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (selectedTab = (ClosedTab)ClosedTabsDialog.this.tabsList.getSelectedValue()) != null) {
                        ClosedTabs.this.openTab(selectedTab.getTabId());
                        ClosedTabsDialog.this.setVisible(false);
                    }
                }
            });
        }

        @Override
        public String showDialog() {
            this.data.clear();
            List tabs = ClosedTabs.this.closedTabsCache.values().stream().map(tab -> new ClosedTab(tab.getTabTitle(), tab.getTabId())).collect(Collectors.toList());
            Collections.reverse(tabs);
            this.data.addAll(tabs);
            this.tabsList.setData(this.data);
            this.moveWindowToCenterScreen();
            return super.showDialog();
        }
    }

    private static final class ClosedTabListRenderer
    implements ListCellRenderer<ClosedTab> {
        private ClosedTabListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ClosedTab> list, ClosedTab tab, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel titleLabel = new JLabel(tab.getTitle());
            titleLabel.setBackground(Color.WHITE);
            titleLabel.setFont(new Font("Monospaced", 0, 20));
            JPanel renderedPanel = new JPanel(new GridBagLayout());
            renderedPanel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            renderedPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
            renderedPanel.add((Component)titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0));
            return renderedPanel;
        }
    }

    private static final class ClosedTab
    extends IdTitle {
        private String tabId;

        public ClosedTab(String title, String tabId) {
            super(0, title);
            this.tabId = tabId;
        }

        public String getTabId() {
            return this.tabId;
        }

        public void setTabId(String tabId) {
            this.tabId = tabId;
        }
    }
}

