/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.application.server;

import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.AppRequestEvent;

public class BGAppJmxConnectorServer
extends BGLogger {
    private int appId = 0;
    private String host = "127.0.0.1";
    private int port = 1099;
    private Registry rmiRegistry = null;
    private JMXConnectorServer jmxConnectorServer = null;
    private static BGAppJmxConnectorServer server = null;

    public static void init(int appId) {
        if (server == null) {
            server = new BGAppJmxConnectorServer(appId);
            server.a();
        }
    }

    public BGAppJmxConnectorServer getInstance() {
        return server;
    }

    private BGAppJmxConnectorServer(int appId) {
        this.appId = appId;
    }

    private void a() {
        try {
            EventProcessor.getInstance().addListener(new EventListener<AppRequestEvent>(){

                @Override
                public void notify(AppRequestEvent e, EventListenerContext ctx) throws Exception {
                    if (e.getAppId() != BGAppJmxConnectorServer.this.appId) {
                        return;
                    }
                    if ("startJMX".equals(e.getCommand())) {
                        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                        BGAppJmxConnectorServer.this.rmiRegistry = LocateRegistry.createRegistry(BGAppJmxConnectorServer.this.port);
                        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + BGAppJmxConnectorServer.this.host + ":" + BGAppJmxConnectorServer.this.port + "/jmxrmi");
                        BGAppJmxConnectorServer.this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mBeanServer);
                        BGAppJmxConnectorServer.this.jmxConnectorServer.start();
                    } else if ("stopJMX".equals(e.getCommand())) {
                        if (BGAppJmxConnectorServer.this.rmiRegistry == null) {
                            return;
                        }
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    BGAppJmxConnectorServer.this.jmxConnectorServer.stop();
                                    UnicastRemoteObject.unexportObject(BGAppJmxConnectorServer.this.rmiRegistry, true);
                                }
                                catch (Exception ex) {
                                    BGAppJmxConnectorServer.this.logError(ex);
                                }
                            }
                        }.start();
                    }
                }
            }, AppRequestEvent.class);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }
}

