/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.admin.TransferManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.runner.BGClientRunnerCipher;
import ru.bitel.bgbilling.client.runner.BGClientRunnerUtil;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractTabbedPane;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.client.inpoint.OnStop;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.function.TryCall;

public class DBInfoManager
implements Comparator<DBInfo> {
    private boolean anySSL = false;
    private DBInfo active = null;
    private String defaultServerKey = null;
    private String updateServerKey = null;
    private Set<String> serverPluginSet = null;
    private Map<String, String> authorizedKeys = new HashMap<String, String>();
    private Map<String, DBInfo> globalServers = new HashMap<String, DBInfo>();
    private Map<String, List<JPanel>> tabs = new HashMap<String, List<JPanel>>();
    private Map<String, Integer> selectedTabs = new HashMap<String, Integer>();
    private String serversListMode = "all";
    private static final TimeZone defaultTimeZone = TimeZone.getDefault();
    private static DBInfoManager manager;

    public static DBInfoManager getManager() {
        if (manager == null) {
            manager = new DBInfoManager();
        }
        return manager;
    }

    private DBInfoManager() {
        this.parseServersConfig();
    }

    public DBInfo getInfo(String key) {
        return key != null ? this.globalServers.get(key) : null;
    }

    public void addServer(DBInfo info) {
        this.globalServers.put(info.getDbServerKey(), info);
    }

    public void removeServer(DBInfo info) {
        this.globalServers.remove(info.getDbServerKey());
        this.saveServersConfig();
    }

    public List<DBInfo> getInfoLists() {
        ArrayList<DBInfo> result = new ArrayList<DBInfo>();
        for (Map.Entry<String, DBInfo> entry : this.globalServers.entrySet()) {
            result.add(entry.getValue());
        }
        Collections.sort(result, this);
        return result;
    }

    public List<DBInfo> getInfoLists(boolean favorite) {
        List<DBInfo> allList = this.getInfoLists();
        ArrayList<DBInfo> result = new ArrayList<DBInfo>();
        if (favorite) {
            result.addAll(allList.stream().filter(w -> w.isFavorite()).collect(Collectors.toList()));
        } else {
            result.addAll(allList.stream().filter(w -> !w.isFavorite()).collect(Collectors.toList()));
        }
        return result;
    }

    public void setActiveDBInfo(DBInfo dbInfo) {
        this.active = dbInfo;
        if (dbInfo != null) {
            this.defaultServerKey = dbInfo.getDbServerKey();
        }
    }

    public void setAutorized(DBInfo info, boolean flag) {
        if (flag) {
            this.authorizedKeys.put(info.getDbServerKey(), "true");
        } else {
            this.authorizedKeys.remove(info.getDbServerKey());
        }
    }

    public boolean isAutorized(DBInfo info) {
        return this.authorizedKeys.get(info.getDbServerKey()) != null && this.authorizedKeys.get(info.getDbServerKey()).equals("true");
    }

    protected void saveParamsToSetup(DBInfo dbInfo) {
        ClientSetup clientSetup = ClientSetup.getInstance();
        clientSetup.removeAllWithPrefix("dbinfo.");
        clientSetup.putAll(dbInfo.getParamsMap());
        clientSetup.setModulesParametrs(dbInfo.getModulesParamsMap());
        clientSetup.setPluginsParametrs(dbInfo.getPluginsParamsMap());
    }

    public List<JPanel> loadTabs(DBInfo info) {
        List<JPanel> list = this.tabs.get(info.getDbServerKey());
        ContractTabbedPane pane = BGClientBase.getFrame().getTabbedPane();
        pane.setTabList(list);
        Integer index = this.selectedTabs.get(info.getDbServerKey());
        if (index != null) {
            pane.setSelectedIndex(index);
        }
        return list;
    }

    public void removeTabs(DBInfo info) {
        List<JPanel> list = this.tabs.get(info.getDbServerKey());
        if (list != null) {
            list.clear();
        }
        this.selectedTabs.put(info.getDbServerKey(), null);
    }

    public boolean connect(DBInfo dbInfo) throws Exception {
        this.setAutorized(dbInfo, false);
        dbInfo.setConnected(false);
        if (!this.performConnect(dbInfo)) {
            return false;
        }
        dbInfo.setConnected(true);
        this.setAutorized(dbInfo, true);
        return true;
    }

    protected boolean performConnect(DBInfo dbInfo) throws Exception {
        if (!this.setMenuToolBarData(dbInfo)) {
            return false;
        }
        this.saveParamsToSetup(dbInfo);
        return true;
    }

    public boolean setMenuToolBarData(DBInfo dbInfo) throws Exception {
        dbInfo.setProxy();
        Document doc = this.getMenu(dbInfo);
        if (doc == null) {
            return false;
        }
        if (!ClientUtils.checkStatus(doc)) {
            return false;
        }
        String timeZone = XMLUtils.selectText(doc, "//data/@timeZone");
        if (Utils.notBlankString(timeZone)) {
            TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        } else {
            TimeZone.setDefault(defaultTimeZone);
        }
        ClientSetup.getInstance().setUserId(Utils.parseInt(XMLUtils.selectText(doc, "//data/@userId"), 0));
        String serverVersionNumber = XMLUtils.selectText(doc, "//data/@clientversion", "?");
        BGClientBase.getFrame().setTitle("BGBillingClient (\u0432\u0435\u0440. " + serverVersionNumber + ")");
        dbInfo.setTimeZone(TimeZone.getDefault());
        dbInfo.setMenuBarNode(XMLUtils.selectNode(doc, "//menuBar"));
        dbInfo.setToolBarNode(XMLUtils.selectNode(doc, "//toolBar"));
        dbInfo.setParamsNode(XMLUtils.selectNode(doc, "//params"));
        dbInfo.setModulesNode(XMLUtils.selectNode(doc, "//moduleParams"));
        dbInfo.setPluginsNode(XMLUtils.selectNode(doc, "//pluginParams"));
        dbInfo.setFirmTitle(doc.getDocumentElement().getAttribute("firmTitle"));
        dbInfo.setServerVersion(doc.getDocumentElement().getAttribute("serverversion"));
        dbInfo.setUser(doc.getDocumentElement().getAttribute("user"));
        this.setPluginSet(doc);
        return true;
    }

    public void disconnect(DBInfo info) {
        if (this.getActiveDBInfo() != null) {
            for (OnStop p : BGPluginManagerClient.getManager().getInvokeables(OnStop.class, false)) {
                p.onStop();
            }
        }
        info.setConnected(false);
        this.setAutorized(info, false);
        this.removeTabs(info);
        if (this.getActiveDBInfo() != null && this.getActiveDBInfo().getDbServerKey().equals(info.getDbServerKey())) {
            this.setActiveDBInfo(null);
        }
    }

    public DBInfo getActiveDBInfo() {
        return this.active;
    }

    public String getDefaultServerKey() {
        return this.defaultServerKey;
    }

    protected Document getMenu(DBInfo dbInfo) {
        Request request = new Request().setModule("admin").setAction("MenuAndToolBar");
        Document doc = null;
        try {
            doc = TransferManager.getDocument(request, dbInfo);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return doc;
    }

    public void saveTabs(DBInfo info) {
        List<JPanel> list = this.tabs.get(info.getDbServerKey());
        if (list != null) {
            list.clear();
        }
        list = new ArrayList<JPanel>();
        ContractTabbedPane pane = BGClientBase.getFrame().getTabbedPane();
        list.addAll(pane.getTabList());
        this.tabs.put(info.getDbServerKey(), list);
        this.selectedTabs.put(info.getDbServerKey(), pane.getSelectedIndex());
    }

    protected String getSetupValue(ClientSetup setup, String key, String defaultValue) {
        return setup.get(key, System.getProperty(key, defaultValue));
    }

    public List<DBInfo> getAuthList() {
        ArrayList<DBInfo> result = new ArrayList<DBInfo>();
        for (String key : this.authorizedKeys.keySet()) {
            result.add(this.getInfo(key));
        }
        return result;
    }

    protected List<DBInfo> parseDBInfo() {
        ArrayList<DBInfo> list = new ArrayList<DBInfo>();
        try {
            int i = 0;
            ClientSetup setup = ClientSetup.getInstance();
            while (true) {
                String prefix = "db.server." + i + ".";
                DBInfo info = new DBInfo();
                info.setLocalItem(false);
                info.setDbServerKey(String.valueOf(i));
                info.setDbServerTitle(this.getSetupValue(setup, prefix + "title", null));
                info.setDbServerURL(this.getSetupValue(setup, prefix + "url", null));
                info.setDbServerProxyHost(this.getSetupValue(setup, prefix + "proxy.host", ""));
                info.setDbServerProxyPort(this.getSetupValue(setup, prefix + "proxy.port", ""));
                info.setDbServerLogin(setup.get(prefix + "login", ""));
                info.setDbServerPassword(setup.get(prefix + "password", ""));
                info.setFavorite(Utils.parseBoolean(setup.get(prefix + "favorite", "")));
                if (info.getDbServerTitle() != null && info.getDbServerURL() != null) {
                    list.add(info);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    protected void setPluginSet(Document doc) throws Exception {
        LinkedHashSet<String> serverPlugins = new LinkedHashSet<String>();
        Element pluginList = XMLUtils.selectElement(doc, "//pluginParams");
        if (pluginList != null) {
            NodeList plugins = pluginList.getElementsByTagName("plugin");
            int size = plugins.getLength();
            for (int i = 0; i < size; ++i) {
                Element pluginEl = (Element)plugins.item(i);
                serverPlugins.add(pluginEl.getAttribute("id"));
            }
        }
        this.setServerPluginSet(serverPlugins);
        BGPluginManagerClient.getManager().setPluginsOnServer(serverPlugins);
    }

    public void flush() {
        ClientSetup clientSetup = ClientSetup.getInstance();
        for (Map.Entry<String, DBInfo> entry : this.globalServers.entrySet()) {
            DBInfo info = entry.getValue();
            clientSetup.removeAllWithPrefixFromUserConfig("db.server." + info.getDbServerKey());
            if (!info.isLocalItem() && info.isSaveAccount()) {
                this.writeAuth(info);
                continue;
            }
            if (!info.isLocalItem()) continue;
            String key = "db.server." + info.getDbServerKey() + ".info";
            String value = info.getDbServerTitle() + "\t" + info.getDbServerURL() + "\t" + info.getDbServerProxyHost() + "\t" + info.getDbServerProxyPort() + "\t" + info.isFavorite() + "\t";
            clientSetup.getUserConfig().set(key, value);
            if (!info.isSaveAccount() || Utils.isEmptyString(info.getDbServerLogin())) continue;
            this.writeAuth(info);
        }
        clientSetup.removeAllWithPrefixFromUserConfig("db.server.default.key");
        if (this.defaultServerKey != null) {
            clientSetup.getUserConfig().set("db.server.default.key", this.defaultServerKey);
        }
        if (this.active != null && Utils.notBlankString(this.active.getDbServerEmail())) {
            clientSetup.set("user.email", this.active.getDbServerEmail());
        }
        clientSetup.saveUserConfig();
    }

    public void writeAuth(DBInfo info) {
        String auth = info.getDbServerLogin() + "\t" + info.getDbServerPassword() + "\t" + info.getDbServerEmail() + "\t" + info.isFavorite() + "\t";
        String sauth = BGClientRunnerCipher.cipher(auth, false);
        String key = "db.server." + info.getDbServerKey() + (sauth != null ? ".sauth" : ".auth");
        ClientSetup.getInstance().getUserConfig().set(key, (String)(sauth != null ? sauth : auth));
    }

    protected void saveServersConfig() {
        BGClientRunnerUtil.saveServersConfig(this.getInfoLists(), this.getDefaultServerKey(), this.getServersListMode(), this.isAnySSL());
    }

    public void setServersListMode(String serversListMode) {
        this.serversListMode = serversListMode;
    }

    public String getServersListMode() {
        return this.serversListMode != null ? this.serversListMode : "all";
    }

    private String getJSONObjectValue(JSONObject jsonObject, String key, String defaultValue) {
        return jsonObject != null && jsonObject.has(key) ? jsonObject.getString(key) : defaultValue;
    }

    private void loadDBInfoFromProperties() {
        String favKey;
        boolean favorite;
        List<DBInfo> serverList = this.parseDBInfo();
        for (DBInfo info : serverList) {
            this.globalServers.put(info.getDbServerKey(), info);
        }
        ClientSetup clientSetup = ClientSetup.getInstance();
        this.defaultServerKey = clientSetup.getUserConfig().get("db.server.default.key");
        HashSet<String> serversKeys = new HashSet<String>();
        ParameterMap serversMap = clientSetup.sub("db.server.");
        Pattern pattern = Pattern.compile("^([\\d\\w]+)\\.(info|title)$");
        for (Map.Entry<String, String> entry : serversMap.entrySet()) {
            Matcher m = pattern.matcher(entry.getKey());
            if (!m.find()) continue;
            serversKeys.add(m.group(1));
        }
        for (String key : serversKeys) {
            int idx;
            String[] values;
            DBInfo info;
            String value = serversMap.get(key + ".info");
            String auth = serversMap.get(key + ".auth");
            String sauth = serversMap.get(key + ".sauth");
            if (sauth != null) {
                auth = BGClientRunnerCipher.cipher(sauth, true);
            }
            if ((info = this.globalServers.get(key)) == null) {
                info = new DBInfo();
                info.setLocalItem(true);
                this.globalServers.put(key, info);
            }
            if (value != null) {
                values = value.split("\t");
                idx = 0;
                String title = values[idx++];
                String url = values[idx++];
                String proxy = "";
                String port = "";
                favorite = false;
                if (idx < values.length) {
                    proxy = values[idx++];
                }
                if (idx < values.length) {
                    port = values[idx++];
                }
                if (idx < values.length) {
                    favorite = Utils.parseBoolean(values[idx++]);
                } else {
                    favKey = "server.db." + info.getDbServerKey() + ".Favorit";
                    favorite = Utils.parseBoolean(clientSetup.getUserConfig().get(favKey));
                }
                info.setDbServerKey(key);
                info.setDbServerTitle(title);
                info.setDbServerURL(url);
                info.setDbServerProxyHost(proxy);
                info.setDbServerProxyPort(port);
                info.setFavorite(favorite);
            }
            if (auth != null) {
                values = auth.split("\t", -1);
                idx = 0;
                String login = values[idx++];
                String password = values[idx++];
                info.setDbServerLogin(login);
                info.setDbServerPassword(password);
            }
            if (Utils.isEmptyString(info.getDbServerLogin())) continue;
            info.setSaveAccount(true);
        }
        pattern = Pattern.compile("^([^\\.]+)\\.sauth$");
        for (Map.Entry<String, String> entry : serversMap.entrySet()) {
            String auth;
            DBInfo info;
            String sauth;
            String key = entry.getKey();
            if (!key.endsWith(".sauth") || (sauth = serversMap.get(key)) == null) continue;
            String serverKey = null;
            Matcher m = pattern.matcher(key);
            if (m.find()) {
                serverKey = m.group(1);
            }
            if ((info = this.globalServers.get(serverKey)) == null || (auth = BGClientRunnerCipher.cipher(sauth, true)) == null) continue;
            String[] values = auth.split("\t");
            int idx = 0;
            String login = values[idx++];
            String password = values[idx++];
            favorite = false;
            if (values.length > 3) {
                favorite = Utils.parseBoolean(values[++idx]);
            } else {
                favKey = "server.db." + info.getDbServerKey() + ".Favorit";
                favorite = Utils.parseBoolean(clientSetup.getUserConfig().get(favKey));
            }
            info.setDbServerLogin(login);
            info.setDbServerPassword(password);
            info.setFavorite(favorite);
            if (Utils.isEmptyString(info.getDbServerLogin())) continue;
            info.setSaveAccount(true);
        }
    }

    protected void parseServersConfig() {
        TryCall.call(() -> {
            String serversConfig = BGClientRunnerUtil.loadServersConfig();
            if (serversConfig.length() > 0) {
                JSONObject serversJsonObject = new JSONObject(serversConfig.toString());
                if (serversJsonObject.has("param")) {
                    JSONObject serversParamJSONObject = serversJsonObject.getJSONObject("param");
                    this.defaultServerKey = this.getJSONObjectValue(serversParamJSONObject, "defaultServerKey", this.defaultServerKey);
                    this.serversListMode = this.getJSONObjectValue(serversParamJSONObject, "serversListMode", this.serversListMode);
                    this.anySSL = Boolean.valueOf(this.getJSONObjectValue(serversParamJSONObject, "anySSL", String.valueOf(this.anySSL)));
                }
                if (serversJsonObject.has("servers")) {
                    JSONArray serversJSONArray = serversJsonObject.getJSONArray("servers");
                    this.globalServers.clear();
                    for (int index = 0; index < serversJSONArray.length(); ++index) {
                        JSONObject dbInfoJSONObject = serversJSONArray.getJSONObject(index);
                        DBInfo dbInfo = DBInfo.parseDBInfoFromJson(dbInfoJSONObject);
                        dbInfo.setLocalItem(true);
                        this.globalServers.put(dbInfo.getDbServerKey(), dbInfo);
                    }
                }
            } else {
                this.loadDBInfoFromProperties();
            }
        });
    }

    public String getUpdateServerKey() {
        return this.updateServerKey;
    }

    public void clearUpdateKey() {
        this.updateServerKey = null;
    }

    public boolean isUpdate(DBInfo dbInfo) {
        return this.updateServerKey != null && this.updateServerKey.equals(dbInfo.getDbServerKey());
    }

    public void setUpdate(DBInfo dbInfo) {
        this.updateServerKey = dbInfo.getDbServerKey();
    }

    public Set<String> getServerPluginSet() {
        return this.serverPluginSet;
    }

    public void setServerPluginSet(Set<String> serverPluginList) {
        this.serverPluginSet = serverPluginList;
    }

    public boolean isAnySSL() {
        return this.anySSL;
    }

    public void setAnySSL(boolean anySSL) {
        this.anySSL = anySSL;
    }

    @Override
    public int compare(DBInfo dbInfo1, DBInfo dbInfo2) {
        int result = -1;
        if (dbInfo1.getDbServerTitle() != null && dbInfo2.getDbServerTitle() != null) {
            result = dbInfo1.getDbServerTitle().compareTo(dbInfo2.getDbServerTitle());
        } else if (dbInfo2.getDbServerTitle() != null) {
            result = 1;
        }
        return result;
    }
}

