/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Preferences
extends ParameterMap {
    protected String bundleName;
    protected final Map<String, String> data;
    private final Map<String, Object> objectMap;
    private static final Pattern variablePattern = Pattern.compile("\\{@([\\w\\.]+)\\}");

    @Override
    public String get(String key, String def) {
        String result = this.data.get(key);
        return result != null ? result : def;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    protected void extract(Map<String, String> data) {
        data.putAll(this.data);
    }

    public void set(String key, String value) {
        if (value == null && this.data instanceof ConcurrentHashMap) {
            this.data.remove(key);
            return;
        }
        this.data.put(key, value);
    }

    public Preferences() {
        this(true, true);
    }

    public Preferences(boolean concurrent, boolean objectMap) {
        Map<Object, Object> map = this.data = concurrent ? new ConcurrentHashMap() : new HashMap();
        this.objectMap = objectMap ? (concurrent ? new ConcurrentHashMap() : new HashMap()) : null;
    }

    public Preferences(String bundleName) {
        this(true, true);
        this.bundleName = bundleName;
        this.loadBundle(this.data);
    }

    public Preferences(URL url) {
        this(true, true);
        try {
            if (url != null) {
                this.bundleName = url.getFile();
                this.loadFromInputStream(url.openStream(), this.data);
            }
        }
        catch (Exception ex) {
            BGLogger.error((Throwable)ex);
        }
    }

    public Preferences(String data, String delim) {
        this(null, data, delim, true, true);
    }

    public Preferences(ParameterMap setup, String data, String delim) {
        this(setup, data, delim, true, true);
    }

    public Preferences(ParameterMap setup, String data, String delim, boolean concurrent, boolean objectMap) {
        this(concurrent, objectMap);
        if (setup != null) {
            for (Map.Entry<String, String> e : setup.entrySet()) {
                this.set(e.getKey(), e.getValue());
            }
        }
        this.loadData(data, delim, this.data);
    }

    public Preferences(Map<String, String> data) {
        this(data, true, true);
    }

    public Preferences(Map<String, String> data, boolean concurrent, boolean objectMap) {
        this(concurrent, objectMap);
        this.data.putAll(data);
    }

    public final void putObject(String key, Object val) {
        if (val == null && this.objectMap instanceof ConcurrentHashMap) {
            this.objectMap.remove(key);
            return;
        }
        this.objectMap.put(key, val);
    }

    public final Object getObject(String key, Object def) {
        Object result = this.objectMap.get(key);
        return result != null ? result : def;
    }

    public final Object getObject(String key) {
        return this.objectMap.get(key);
    }

    public final Object removeObject(String key) {
        return this.objectMap.remove(key);
    }

    protected void loadBundle(Map<String, String> data) {
        try {
            File file = new File(this.bundleName.replace('.', '/') + ".xml");
            if (file.exists()) {
                Document doc = XMLUtils.parseDocument(new InputSource(new FileInputStream(file)), XMLUtils.ErrorShowType.EXCEPTION);
                NodeList nodes = doc.getDocumentElement().getChildNodes();
                int length = nodes.getLength();
                for (int i = 0; i < length; ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1 || !"param".equals(node.getNodeName())) continue;
                    Element paramElement = (Element)node;
                    String name = paramElement.getAttribute("name");
                    String value = paramElement.hasAttribute("value") ? paramElement.getAttribute("value") : paramElement.getTextContent().trim();
                    data.put(name, System.getProperty(name, value));
                }
            } else {
                file = new File(this.bundleName.replace('.', '/') + ".properties");
                if (file.exists()) {
                    this.loadFromInputStream(new FileInputStream(file), data);
                } else {
                    BGLogger.error((String)("not found config bundle \"" + this.bundleName + "\""));
                }
            }
        }
        catch (Exception ex) {
            BGLogger.error((String)("error load bundle \"" + this.bundleName + "\""), (Throwable)ex);
        }
    }

    protected void loadFromInputStream(InputStream inputStream, Map<String, String> data) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            this.loadDataEntry(data, line.trim());
        }
        inputStream.close();
    }

    private void loadData(String conf, String delim, Map<String, String> data) {
        StringTokenizer st = new StringTokenizer(Utils.maskNull(conf), delim);
        while (st.hasMoreTokens()) {
            this.loadDataEntry(data, st.nextToken().trim());
        }
    }

    public void loadData(String conf, String delim) {
        this.loadData(conf, delim, this.data);
    }

    private void loadDataEntry(Map<String, String> data, String line) {
        if (line.startsWith("#")) {
            return;
        }
        int pos = line.indexOf(61);
        if (pos > -1) {
            String key = line.substring(0, pos);
            String value = line.substring(pos + 1);
            if (key.startsWith("@")) {
                key = key.substring(1);
            }
            data.put(key, System.getProperty(key, this.insertVariablesValues(value, data)));
        }
    }

    private String insertVariablesValues(String value, Map<String, String> data) {
        Matcher m = variablePattern.matcher(value);
        if (m.find()) {
            StringBuffer newValue = new StringBuffer(value.length() + 16);
            String varName = m.group(1);
            String var = data.get(varName);
            if (var != null) {
                var = Matcher.quoteReplacement(var);
                m.appendReplacement(newValue, var);
            }
            while (m.find()) {
                var = data.get(m.group(1));
                if (var == null) continue;
                var = Matcher.quoteReplacement(var);
                m.appendReplacement(newValue, var);
            }
            m.appendTail(newValue);
            return newValue.toString();
        }
        return value;
    }

    protected void loadModuleSetup(Connection con, int moduleId, Map<String, String> data) {
        String query = "SELECT config FROM module_config WHERE mid=? AND active=1 LIMIT 1";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, moduleId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    this.loadData(rs.getString(1), "\n", data);
                }
            }
        }
        catch (Exception ex) {
            BGLogger.error((String)("error load module setup (moduleId=" + moduleId + ")"), (Throwable)ex);
        }
    }

    protected void updateData(Map<String, String> data) {
        this.data.putAll(data);
        this.data.keySet().retainAll(data.keySet());
    }

    @Override
    public Map<String, String> getMap() {
        return this.data;
    }
}

