/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.common.service;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerAccount;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerPropertyParam;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactType;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerEmployee;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.xml.XmlAdapters;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;

@WebService
@XmlSeeAlso(value={EntityAttr.class, CustomerPropertyParam.class, CustomerContract.class})
public interface CustomerService {
    @WebMethod
    public List<CustomerEmployee> customerEmployeeList(@WebParam(name="customerId") int var1) throws BGException;

    @WebMethod
    public String customerEmployeeUpdate(@WebParam(name="customerId") int var1, @WebParam(name="customerEmployee") CustomerEmployee var2) throws BGException;

    @WebMethod
    public String customerEmployeeDelete(@WebParam(name="customerId") int var1, @WebParam(name="customerEmployeeUUID") String var2) throws BGException;

    @WebMethod
    public Customer customerByAccount(@WebParam(name="account") long var1) throws BGException;

    @WebMethod
    public SearchResult<Customer> searchCustomerList(@WebParam(name="customerType") Customer.CustomerType var1, @WebParam(name="filters") List<KeyValue> var2, @WebParam(name="page") Page var3, @WebParam(name="sort") String[] var4) throws BGException;

    @WebMethod
    public List<CustomerAccount> customerAccounts(@WebParam(name="customerId") int var1) throws BGException;

    @WebMethod
    public CustomerAccount customerAccountAdd(@WebParam(name="customerId") int var1, @WebParam(name="account") long var2) throws BGException;

    @WebMethod
    public void customerAccountSet(@WebParam(name="customerId") int var1, @WebParam(name="contractId") int var2, @WebParam(name="account") long var3) throws BGException;

    @WebMethod
    public void customerAccountDelete(@WebParam(name="customerId") int var1, @WebParam(name="account") long var2) throws BGException;

    @WebMethod
    public String customerParameterGet(@WebParam(name="contractId") int var1) throws BGException;

    @WebMethod
    public String customerParameterUpdate(@WebParam(name="customerId") int var1, @WebParam(name="fieldValue") String var2, @WebParam(name="text") String var3) throws BGException;

    @WebMethod
    public String customerContactUpdate(@WebParam(name="customerId") int var1, @WebParam(name="contactType") CustomerContactType var2, @WebParam(name="text") String var3) throws BGException;

    @WebMethod
    public String customerBankUpdate(@WebParam(name="customerId") int var1, @WebParam(name="text") String var2) throws BGException;

    @WebMethod
    public int customerNewSet(@WebParam(name="contractId") int var1) throws BGException;

    @WebMethod
    public void customerDelete(@WebParam(name="customerId") int var1) throws BGException;

    @WebMethod
    public String customerSearch(@WebParam(name="customerType") Customer.CustomerType var1, @WebParam(name="text") String var2) throws BGException;

    @WebMethod
    public void customerLinkSet(@WebParam(name="contractId") int var1, @WebParam(name="customerId") int var2) throws BGException;

    @WebMethod
    public List<CustomerContract> customerContracts(@WebParam(name="customerId") int var1, @XmlJavaTypeAdapter(type=LocalDateTime.class, value=XmlAdapters.LocalDateTimeAdapter.class) @WebParam(name="onTime") LocalDateTime var2) throws BGException;

    @WebMethod
    public boolean customerUnlinkContract(@WebParam(name="contractId") int var1, @XmlJavaTypeAdapter(type=LocalDateTime.class, value=XmlAdapters.LocalDateTimeAdapter.class) @WebParam(name="unlinkTime") LocalDateTime var2) throws BGException;

    @WebMethod
    public String customerParameterHistory(@WebParam(name="customerId") int var1, @WebParam(name="fieldKey") String var2, @WebParam(name="lastRecordCount") int var3) throws BGException;

    @WebMethod
    public List<String> customerEmails(@WebParam(name="customerId") int var1, @WebParam(name="contractId") int var2) throws BGException;

    @WebMethod
    public List<CustomerPropertyParam> customerPropertyParams(@WebParam(name="customerId") int var1) throws BGException;
}

