/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class DebugUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void dumpVar(Object var) throws Exception {
        DebugUtils.dumpVar(var, new PrintWriter(System.out));
    }

    public static void dumpVar(Object var, Writer writer) throws Exception {
        DebugUtils.dumpVar(var, writer, 0);
        writer.flush();
    }

    private static void dumpVar(Object var, Writer writer, int level) throws Exception {
        if (var == null) {
            DebugUtils.dumpVar("<null>", writer, level);
        } else if (var instanceof Map) {
            Map map = (Map)var;
            DebugUtils.dumpVar(map.getClass().getCanonicalName() + " (Map)[", writer, level);
            for (Map.Entry entry : map.entrySet()) {
                DebugUtils.dumpVar(entry, writer, level + 1);
            }
            DebugUtils.dumpVar("]", writer, level);
        } else if (var instanceof Collection) {
            Collection collection = (Collection)var;
            DebugUtils.dumpVar(collection.getClass().getCanonicalName() + " (Collection)[", writer, level);
            for (Object item : collection) {
                DebugUtils.dumpVar(item, writer, level + 1);
            }
            DebugUtils.dumpVar("]", writer, level);
        } else if (var instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)var;
            StringWriter sw = new StringWriter();
            DebugUtils.dumpVar(entry.getValue(), sw, level);
            DebugUtils.dumpVar(String.valueOf(entry.getKey()) + "=" + sw.toString().trim(), writer, level);
        } else if (var instanceof Node) {
            Node node = (Node)var;
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(sw));
            DebugUtils.dumpVar(sw.toString(), writer, level);
        } else if (var.getClass().isArray()) {
            DebugUtils.dumpVar(var.getClass().getCanonicalName() + " (array)[", writer, level);
            for (int i = 0; i < Array.getLength(var); ++i) {
                DebugUtils.dumpVar(Array.get(var, i), writer, level + 1);
            }
            DebugUtils.dumpVar("]", writer, level);
        } else {
            for (int i = 0; i < level; ++i) {
                writer.append('\t');
            }
            writer.append(var.toString());
            writer.append(LINE_SEPARATOR);
        }
    }

    public static String dumpObject(Object var) {
        StringBuilder sb = new StringBuilder();
        sb.append(var.getClass().getName()).append("@[");
        for (Field field : var.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            sb.append(field.getName()).append("=");
            try {
                sb.append(field.get(var));
            }
            catch (Exception e) {
                sb.append(e);
            }
            sb.append(";");
        }
        sb.append("]@").append(Integer.toHexString(var.hashCode()));
        return sb.toString();
    }
}

