/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.contract.RuleEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractRemoveRule;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractRemoveRuleService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;

public class DeleteContractEditor
extends BGPanel
implements ActionListener {
    private final BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
    private final JComboBox<ComboBoxItem> servicesBox = new JComboBox();
    private final RuleEditor serviceConditionEditor = new RuleEditor();
    private final JPanel topPanel = new JPanel(new GridBagLayout());
    private final JPanel editorPanel = new JPanel(new GridBagLayout());
    private final BGUTable tableDeleteByTime = new BGUTable(new RemoveRuleTableModel());
    private final BGUTable tableDeleteByMoney = new BGUTable(new RemoveRuleTableModel());
    private final BGDialogToolBar dialogToolBar = new BGDialogToolBar();
    private final JScrollPane jScrollPane = new JScrollPane(this.tableDeleteByTime);
    private final BGSplitPaneNoBorder tableAndEditorSplit = new BGSplitPaneNoBorder(0, this.jScrollPane, (Component)this.editorPanel, 300L);
    private RemoveRuleTableModel currentModel = new RemoveRuleTableModel();
    private ContractRemoveRuleService removeRuleService;

    public DeleteContractEditor() {
        this.tryCall(() -> this.jbInit());
        this.dialogToolBar.setDefaultButtons(this, BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.COPY_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.SEPARATOR, BGDialogToolBar.ButtonData.REFRESH, BGDialogToolBar.ButtonData.SEPARATOR);
        this.dialogToolBar.setOrientation(0);
        this.servicesBox.addItem(new ComboBoxItem("1", "\u043f\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u0438"));
        this.servicesBox.addItem(new ComboBoxItem("2", "\u043f\u043e \u0441\u0443\u043c\u043c\u0435"));
        this.servicesBox.setEnabled(true);
        this.editorPanel.setVisible(false);
    }

    private void jbInit() {
        this.topPanel.add((Component)this.dialogToolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.topPanel.add((Component)new JLabel("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0442\u0438\u043f\u0443:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 50, 0, 0), 15, 0));
        this.topPanel.add(this.servicesBox, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 1), 0, 0));
        this.editorPanel.add((Component)this.serviceConditionEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.bGControlPanel_02, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.setSize(500, 400);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.tableAndEditorSplit, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.servicesBox.addItemListener(this::servicesBox_itemStateChanged);
        BGSwingUtilites.handleLDMouseClicked(this.tableDeleteByTime, e -> this.editItem());
        BGSwingUtilites.handleLDMouseClicked(this.tableDeleteByMoney, e -> this.editItem());
        this.bGControlPanel_02.addActionListener(this::bGControlPanel_02_actionPerformed);
    }

    @Override
    public void setData() throws Exception {
        List<ContractRemoveRule> rules = this.getRemoveRuleService().getContractRemoveRules();
        ((RemoveRuleTableModel)this.tableDeleteByTime.getModel()).setData(rules.stream().filter(r -> r.getRemoveRuleType().equals((Object)ContractRemoveRule.RemoveRuleType.TIME)).toList());
        ((RemoveRuleTableModel)this.tableDeleteByMoney.getModel()).setData(rules.stream().filter(r -> r.getRemoveRuleType().equals((Object)ContractRemoveRule.RemoveRuleType.BALANCE)).toList());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("newItem".equals(actionCommand)) {
            this.newItem();
        } else if ("copyItem".equals(actionCommand)) {
            this.copyItem();
        } else if ("editItem".equals(actionCommand)) {
            this.editItem();
        } else if ("deleteItem".equals(actionCommand)) {
            this.deleteItem();
        }
    }

    @Override
    public void newItem() {
        int type = this.servicesBox.getSelectedIndex() + 1;
        this.serviceConditionEditor.init(type);
        this.serviceConditionEditor.refresh();
        this.editorPanel.setVisible(true);
        this.servicesBox.setEnabled(false);
        this.revalidateSplit();
    }

    @Override
    public void editItem() {
        this.selectTableModel();
        ContractRemoveRule removeRule = (ContractRemoveRule)this.currentModel.getSelectedRow();
        if (removeRule == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e!");
            return;
        }
        int type = this.servicesBox.getSelectedIndex() + 1;
        this.serviceConditionEditor.init(type);
        this.serviceConditionEditor.edit(removeRule);
        this.editorPanel.setVisible(true);
        this.servicesBox.setEnabled(false);
        this.revalidateSplit();
    }

    @Override
    public void deleteItem() {
        ContractRemoveRule selected = (ContractRemoveRule)this.currentModel.getSelectedRow();
        if (selected == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e!");
            return;
        }
        if (ClientUtils.confirmDelete(selected.getTitle())) {
            this.tryCall(() -> {
                this.getRemoveRuleService().delete(selected.getId());
                this.editorPanel.setVisible(false);
                this.setData();
            });
        }
    }

    private void servicesBox_itemStateChanged(ItemEvent e) {
        this.selectTableModel();
        this.jScrollPane.getViewport().removeAll();
        int type = this.servicesBox.getSelectedIndex() + 1;
        this.jScrollPane.getViewport().add((Component)(type == 1 ? this.tableDeleteByTime : this.tableDeleteByMoney), null);
        if (type == 1) {
            this.jScrollPane.getViewport().add((Component)this.tableDeleteByTime, null);
        } else if (type == 2) {
            this.jScrollPane.getViewport().add((Component)this.tableDeleteByMoney, null);
        }
    }

    private void selectTableModel() {
        int type = this.servicesBox.getSelectedIndex() + 1;
        if (type == 1) {
            this.currentModel = (RemoveRuleTableModel)this.tableDeleteByTime.getModel();
        } else if (type == 2) {
            this.currentModel = (RemoveRuleTableModel)this.tableDeleteByMoney.getModel();
        }
    }

    private void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.serviceConditionEditor.edit((ContractRemoveRule)this.currentModel.getSelectedRow());
        } else if ("ok".equals(actionCommand)) {
            int type = this.servicesBox.getSelectedIndex() + 1;
            this.serviceConditionEditor.okButtonClick(Integer.toString(type));
            this.trySetData();
            this.editorPanel.setVisible(false);
            this.servicesBox.setEnabled(true);
        } else if ("cancel".equals(actionCommand)) {
            this.servicesBox.setEnabled(true);
            this.editorPanel.setVisible(false);
        }
    }

    private void revalidateSplit() {
        this.tableAndEditorSplit.setDividerSize(5);
        this.tableAndEditorSplit.setDividerLocation(0.7);
        this.tableAndEditorSplit.revalidate();
    }

    private ContractRemoveRuleService getRemoveRuleService() {
        if (this.removeRuleService == null) {
            this.removeRuleService = this.getContext().getPort(ContractRemoveRuleService.class, 0);
        }
        return this.removeRuleService;
    }

    private static final class RemoveRuleTableModel
    extends BGTableModel<ContractRemoveRule> {
        public RemoveRuleTableModel() {
            super("RemoveRuleTableModel");
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 200, 300, "title", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", Column.DateTime.class, -1, 300, 200, "", true);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValueAt(ContractRemoveRule val, int column) throws Exception {
            if (column == 1) {
                Object period = "";
                period = val.getDateFrom() != null ? (String)period + TimeUtils.format(val.getDateFrom(), "dd.MM.yyyy") + "-" : (String)period + "...-";
                period = val.getDateTo() != null ? (String)period + TimeUtils.format(val.getDateTo(), "dd.MM.yyyy") : (String)period + "...";
                return period;
            }
            return super.getValueAt(val, column);
        }
    }
}

