/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.license.server.bean;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.LicenseData;
import ru.bitel.bgbilling.kernel.admin.license.common.bean.Storage;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class LicenseRemoteDao {
    private Setup setup = Setup.getSetup();

    public List<LicenseData> list() throws Exception {
        ArrayList<LicenseData> list;
        block8: {
            list = new ArrayList<LicenseData>();
            String name = this.setup.get("license.contract.title", "");
            if (Utils.notBlankString(name)) {
                try (HttpClient httpClient = HttpClient.newHttpClient();){
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.setup.get("license.server.url", "https://license.bitel.ru/license") + "?action=list")).header("name", name).header("password", this.setup.get("license.contract.password", "")).header("copyId", this.setup.get("license.product.id", "")).GET().build();
                    HttpResponse<Stream<String>> response = httpClient.send(request, HttpResponse.BodyHandlers.ofLines());
                    int statusCode = response.statusCode();
                    if (statusCode == 200) {
                        DateFormat dateFormat = TimeUtils.getDateFormat("dd.MM.yyyy HH:mm:ss");
                        response.body().forEach(a -> {
                            String[] tokens = a.split("\t");
                            list.add(new LicenseData().setId(Utils.parseInt(tokens[0])).setCreateDate(TimeUtils.parseDate(tokens[1], dateFormat)).setHash(tokens[2]).setCount(tokens.length > 3 ? Utils.parseInt(tokens[3]) : 0).setStorage(Storage.SERVER));
                        });
                        break block8;
                    }
                    Object message = response.toString();
                    message = (String)message + " -> " + response.headers().firstValue("ErrorMessage").orElse("");
                    throw new BGException((String)message);
                }
            }
        }
        return list;
    }

    public String getLicenseText(int licenseId) throws Exception {
        String name = this.setup.get("license.contract.title", "");
        if (Utils.notBlankString(name)) {
            try (HttpClient httpClient = HttpClient.newHttpClient();){
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.setup.get("license.server.url", "https://license.bitel.ru/license") + "?action=licenseText")).header("name", name).header("password", this.setup.get("license.contract.password", "")).header("copyId", this.setup.get("license.product.id", "")).header("licenseId", String.valueOf(licenseId)).GET().build();
                String string = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
                return string;
            }
        }
        return "";
    }
}

