/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPasswordLogDao;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ActionPassword
extends AbstractAction {
    public ActionPassword() {
        super("contract");
    }

    @Override
    public void execute() throws Exception {
        this.setResultParam("pageTitle", this.getPageTitle(4, this.moduleName));
        this.setResultParam("jspPage", "contract/password.jsp");
    }

    public void log() throws Exception {
        ContractPasswordLogDao contractPasswordLogDao = new ContractPasswordLogDao(this.con);
        SearchResult<ContractPasswordLogItem> searchResult = new SearchResult<ContractPasswordLogItem>(new Page(1, 15));
        searchResult.setSort(new String[]{"lastUpdate:DESC"});
        contractPasswordLogDao.searchContractPasswordLogItemByContractId(searchResult, this.contractId);
        this.setResultParam("logList", searchResult.getList());
        this.setResultParam("userMap", UserMap.getMap());
        this.requestDispatcher(this.moduleName, "password_log");
    }

    public void password() throws BGException {
        String pswd1 = this.context.getRequest().getParameter("pswd1");
        String pswd2 = this.context.getRequest().getParameter("pswd2");
        if (pswd1 != null && pswd2 != null) {
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                ContractPasswordLogDao contractPasswordLogDao = new ContractPasswordLogDao(this.con);
                if (contractDao.updatePassword(this.contractId, pswd1, pswd2, false)) {
                    contractPasswordLogDao.addContractPasswordLogItem(new ContractPasswordLogItem().setDatetime(new Date()).setContractId(this.contractId).setUserId(-1));
                    this.setResultParam("status", "ok");
                }
            }
            catch (Exception e) {
                this.setResultParam("error", e.getMessage());
            }
        }
        this.requestDispatcher(this.moduleName, "password_form");
    }
}

