/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class PreparedStatementCache {
    private final DefaultServerSetup setup;
    private Connection con;
    private final Map<String, PreparedStatement> map = new HashMap<String, PreparedStatement>(8);

    public PreparedStatementCache(DefaultServerSetup setup) {
        this.setup = setup;
    }

    public PreparedStatement get(String query) throws SQLException {
        PreparedStatement ps;
        if (this.con == null || this.con.isClosed()) {
            this.con = this.setup.getDBConnectionFromPool();
            this.map.clear();
        }
        if ((ps = this.map.get(query)) == null) {
            ps = this.con.prepareStatement(query);
            this.map.put(query, ps);
        }
        return ps;
    }

    public void recycle() {
        if (this.con != null) {
            ServerUtils.closeConnection((Connection)this.con);
            this.con = null;
        }
        this.map.clear();
    }

    public ResultSet execute(String query, int param1, int param2) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                ps.setInt(1, param1);
                ps.setInt(2, param2);
                return ps.executeQuery();
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public void update(String query, Object ... params) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                for (int j = 0; j < params.length; ++j) {
                    ps.setObject(j, params[j]);
                }
                ps.executeUpdate();
                return;
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public ResultSet execute(String query, Object ... params) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                for (int j = 0; j < params.length; ++j) {
                    ps.setObject(j + 1, params[j]);
                }
                return ps.executeQuery();
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public ResultSet execute(String query, int param1) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                ps.setInt(1, param1);
                return ps.executeQuery();
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public ResultSet execute(String query, int param1, long param2, long param3) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                ps.setInt(1, param1);
                ps.setLong(2, param2);
                ps.setLong(3, param3);
                return ps.executeQuery();
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public ResultSet execute(String query, Object param1) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                ps.setObject(1, param1);
                return ps.executeQuery();
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public ResultSet execute(String query, Object param1, Object param2) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                ps.setObject(1, param1);
                ps.setObject(2, param2);
                return ps.executeQuery();
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public ResultSet execute(String query, Object param1, Object param2, Object param3) throws SQLException {
        int i = 0;
        while (true) {
            try {
                PreparedStatement ps = this.get(query);
                ps.setObject(1, param1);
                ps.setObject(2, param2);
                ps.setObject(3, param3);
                return ps.executeQuery();
            }
            catch (SQLException e) {
                this.recycle();
                if (!(e.getSQLState() != null && e.getSQLState().startsWith("08") || i < 10)) {
                    throw e;
                }
                ++i;
                continue;
            }
            break;
        }
    }
}

