/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.map.graphics;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.WaypointPainter;
import ru.bitel.bgbilling.kernel.map.graphics.BGWaypoint;

public class BGWaypointPainter
extends WaypointPainter<BGWaypoint> {
    private final List<BGWaypoint> waypoints = new LinkedList<BGWaypoint>();

    protected void doPaint(Graphics2D g, JXMapViewer jxMapViewer, int width, int height) {
        for (BGWaypoint waypoint : this.getWaypointList()) {
            if (!waypoint.getMapMarker().isVisible()) continue;
            Point2D point = jxMapViewer.getTileFactory().geoToPixel(waypoint.getPosition(), jxMapViewer.getZoom());
            Rectangle rectangle = jxMapViewer.getViewportBounds();
            int X = (int)(point.getX() - rectangle.getX());
            int Y = (int)(point.getY() - rectangle.getY());
            JPanel component = waypoint.getViewComponent();
            component.setLocation(X - ((Component)component).getWidth() / 2, Y - ((Component)component).getHeight() / 2);
        }
    }

    public List<BGWaypoint> getWaypointList() {
        return Collections.unmodifiableList(this.waypoints);
    }

    public void setWaypoints(List<BGWaypoint> waypoints) {
        this.waypoints.clear();
        this.waypoints.addAll(waypoints);
    }
}

