/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.client.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.oss.kernel.entity.client.table.EntityAttrEntry;
import ru.bitel.oss.kernel.entity.common.bean.AbstractSpecAttr;
import ru.bitel.oss.kernel.entity.common.bean.Entity;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpec;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrListItem;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;
import ru.bitel.oss.kernel.entity.common.service.EntityService;

public class EntityAttributesTableModel
extends BGTableModel<EntityAttrEntry> {
    private Entity current;
    private ClientContext context;
    private Map<Integer, List<EntitySpecAttrListItem>> maps = new HashMap<Integer, List<EntitySpecAttrListItem>>();

    public EntityAttributesTableModel(ClientContext context) {
        super("entityAttr", EntityAttrEntry.class, true);
        this.context = context;
    }

    @Override
    protected void initColumns() {
        this.addColumnId();
        this.addColumn("\u0418\u043c\u044f", 300, 300, 300, "title", true, HorizontalAlignmentTableCellRenderer.LEFT());
        this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", null, 160, 160, -1, "value", true, true, HorizontalAlignmentTableCellRenderer.LEFT());
    }

    @Override
    public Object getValue(EntityAttrEntry val, int column) throws Exception {
        String identifier = this.getIdentifier(column);
        if ("value".equals(identifier)) {
            EntityAttrList entityAttrList;
            if (val.getSpecAttr().getType() == 4 && (entityAttrList = (EntityAttrList)val.getAttr()) != null && entityAttrList.getTitle() == null) {
                List list = this.maps.get(val.specAttr.getId());
                if (list == null) {
                    list = this.context.getPort(EntityService.class).entitySpecAttrListItemList(val.specAttr.getId());
                    this.maps.put(val.specAttr.getId(), list);
                }
                for (EntitySpecAttrListItem attrListItem : list) {
                    if (attrListItem.getId() != entityAttrList.getValue()) continue;
                    entityAttrList.setTitle(attrListItem.getTitle());
                    break;
                }
            }
            return val;
        }
        return super.getValue(val, column);
    }

    public void setData(Entity entity, EntitySpec entitySpec) {
        this.current = entity;
        ArrayList<EntityAttrEntry> list = new ArrayList<EntityAttrEntry>();
        if (entitySpec != null) {
            for (AbstractSpecAttr specAttr : entitySpec.getAttributeList()) {
                list.add(new EntityAttrEntry(entity, specAttr, this.current.getEntityAttributes() != null ? (EntityAttr)this.current.getEntityAttributes().get(specAttr.getId()) : null));
            }
        }
        super.setData(list);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (super.isCellEditable(rowIndex, columnIndex)) {
            EntityAttrEntry val = (EntityAttrEntry)this.table.getValueAt(rowIndex, columnIndex);
            switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)val.getSpecAttr().getType()).get()) {
                case TEXT: 
                case DATE: 
                case LIST: 
                case INT: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

