/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.task.server.bean.SchedulerManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public abstract class RunTask
extends BGLogger
implements Runnable,
Serializable {
    private int queueId = 0;
    protected transient Setup setup;

    public void setQueueId(int id) {
        this.queueId = id;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public abstract String getDescription();

    public void init(Setup setup) {
        this.setup = setup;
    }

    @Override
    public final void run() {
        Date startTime = new Date();
        this.executeTask();
        Date finishTime = new Date();
        this.removeMyselfFromTable();
        this.getLogger().info("RunTask finished time = " + (finishTime.getTime() - startTime.getTime()) + " ms.");
    }

    protected void removeMyselfFromTable() {
        if (this.queueId <= 0) {
            return;
        }
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            new SchedulerManager(con).deleteCurrentRunTask(this.queueId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    protected abstract void executeTask();

    public String getUniqueKeyQueue() {
        return null;
    }

    public String getUniqueKeyParallel() {
        return null;
    }
}

