/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.script;

import bitel.billing.module.common.BGComponentBorder;
import bitel.billing.module.common.BSHEditor;
import bitel.billing.module.script.BackupHistoryBGPanel;
import bitel.billing.module.script.GlobalScripts;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.script.common.bean.Script;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGControlPanelTextArea;

public class GlobalScriptEditor
extends BGPanel {
    private CardLayout cardLayout = new CardLayout();
    private BackupHistoryBGPanel bhPanel;
    private GlobalScripts scriptFunctions;
    private JTextField title_TF = new JTextField();
    private BSHEditor code_TA = new BSHEditor();
    private JCheckBox debugCheckbox = new JCheckBox("\u043e\u0442\u043b\u0430\u0434\u043a\u0430");
    private BGControlPanelTextArea logPanel = new BGControlPanelTextArea("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f");
    private JButton saveButton = new JButton();

    public GlobalScriptEditor(GlobalScripts scriptFunctions) {
        this.setName("editor");
        this.scriptFunctions = scriptFunctions;
        this.tryCall(() -> this.jbInit());
        this.code_TA.getTextPane().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 83) {
                    GlobalScriptEditor.this.save();
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.title_TF.setMinimumSize(new Dimension(150, 24));
        this.title_TF.setPreferredSize(new Dimension(200, 24));
        this.logPanel.setMinimumSize(new Dimension(100, 100));
        this.logPanel.setPreferredSize(new Dimension(100, 100));
        this.logPanel.setVisible(false);
        JButton closeLogButton = new JButton(ClientUtils.getIcon("close_tab.gif"));
        closeLogButton.setMinimumSize(new Dimension(16, 16));
        closeLogButton.setPreferredSize(new Dimension(16, 16));
        closeLogButton.addActionListener(e -> this.logPanel.setVisible(false));
        this.logPanel.setBorder(new BGComponentBorder(closeLogButton, this.logPanel, BorderFactory.createEtchedBorder(), 2, 7));
        JButton closeButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        closeButton.setToolTipText("");
        closeButton.addActionListener(e -> this.cancelPressed());
        this.saveButton.setText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c (READ-ONLY)");
        this.saveButton.addActionListener(e -> this.save());
        this.buttonChange(false);
        JButton executeButton = new JButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442");
        executeButton.addActionListener(e -> this.executeScript());
        JButton backupButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e");
        backupButton.addActionListener(e -> ClientUtils.showMessageDialog("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434"));
        JButton historyButton = new JButton("\u0418\u0441\u0442\u043e\u0440\u0438\u044f");
        historyButton.addActionListener(e -> {
            Integer scriptId = this.id;
            if (scriptId > 0) {
                this.bhPanel.currentId = scriptId;
                this.bhPanel.trySetData();
                this.cardLayout.show(this, "history");
            }
        });
        JPanel paramsPanel = new JPanel(new GridBagLayout());
        paramsPanel.setBorder(new BGTitleBorder(" \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b "));
        paramsPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        paramsPanel.add((Component)this.title_TF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        paramsPanel.add((Component)executeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        paramsPanel.add((Component)this.debugCheckbox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        JPanel codePanel = new JPanel(new GridBagLayout());
        codePanel.setBorder(new BGTitleBorder(" \u041a\u043e\u0434 \u0441\u043a\u0440\u0438\u043f\u0442\u0430 "));
        codePanel.add((Component)this.code_TA, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)backupButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)historyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)this.saveButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        controlPanel.add((Component)closeButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)paramsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)codePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)this.logPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainPanel.add((Component)controlPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        DocumentListener dlistener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                GlobalScriptEditor.this.buttonChange(true);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GlobalScriptEditor.this.buttonChange(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GlobalScriptEditor.this.buttonChange(true);
            }
        };
        this.code_TA.getTextPane().getDocument().addDocumentListener(dlistener);
        this.title_TF.getDocument().addDocumentListener(dlistener);
        this.setLayout(this.cardLayout);
        this.add((Component)mainPanel, "main");
        this.bhPanel = new BackupHistoryBGPanel(0, this.cardLayout, this);
        this.add((Component)this.bhPanel, "history");
        this.cardLayout.show(this, "main");
    }

    @Override
    public void setData() {
        if (this.id == 0) {
            this.title_TF.setText("");
            String defaultCode = "import bitel.billing.server.util.*;\n\npublic void main( setup, con, conSlave )\n{\n\tprint( \"Hello, world!\" );\n}";
            this.code_TA.setText(defaultCode);
            ClientUtils.showMessageDialog("\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
        } else {
            Script script = this.getLastScript();
            if (script != null) {
                this.title_TF.setText(script.getTitle());
                this.code_TA.setText(script.getScript());
            }
        }
        this.buttonChange(false);
    }

    private void executeScript() {
        this.logPanel.setVisible(false);
        Request req = new Request().setModule(this.module).setAction("ExecuteScript").setAttribute("id", this.id).setAttribute("debug", this.debugCheckbox.isSelected());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            if (this.debugCheckbox.isSelected()) {
                this.tryCall(() -> {
                    Element dataNode = XMLUtils.selectElement(doc, "/data");
                    if (dataNode != null && dataNode instanceof Element) {
                        String tlog = dataNode.getAttribute("log");
                        this.logPanel.setText(tlog);
                        this.logPanel.setVisible(true);
                    }
                });
            } else {
                ClientUtils.showErrorMessageDialog("\u0421\u043a\u0440\u0438\u043f\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f. \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0441\u043a\u0440\u0438\u043f\u0442\u0430 \u0441\u043c. \u0432 \u043b\u043e\u0433\u0430\u0445 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.");
            }
        }
    }

    private void save() {
        ClientUtils.showMessageDialog("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435\u043b\u044c\u0437\u044f, \u043d\u0443\u0436\u043d\u043e \u0432\u0441\u0451 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0430\u0442\u044c \u043d\u0430 \u0434\u0438\u043d\u043a\u043e\u0434");
    }

    private void cancelPressed() {
        if (this.saveButton.isEnabled() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", "\u0412\u044b\u0445\u043e\u0434", 0) == 0) {
            this.save();
        }
        this.scriptFunctions.hideEditor();
    }

    private Script getLastScript() {
        Request req;
        Document doc;
        if (this.id != 0 && ClientUtils.checkStatus(doc = this.getDocument(req = new Request().setModule(this.module).setAction("GetGlobalScript").setAttribute("id", this.id)))) {
            try {
                Element script = XMLUtils.selectElement(doc, "/data/script");
                Script sr = new Script();
                sr.setId(this.id);
                sr.setTitle(script.getAttribute("title"));
                sr.setScript(script.getAttribute("code"));
                sr.setUserId(Utils.parseInt(script.getAttribute("userId")));
                sr.setTimeRevision(TimeUtils.convertStringToDate(script.getAttribute("timeRevision"), "yyyy-MM-dd HH:mm:ss"));
                return sr;
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        return null;
    }

    private void buttonChange(boolean enable) {
        this.saveButton.setEnabled(false);
    }

    @Override
    public void deleteItem() {
        if (this.bhPanel.isShowing()) {
            this.bhPanel.deleteItem();
            return;
        }
        super.deleteItem();
    }
}

