/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import jakarta.xml.ws.Holder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGClientHistoryResultPopup;
import ru.bitel.bgbilling.client.common.BGClientOpenedResultPopup;
import ru.bitel.bgbilling.client.common.BGClientSearchResultPopup;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.search.client.SearchPopup;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.common.model.Page;

public class BGClientSearchPanel
extends JPanel
implements SearchPopup.CustomSearch {
    private JTextField searchTextField;
    private BGClientSearchResultPopup searchResultPopup;
    private BGClientHistoryResultPopup historyResultPopup;
    private BGClientOpenedResultPopup openedResultPopup;
    private SearchPopup customSearchPopup;
    private ClientContext clientContext = null;
    SearchButton historyButton = new SearchButton("fugue/clock");
    SearchButton openedButton = new SearchButton("opened");

    public BGClientSearchPanel() {
        super(new GridBagLayout());
        this.customSearchPopup = new SearchPopup(this.getClientContext(), this, true);
        this.historyButton.setToolTipText("\u0438\u0441\u0442\u043e\u0440\u0438\u044f");
        this.historyButton.addActionListener(e -> {
            if (this.getSearchResultPopup().isShowing()) {
                this.getSearchResultPopup().setVisible(false);
            }
            if (!this.getHistoryResultPopup().isShowing()) {
                this.historyResultPopup.show(this, this.getWidth() / 2 - this.historyResultPopup.getPreferredSize().width / 2, this.getHeight());
                this.historyResultPopup.applyFilter(null);
            }
        });
        this.openedButton.setToolTipText("\u043e\u0442\u043a\u0440\u044b\u0442\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.openedButton.addActionListener(e -> {
            if (this.getSearchResultPopup().isShowing()) {
                this.getSearchResultPopup().setVisible(false);
            }
            if (!this.getOpenedResultPopup().isShowing()) {
                this.openedResultPopup.show(this, this.getWidth() / 2 - this.openedResultPopup.getPreferredSize().width / 2, this.getHeight());
                this.openedResultPopup.doLoad();
            }
        });
        this.add((Component)new JLabel("\u041f\u043e\u0438\u0441\u043a: "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getSearchTextField(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 3), 0, 0));
        this.add((Component)this.historyButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.openedButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JTextField getSearchTextField() {
        if (this.searchTextField == null) {
            this.searchTextField = new JTextField(20);
            this.searchTextField.setMinimumSize(new Dimension(300, 10));
            this.searchTextField.setHorizontalAlignment(0);
            this.searchTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (BGClientSearchPanel.this.getSearchResultPopup().isShowing() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                        BGClientSearchPanel.this.getSearchResultPopup().dispatchEvent(keyEvent);
                    } else if (keyEvent.getKeyCode() == 10 && BGClientSearchPanel.this.customSearchPopup.isVisible() && BGClientSearchPanel.this.customSearchPopup.getSelectionModel().getSelectedIndex() >= 0) {
                        BGClientSearchPanel.this.customSearchPopup.dispatchEvent(keyEvent);
                    } else if (keyEvent.getKeyCode() == 10) {
                        SwingUtilities.invokeLater(() -> {
                            if (!BGClientSearchPanel.this.getSearchResultPopup().isShowing()) {
                                BGClientSearchPanel.this.showSearchResultPopup();
                            } else {
                                BGClientSearchPanel.this.searchResultPopup.openSelectedPanel();
                            }
                            BGClientSearchPanel.this.getSearchResultPopup().doSearch(BGClientSearchPanel.this.searchTextField.getText().trim());
                        });
                    } else {
                        BGClientSearchPanel.this.customSearchPopup.dispatchEvent(keyEvent);
                    }
                }
            });
            this.searchTextField.getDocument().addDocumentListener(SearchPopup.getDocumentListenerBySearchField(this, this.searchTextField, this.customSearchPopup));
        }
        return this.searchTextField;
    }

    @Override
    public void customSearchImpl(SearchImplementation searchImplementation) {
        try {
            this.searchResultPopup = null;
            this.getSearchResultPopup().setSearchResultToListPanel(this.customSearchPopup.getContractSearchService().search(searchImplementation, this.searchTextField.getText(), -1, true, true, true, (Holder<Page>)new Holder((Object)new Page())));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        this.showSearchResultPopup();
    }

    private void showSearchResultPopup() {
        this.getSearchResultPopup().show(this, this.getWidth() / 2 - this.getSearchResultPopup().getPreferredSize().width / 2, this.getHeight());
        this.searchTextField.requestFocus();
    }

    private BGClientSearchResultPopup getSearchResultPopup() {
        if (this.searchResultPopup == null) {
            this.searchResultPopup = new BGClientSearchResultPopup(this.getClientContext());
        }
        return this.searchResultPopup;
    }

    private BGClientHistoryResultPopup getHistoryResultPopup() {
        if (this.historyResultPopup == null) {
            this.historyResultPopup = new BGClientHistoryResultPopup(this.getClientContext());
        }
        return this.historyResultPopup;
    }

    private BGClientOpenedResultPopup getOpenedResultPopup() {
        if (this.openedResultPopup == null) {
            this.openedResultPopup = new BGClientOpenedResultPopup(this.getClientContext());
        }
        return this.openedResultPopup;
    }

    private ClientContext getClientContext() {
        if (this.clientContext == null) {
            this.clientContext = new ClientContext("kernel", 0, -1, null);
        }
        return this.clientContext;
    }

    class SearchButton
    extends JButton {
        public SearchButton(String icon) {
            super(ClientUtils.getIcon(icon));
            this.setBorderPainted(false);
            this.setFocusPainted(false);
            Insets insets = this.getMargin();
            insets.left = 1;
            insets.right = 1;
            this.setMargin(insets);
        }
    }
}

