/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.base.client.dialog;

import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGDialog;

public class ContractTitleEditorDialog
extends BGDialog {
    private int contractId = -1;
    private JTextField contractTitle = new JTextField();
    private JTextField contractComment = new JTextField();
    private JComboBox<ComboBoxItem> contractCommentPattern = new JComboBox();
    private ContractService contractService = null;

    public ContractTitleEditorDialog(int contractId) {
        this.contractId = contractId;
        this.jbInit();
        this.setData();
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() {
        JPanel contractNumberPanel = new JPanel(new GridBagLayout());
        JPanel contractCommentPanel = new JPanel(new GridBagLayout());
        JPanel commentTemplatePanel = new JPanel(new GridBagLayout());
        BGButtonPanelRestoreOkCancelHelp controlPanel = new BGButtonPanelRestoreOkCancelHelp();
        contractNumberPanel.setBorder(new BGTitleBorder(" \u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 "));
        contractCommentPanel.setBorder(new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 ( \u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 ) "));
        commentTemplatePanel.setBorder(new BGTitleBorder(" \u0428\u0430\u0431\u043b\u043e\u043d \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f "));
        this.contractTitle.setHorizontalAlignment(0);
        this.contractTitle.setMinimumSize(new Dimension(130, 24));
        this.contractTitle.setPreferredSize(new Dimension(130, 24));
        this.contractTitle.setMaximumSize(new Dimension(130, 24));
        this.contractComment.setMinimumSize(new Dimension(630, 24));
        this.contractComment.setPreferredSize(new Dimension(630, 24));
        contractNumberPanel.add((Component)this.contractTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        contractCommentPanel.add((Component)this.contractComment, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        commentTemplatePanel.add(this.contractCommentPattern, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.setModal(true);
        this.setTitle(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043d\u043e\u043c\u0435\u0440\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 ");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)contractNumberPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 0, 0), 0, 0));
        this.getContentPane().add((Component)commentTemplatePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.getContentPane().add((Component)contractCommentPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.getContentPane().add((Component)controlPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        controlPanel.addActionListener(this::controlPanel_actionPerformed);
        this.contractCommentPattern.addItemListener(this::contractCommentPattern_itemStateChanged);
    }

    @Override
    public void setData() {
        JSONObject json;
        try {
            json = this.getContractService().contractTitleAndCommentGet(this.contractId);
            this.contractTitle.setText(json.optString("title"));
            this.contractComment.setText(json.optString("comment"));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        try {
            json = this.getContractService().contractCommentPatternList(this.contractId);
            int contarctPatternId = json.optInt("contractPatternId");
            JSONArray patterns = json.optJSONArray("patterns");
            this.contractCommentPattern.removeAllItems();
            this.contractCommentPattern.setModel(ClientUtils.buildComboBox(patterns, contarctPatternId));
            this.contractComment.setEditable(contarctPatternId == 0);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private void contractCommentPattern_itemStateChanged(ItemEvent e) {
        ComboBoxItem item;
        if (e.getStateChange() == 1 && (item = (ComboBoxItem)e.getItem()) != null) {
            String id = (String)item.getObject();
            boolean isManual = "0".equals(id);
            this.contractComment.setEditable(isManual);
            if (!isManual) {
                try {
                    this.contractComment.setText(this.getContractService().contractCommentPatternValue(this.contractId, Utils.parseInt(id)));
                }
                catch (Exception e1) {
                    ClientUtils.showErrorMessageDialog(e1);
                }
            }
        }
    }

    private void controlPanel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("ok".equals(actionCommand)) {
            if (this.contractTitle.getText().trim().length() == 0) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u0432\u0435\u0441\u0442\u0438 \u043d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                return;
            }
            String id = (String)((ComboBoxItem)this.contractCommentPattern.getSelectedItem()).getObject();
            try {
                this.getContractService().contractTitleAndCommentUpdate(this.contractId, this.contractTitle.getText(), this.contractComment.getText(), Utils.parseInt(id));
                this.dispose();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        } else if ("cancel".equals(actionCommand)) {
            this.dispose();
        }
    }

    private ContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = this.getContext().getPort(ContractService.class, 0);
        }
        return this.contractService;
    }
}

