/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

public class ProductActivatinModeSpecPanel
extends BGUPanel {
    private List<BGModule> bgModules = null;
    private ProductSpecActivationModeTableModel model = new ProductSpecActivationModeTableModel();

    public ProductActivatinModeSpecPanel() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable(this.model);
        table.setSelectionMode(0);
        BGSwingUtilites.handleEdit(table, this);
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, table, "enabled", "oldValue"));
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            this.bgModules = ((ClientContext)this.getContext()).getWebService(ModuleService.class, 0).moduleByNameList("tv");
            this.model.setData(((ClientContext)this.getContext()).getWebService(ProductService.class, 0).productSpecActivationModeList());
        });
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                new EditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c", new ProductSpecActivationMode().setDateFrom(new Date()), true).open();
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ProductSpecActivationMode mode = (ProductSpecActivationMode)ProductActivatinModeSpecPanel.this.model.getSelectedRow();
                if (mode == null) {
                    return;
                }
                new EditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c", mode, false).open();
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                ProductSpecActivationMode mode = (ProductSpecActivationMode)ProductActivatinModeSpecPanel.this.model.getSelectedRow();
                if (mode == null) {
                    return;
                }
                if (ClientUtils.confirmDelete(mode.getGuiTitle())) {
                    ((ClientContext)ProductActivatinModeSpecPanel.this.getContext()).getWebService(ProductService.class, 0).productSpecActivationModeDelete(mode.getId());
                    ProductActivatinModeSpecPanel.this.model.getRows().remove(mode);
                    ProductActivatinModeSpecPanel.this.model.fireTableDataChanged();
                }
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
    }

    private class ProductSpecActivationModeTableModel
    extends BGTableModel<ProductSpecActivationMode> {
        public ProductSpecActivationModeTableModel() {
            super(ProductSpecActivationModeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 180, 180, 180, "moduleId", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 150, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 300, 300, 300, "deak", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 150, 150, 150, "reak", false, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(ProductSpecActivationMode productSpecActivationMode, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("moduleId".equals(identifier)) {
                return ProductActivatinModeSpecPanel.this.bgModules.stream().filter(a -> productSpecActivationMode.getModuleId() == a.getId()).map(a -> a.getGuiTitle()).findFirst().orElse("\u043b\u044e\u0431\u043e\u0439");
            }
            if ("deak".equals(identifier)) {
                if (productSpecActivationMode.getPeriodAmount() != 0) {
                    return "";
                }
                switch (productSpecActivationMode.getDeactivationMode()) {
                    case 10: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430";
                    }
                    case 0: {
                        return "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e";
                    }
                    case 2: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430";
                    }
                    case 3: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f";
                    }
                    case 4: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438";
                    }
                    case 5: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430";
                    }
                }
                return null;
            }
            if ("reak".equals(identifier)) {
                if (productSpecActivationMode.getPeriodAmount() != 0) {
                    return "";
                }
                switch (productSpecActivationMode.getReactivationMode()) {
                    case 0: {
                        return "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430";
                    }
                    case 1: {
                        return "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430";
                    }
                }
                return null;
            }
            return super.getValue(productSpecActivationMode, column);
        }
    }

    private class EditorDialog
    extends BGEditorDialog<ProductSpecActivationMode> {
        private boolean newMode;
        private ButtonGroup buttonGroup;
        private BGTextField title;
        private BGTextField calculatePeriod;
        private BGIntTextField periodColTF;
        private JRadioButton unlimitedDuration;
        private JRadioButton limitedDuration;
        private BGUComboBox<IdTitle> module;
        private BGUComboBox<IdTitle> periodModeField;
        private BGUComboBox<IdTitle> periodModeBegin;
        private BGUComboBox<IdTitle> periodModeEnd;
        private BGUComboBox<IdTitle> deactivationModeCB;
        private BGUComboBox<IdTitle> reactivationModeCB;
        private List<IdTitle> moduleData;
        private IdTitle[] deactivationModes;
        private IdTitle[] reactivationModes;
        private IdTitle[] periodModeFields;
        private IdTitle[] periodModeBegins;
        private IdTitle[] periodModeEnds;

        public EditorDialog(String title, ProductSpecActivationMode data, boolean newMode) {
            super(title, data);
            this.newMode = false;
            this.buttonGroup = new ButtonGroup();
            this.title = new BGTextField(40);
            this.calculatePeriod = new BGTextField(40);
            this.periodColTF = new BGIntTextField(5);
            this.unlimitedDuration = new JRadioButton("\u0431\u0435\u0441\u0441\u0440\u043e\u0447\u043d\u043e");
            this.limitedDuration = new JRadioButton("\u043d\u0430");
            this.module = new BGUComboBox();
            this.periodModeField = new BGUComboBox();
            this.periodModeBegin = new BGUComboBox();
            this.periodModeEnd = new BGUComboBox();
            this.deactivationModeCB = new BGUComboBox();
            this.reactivationModeCB = new BGUComboBox();
            this.moduleData = new ArrayList<IdTitle>();
            this.deactivationModes = new IdTitle[]{new IdTitle(10, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430"), new IdTitle(0, "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e"), new IdTitle(2, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430"), new IdTitle(3, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f"), new IdTitle(4, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438"), new IdTitle(5, "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430")};
            this.reactivationModes = new IdTitle[]{new IdTitle(0, "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430"), new IdTitle(1, "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430")};
            this.periodModeFields = new IdTitle[]{new IdTitle(1, "\u043c\u0438\u043d\u0443\u0442"), new IdTitle(2, "\u0447\u0430\u0441\u043e\u0432"), new IdTitle(3, "\u0434\u043d\u0435\u0439"), new IdTitle(4, "\u043d\u0435\u0434\u0435\u043b\u044c"), new IdTitle(5, "\u043c\u0435\u0441\u044f\u0446\u0435\u0432")};
            this.periodModeBegins = new IdTitle[]{new IdTitle(1, "\u0441 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430"), new IdTitle(3, "\u0441\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e(\u0435\u0439)"), new IdTitle(4, "\u0441\u043e \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u0447\u0430\u0441\u0430")};
            this.periodModeEnds = new IdTitle[]{new IdTitle(1, "\u0440\u043e\u0432\u043d\u043e"), new IdTitle(2, "\u043e\u043a\u0440\u0443\u0433\u043b\u0435\u043d\u043d\u043e")};
            this.newMode = newMode;
        }

        @Override
        public void doDialogPanel() {
            this.buttonGroup.add(this.limitedDuration);
            this.buttonGroup.add(this.unlimitedDuration);
            this.calculatePeriod.setHorizontalAlignment(0);
            this.calculatePeriod.setEnabled(false);
            this.panel.add((Component)new JLabel("\u041c\u043e\u0434\u0443\u043b\u044c"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add(this.module, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getDurationBeginPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getDurationPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getDurationEndPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.calculatePeriod, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add(this.deactivationModeCB, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add(this.reactivationModeCB, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 10, 0), 0, 0));
            this.deactivationModeCB.setData(Arrays.asList(this.deactivationModes));
            this.reactivationModeCB.setData(Arrays.asList(this.reactivationModes));
            this.periodModeField.setData(Arrays.asList(this.periodModeFields));
            this.periodModeBegin.setData(Arrays.asList(this.periodModeBegins));
            this.periodModeEnd.setData(Arrays.asList(this.periodModeEnds));
            this.periodModeField.addItemListener(e -> this.setCalculatePeriod());
            this.periodModeBegin.addItemListener(e -> this.setCalculatePeriod());
            this.periodModeEnd.addItemListener(e -> this.setCalculatePeriod());
            this.limitedDuration.addActionListener(e -> this.setCalculatePeriod());
            this.unlimitedDuration.addActionListener(e -> this.setCalculatePeriod());
            this.periodColTF.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    EditorDialog.this.setCalculatePeriod();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    EditorDialog.this.setCalculatePeriod();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    EditorDialog.this.setCalculatePeriod();
                }
            });
            try {
                this.moduleData.clear();
                this.moduleData.add(new IdTitle(0, "\u043b\u044e\u0431\u043e\u0439"));
                this.moduleData.addAll(((ClientContext)ProductActivatinModeSpecPanel.this.getContext()).getWebService(ModuleService.class, 0).moduleByNameList("tv").stream().map(IdTitle::toIdTitle).toList());
                this.module.setData(this.moduleData);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            this.module.setSelectedItem(this.moduleData.stream().filter(a -> a.getId() == ((ProductSpecActivationMode)this.data).getModuleId()).findFirst().orElse(this.moduleData.get(0)));
            int[] modeValue = ProductSpecActivationMode.mode((int)((ProductSpecActivationMode)this.data).getPeriodMode());
            this.periodModeField.setSelectedItem(modeValue[0]);
            this.periodModeBegin.setSelectedItem(modeValue[1]);
            this.periodModeEnd.setSelectedItem(modeValue[2]);
            (((ProductSpecActivationMode)this.data).getPeriodAmount() > 0 ? this.limitedDuration : this.unlimitedDuration).setSelected(true);
            this.title.setText(((ProductSpecActivationMode)this.data).getTitle());
            this.deactivationModeCB.setSelectedItem(((ProductSpecActivationMode)this.data).getDeactivationMode());
            this.reactivationModeCB.setSelectedItem(((ProductSpecActivationMode)this.data).getReactivationMode());
            this.periodColTF.setText(String.valueOf(((ProductSpecActivationMode)this.data).getPeriodAmount()));
            this.setCalculatePeriod();
        }

        private JPanel getDurationBeginPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.periodModeBegin, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getDurationPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.limitedDuration, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.periodColTF, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add(this.periodModeField, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            panel.add(this.periodModeEnd, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 3, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getDurationEndPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.unlimitedDuration, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            int modeField = ((IdTitle)this.periodModeField.getSelectedItem()).getId();
            int modeBegin = ((IdTitle)this.periodModeBegin.getSelectedItem()).getId();
            int modeEnd = ((IdTitle)this.periodModeEnd.getSelectedItem()).getId();
            ((ProductSpecActivationMode)this.data).setModuleId(((IdTitle)this.module.getSelectedItem()).getId());
            ((ProductSpecActivationMode)this.data).setTitle(this.title.getText());
            ((ProductSpecActivationMode)this.data).setDeactivationMode(((IdTitle)this.deactivationModeCB.getSelectedItem()).getId());
            ((ProductSpecActivationMode)this.data).setReactivationMode(((IdTitle)this.reactivationModeCB.getSelectedItem()).getId());
            ((ProductSpecActivationMode)this.data).setPeriodMode(modeField + modeBegin * 10 + modeEnd * 100);
            ((ProductSpecActivationMode)this.data).setPeriodAmount(Utils.parseInt(this.periodColTF.getText()));
            ((ProductSpecActivationMode)this.data).setId(((ClientContext)ProductActivatinModeSpecPanel.this.getContext()).getWebService(ProductService.class, 0).productSpecActivationModeUpdate((ProductSpecActivationMode)this.data));
            if (this.newMode) {
                ProductActivatinModeSpecPanel.this.model.getRows().add((ProductSpecActivationMode)this.data);
            }
            ProductActivatinModeSpecPanel.this.model.fireTableDataChanged();
            return true;
        }

        private void setCalculatePeriod() {
            LocalDateTime from = LocalDateTime.now();
            LocalDateTime to = null;
            switch (((IdTitle)this.periodModeBegin.getSelectedItem()).getId()) {
                case 3: {
                    switch (((IdTitle)this.periodModeField.getSelectedItem()).getId()) {
                        case 1: {
                            from = from.truncatedTo(ChronoUnit.MINUTES).plusMinutes(1L);
                            break;
                        }
                        case 2: {
                            from = from.truncatedTo(ChronoUnit.HOURS).plusHours(1L);
                            break;
                        }
                        case 3: {
                            from = from.truncatedTo(ChronoUnit.DAYS).plusDays(1L);
                            break;
                        }
                        case 4: {
                            from = from.truncatedTo(ChronoUnit.DAYS).minusDays(from.getDayOfWeek().getLong(ChronoField.DAY_OF_WEEK)).plusWeeks(1L);
                            break;
                        }
                        case 5: {
                            from = from.truncatedTo(ChronoUnit.DAYS).minusDays(from.getDayOfMonth() - 1).plusMonths(1L);
                        }
                    }
                    break;
                }
                case 4: {
                    from = from.truncatedTo(ChronoUnit.HOURS).plusHours(1L);
                    break;
                }
            }
            if (this.limitedDuration.isSelected()) {
                to = from;
                int periodAmount = Utils.parseInt(this.periodColTF.getText());
                switch (((IdTitle)this.periodModeField.getSelectedItem()).getId()) {
                    case 1: {
                        to = to.plusMinutes(periodAmount);
                        break;
                    }
                    case 2: {
                        to = to.plusHours(periodAmount);
                        break;
                    }
                    case 3: {
                        to = to.plusDays(periodAmount);
                        break;
                    }
                    case 4: {
                        to = to.plusWeeks(periodAmount);
                        break;
                    }
                    case 5: {
                        to = to.plusMonths(periodAmount);
                    }
                }
                if (((IdTitle)this.periodModeEnd.getSelectedItem()).getId() == 2) {
                    to = to.truncatedTo(ChronoUnit.SECONDS);
                    switch (((IdTitle)this.periodModeField.getSelectedItem()).getId()) {
                        case 1: {
                            to = to.truncatedTo(ChronoUnit.MINUTES);
                            break;
                        }
                        case 2: {
                            to = to.truncatedTo(ChronoUnit.HOURS);
                            break;
                        }
                        case 3: {
                            to = to.truncatedTo(ChronoUnit.MINUTES).truncatedTo(ChronoUnit.HOURS).minusHours(to.getHour());
                            break;
                        }
                        case 4: {
                            to = to.truncatedTo(ChronoUnit.MINUTES).truncatedTo(ChronoUnit.HOURS).minusHours(to.getHour()).minusDays(to.getDayOfWeek().getLong(ChronoField.DAY_OF_WEEK));
                            break;
                        }
                        case 5: {
                            to = to.truncatedTo(ChronoUnit.MINUTES).truncatedTo(ChronoUnit.HOURS).minusHours(to.getHour()).minusDays(to.getDayOfMonth());
                        }
                    }
                }
                to = to.minusSeconds(1L);
            }
            StringBuffer buf = new StringBuffer().append(from == null ? "?" : TimeUtils.format(from, "dd.MM.yyyy HH:mm:ss")).append(" - ").append(to == null ? "\u0431\u0435\u0441\u0440\u043e\u0447\u043d\u043e" : TimeUtils.format(to, "dd.MM.yyyy HH:mm:ss"));
            this.calculatePeriod.setText(buf.toString());
        }
    }
}

