/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class TimeTypeFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private static final Icon icon = ClientUtils.getIcon((String)"time");
    private Directory timeTypeDir;
    private JLabel view;
    private JPanel editorPanel;
    private String timeTypeTitle;
    private int timeTypeId;
    private BGComboBox<IdTitle> timeTypeCombo;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> childsArray) {
        super.init(id, mtree, type, tree, config, parent, childsArray);
        this.timeTypeDir = this.getDirManager().getDirectory("time_type");
    }

    @Override
    protected JPanel getEditorPanel() throws Exception {
        if (this.editorPanel == null) {
            this.editorPanel = new JPanel();
            this.timeTypeCombo = new BGComboBox();
            this.buildDirectoryCombo(this.timeTypeDir, (JComboBox<IdTitle>)this.timeTypeCombo);
            this.timeTypeCombo.insertItemAt((Object)IdTitle.NO_SELECT, 0);
            this.editorPanel.add(new JLabel("\u0422\u0438\u043f \u0432\u0440\u0435\u043c\u0435\u043d\u0438: "));
            this.editorPanel.add((Component)this.timeTypeCombo);
        }
        return this.editorPanel;
    }

    @Override
    public Component getView() throws Exception {
        this.extractData();
        if (this.view == null) {
            this.view = new JLabel(icon, 2);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\u0422\u0438\u043f \u0432\u0440\u0435\u043c\u0435\u043d\u0438: ");
        sb.append(this.timeTypeTitle);
        this.view.setText(sb.toString());
        return this.view;
    }

    @Override
    protected void loadData() throws Exception {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox<? extends IdTitle>)this.timeTypeCombo, this.timeTypeId);
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        String timeRange = String.valueOf(this.getIdFromDirectoryCombo((JComboBox<? extends IdTitle>)this.timeTypeCombo));
        data.put("time_type", timeRange);
        this.setDataInHash(data);
    }

    private void extractData() throws Exception {
        Map<String, String> data = this.getDataInHash();
        this.timeTypeId = Utils.parseInt((String)data.get("time_type"));
        this.timeTypeTitle = this.timeTypeDir != null ? (this.timeTypeId == 0 ? "" : Utils.maskNull((String)this.timeTypeDir.getValue(this.timeTypeId))) : "???";
    }

    @Override
    public void serializeToXML(Element el) throws Exception {
        super.serializeToXML(el);
        this.extractData();
        if (Utils.notEmptyString((String)this.timeTypeTitle)) {
            el.setAttribute("title", this.timeTypeTitle);
        }
        el.setAttribute("id", String.valueOf(this.timeTypeId));
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) throws Exception {
        HashMap<String, String> data = new HashMap<String, String>(3);
        String title = el.getAttribute("title");
        if (title.length() > 0) {
            int id = this.timeTypeDir.getCode(title);
            if (id < 0) {
                id = this.timeTypeDir.addValue(title);
            }
            data.put("time_type", String.valueOf(id));
        }
        this.setDataInHash(data);
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

