/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.client.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.loader.client.UtilPanel;
import ru.bitel.bgbilling.kernel.tariff.common.service.TariffService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class LinkContractToTariff
extends UtilPanel {
    public static final String TITLE = "\u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u043c";
    public static final String CARD_NAME = "linkContractToTariff";
    private TariffMapTableModel tariffMapTableModel = new TariffMapTableModel();
    private JCheckBox cleanContractTariff = new JCheckBox("\u0443\u0434\u0430\u043b\u044f\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043f\u0435\u0440\u0435\u0434 \u0438\u043c\u043f\u043e\u0440\u0442\u043e\u043c");
    private AtomicReference<String> data = new AtomicReference();
    private List<IdTitle> tariffPlanTitles = new ArrayList<IdTitle>();

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)new UtilPanel.PanelTitleLabel(TITLE), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 15, 2, 5), 0, 0));
        this.add((Component)this.getColumnPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(15, 5, 2, 5), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getColumnPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2, 10, 0));
        panel.add(this.getSourcePanel());
        panel.add(this.getColumn2Panel());
        return panel;
    }

    private JPanel getSourcePanel() {
        JTextArea info = new JTextArea(4, 30);
        info.setText("\u041d\u041e\u041c\u0415\u0420_\u0414\u041e\u0413\u041e\u0412\u041e\u0420\u0410<TAB>\u041d\u0410\u0417\u0412\u0410\u041d\u0418\u0415_\u0422\u0410\u0420\u0418\u0424\u0410<TAB>\u041d\u0410\u0427\u0410\u041b\u041e_\u041f\u0415\u0420\u0418\u041e\u0414\u0410_\u0422\u0410\u0420\u0418\u0424\u0410_YYYY-MM-DD\n\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440\nB0885-21  \u0422\u0430\u0440\u0438\u04441  2022-01-01");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getInfoPanel(info), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 5, 5, 5), 0, 0));
        panel.add((Component)this.getDataPanel(this.data), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getFilePanel(this.data), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getColumn2Panel() {
        BGButton scan = new BGButton("\u0421\u043a\u0430\u043d\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
        scan.addActionListener(e -> this.tariffScan());
        BGUTable table = new BGUTable(this.tariffMapTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isLeftMouseButton(event) && event.getClickCount() == 2) {
                    new TariffMapEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0430\u043f\u0438\u043d\u0433\u0430", (TariffMapData)LinkContractToTariff.this.tariffMapTableModel.getSelectedRow()).open();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u0430\u043f\u0438\u043d\u0433 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 (\u0442\u0430\u0440\u0438\u0444 \u0432 \u0438\u043c\u043f\u043e\u0440\u0442\u0435 -> \u0442\u0430\u0440\u0438\u0444 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0435)"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)scan, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 5), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 200, 300), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 5, 5), 0, 0));
        panel.add((Component)this.cleanContractTariff, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getImportResultPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 5, 0), 0, 0));
        return panel;
    }

    private void tariffScan() {
        ArrayList tariffMapDatas = new ArrayList();
        if (this.data.get() != null) {
            String[] lines = this.data.get().split("\n");
            HashSet<String> tariffSet = new HashSet<String>();
            for (String line : lines) {
                String[] a2 = line.split("\t");
                if (a2.length != 3) continue;
                tariffSet.add(a2[1]);
            }
            try {
                this.tariffPlanTitles = ((ClientContext)this.getContext()).getWebService(TariffService.class, 0).tariffPlanTitles();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            tariffSet.forEach(a -> {
                int to = this.tariffPlanTitles.stream().filter(t -> t.getTitle().equals(a)).findFirst().map(t -> t.getId()).orElse(0);
                tariffMapDatas.add(new TariffMapData(this).setFrom((String)a).setTo(to));
            });
        }
        this.tariffMapTableModel.setData(tariffMapDatas);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {});
    }

    @Override
    protected void doUtil() {
        JSONObject config = new JSONObject();
        config.put("deleteContractTariff", this.cleanContractTariff.isSelected());
        JSONArray tariffMap = new JSONArray();
        for (TariffMapData tariffMapData : this.tariffMapTableModel.getRows()) {
            tariffMap.put((Object)new JSONObject().put("from", (Object)tariffMapData.from).put("to", tariffMapData.getTo()));
        }
        config.put("tariffMap", (Object)tariffMap);
        try {
            String result = this.getLoaderService().doUtil("ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderLinkContractToTariff", this.data.get(), config.toString());
            if (result != null && !result.isEmpty()) {
                this.importResult.setText(result);
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    class TariffMapTableModel
    extends BGTableModel<TariffMapData> {
        public TariffMapTableModel() {
            super(TariffMapTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0422\u0430\u0440\u0438\u0444 (\u0438\u043c\u043f\u043e\u0440\u0442)", 300, 400, -1, "from", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0430\u0440\u0438\u0444 (BGBilling)", 300, 400, -1, "to", true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(TariffMapData val, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("to".equals(identifier)) {
                return LinkContractToTariff.this.tariffPlanTitles.stream().filter(a -> a.getId() == val.getTo()).findFirst().map(a -> a.getTitle()).orElse("=== \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ===");
            }
            return super.getValue(val, column);
        }
    }

    public class TariffMapData {
        private String from;
        private int to;

        public TariffMapData(LinkContractToTariff this$0) {
        }

        public String getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public TariffMapData setFrom(String from) {
            this.from = from;
            return this;
        }

        public TariffMapData setTo(int to) {
            this.to = to;
            return this;
        }
    }

    class TariffMapEditor
    extends BGEditorDialog<TariffMapData> {
        private JTextField from;
        private BGUList<IdTitle> to;

        public TariffMapEditor(String title, TariffMapData data) {
            super(title, data);
            this.from = new JTextField(30);
            this.to = new BGUList();
        }

        @Override
        public void doDialogPanel() {
            Color bgColor = this.from.getBackground();
            this.from.setHorizontalAlignment(0);
            this.from.setEditable(false);
            this.from.setBackground(bgColor);
            this.addFieldV("\u0422\u0430\u0440\u0438\u0444 (\u0438\u043c\u043f\u043e\u0440\u0442)", this.from);
            this.addFieldV("\u0422\u0430\u0440\u0438\u0444 (\u0431\u0438\u043b\u043b\u0438\u043d\u0433)", BGSwingUtilites.wrapScrollPane(this.to, 500, 300));
            this.from.setText(((TariffMapData)this.data).getFrom());
            ArrayList<IdTitle> list = new ArrayList<IdTitle>();
            list.add(new IdTitle(0, "=== \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ==="));
            list.addAll(LinkContractToTariff.this.tariffPlanTitles);
            this.to.setData(list);
            this.to.setSelectedId(((TariffMapData)this.data).to, true);
        }

        @Override
        public boolean doApply() throws Exception {
            ((TariffMapData)this.data).setTo(this.to.optSelectedValue().map(a -> a.getId()).orElse(0));
            LinkContractToTariff.this.tariffMapTableModel.fireTableDataChanged();
            return true;
        }
    }
}

