/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import bitel.billing.module.common.ModTreeNode;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeTree;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.common.Utils;

public class CodeTreeKeyListener
extends KeyAdapter {
    private final DynamicCodeTree dynamicCodeTree;
    private final JTree tree;
    private String pattern;
    private final List<DynamicClass> classes;
    private Popup popup;

    protected CodeTreeKeyListener(DynamicCodeTree dynamicCodeTree, List<DynamicClass> classes) {
        this.dynamicCodeTree = dynamicCodeTree;
        this.tree = dynamicCodeTree.getTree();
        this.classes = classes;
        this.tree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CodeTreeKeyListener.this.switchSearchFieldVisible();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CodeTreeKeyListener.this.hideSearchField();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch == '\u001b') {
            this.pattern = null;
            this.dynamicCodeTree.recreateTree(this.classes);
            this.hideSearchField();
        } else {
            if (!Character.isDefined(ch) || ch == '\n' || ch == '\b') {
                return;
            }
            this.pattern = (this.pattern == null ? "" + ch : this.pattern + ch).toLowerCase();
        }
        this.switchSearchFieldVisible();
        if (this.pattern != null && this.pattern.length() > 2) {
            this.filtering();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 8) {
            if (this.pattern == null) {
                return;
            }
            if (this.pattern.length() <= 1) {
                this.dynamicCodeTree.recreateTree(this.classes);
                this.pattern = null;
            } else {
                this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
            }
            this.switchSearchFieldVisible();
            if (this.pattern != null && this.pattern.length() > 2) {
                this.filtering();
            }
        }
    }

    private void switchSearchFieldVisible() {
        this.hideSearchField();
        if (Utils.notBlankString((String)this.pattern)) {
            Point p = this.tree.getParent().getLocationOnScreen();
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(this.pattern);
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.popup = popupFactory.getPopup(this.tree, toolTip, p.x, p.y - toolTip.getPreferredSize().height);
            this.popup.show();
        }
    }

    private void hideSearchField() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private void filtering() {
        if (this.pattern != null && this.pattern.length() > 2) {
            List<ModTreeNode> findNodes = this.findNode((DefaultMutableTreeNode)this.tree.getModel().getRoot(), this.pattern.toLowerCase().trim());
            ModTreeNode rootNode = new ModTreeNode("/", "packet");
            rootNode.setAttribute("name", (Object)".");
            rootNode.setAttribute("type", (Object)1);
            rootNode.setText("\u041d\u0430\u0439\u0434\u0435\u043d\u043e:");
            findNodes.forEach(arg_0 -> rootNode.add(arg_0));
            this.tree.setModel(new DefaultTreeModel((TreeNode)rootNode));
            this.tree.revalidate();
            this.tree.repaint();
        }
    }

    public List<ModTreeNode> findNode(DefaultMutableTreeNode node, String search) {
        ArrayList<ModTreeNode> result = new ArrayList<ModTreeNode>();
        for (int x = 0; x < node.getChildCount(); ++x) {
            ModTreeNode treeNode = (ModTreeNode)node.getChildAt(x);
            if (treeNode.getChildCount() > 0) {
                result.addAll(this.findNode((DefaultMutableTreeNode)treeNode, search));
                continue;
            }
            if (!treeNode.getText().toLowerCase().contains(search)) continue;
            result.add(treeNode);
        }
        return result;
    }

    public String getPattern() {
        return this.pattern;
    }
}

