/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import ru.bitel.bgbilling.kernel.table.common.enums.BGUTableCellRenderer;

public class BGUTableColumn {
    private String title;
    private int minWidth = -1;
    private int prefWidth = -1;
    private int maxWidth = -1;
    private String name;
    private String className;
    private boolean sortable = false;
    private boolean editable = false;
    private BGUTableCellRenderer tableCellRenderer = BGUTableCellRenderer.TEXT_LEFT;

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    @XmlAttribute
    public int getMinWidth() {
        return this.minWidth;
    }

    @XmlAttribute
    public int getPrefWidth() {
        return this.prefWidth;
    }

    @XmlAttribute
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @XmlAttribute
    public String getClassName() {
        return this.className;
    }

    @XmlAttribute
    public boolean isSortable() {
        return this.sortable;
    }

    @XmlAttribute
    public boolean isEditable() {
        return this.editable;
    }

    @XmlAttribute
    public BGUTableCellRenderer getTableCellRenderer() {
        return this.tableCellRenderer;
    }

    public BGUTableColumn setTitle(String title) {
        this.title = title;
        return this;
    }

    public BGUTableColumn setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public BGUTableColumn setPrefWidth(int prefWidth) {
        this.prefWidth = prefWidth;
        return this;
    }

    public BGUTableColumn setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public BGUTableColumn setWidth(int width) {
        this.minWidth = width;
        this.prefWidth = width;
        this.maxWidth = width;
        return this;
    }

    public BGUTableColumn setName(String name) {
        this.name = name;
        return this;
    }

    public BGUTableColumn setClassName(String className) {
        this.className = className;
        return this;
    }

    public BGUTableColumn setSortable(boolean sortable) {
        this.sortable = sortable;
        return this;
    }

    public BGUTableColumn setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public BGUTableColumn setTableCellRenderer(BGUTableCellRenderer tableCellRenderer) {
        this.tableCellRenderer = tableCellRenderer;
        return this;
    }

    public static BGUTableColumn buildColumnId() {
        return new BGUTableColumn().setTitle("ID").setMinWidth(80).setPrefWidth(80).setMaxWidth(80).setName("id").setSortable(true).setTableCellRenderer(BGUTableCellRenderer.INTEGER);
    }

    public static BGUTableColumn buildColumnRadioLeft(String name) {
        return BGUTableColumn.buildColumnRadio(name, BGUTableCellRenderer.RADIO_LEFT);
    }

    public static BGUTableColumn buildColumnRadioCenter(String name) {
        return BGUTableColumn.buildColumnRadio(name, BGUTableCellRenderer.RADIO_CENTER);
    }

    public static BGUTableColumn buildColumnRadio(String name, BGUTableCellRenderer renderer) {
        return new BGUTableColumn().setTitle("V").setMinWidth(50).setPrefWidth(50).setMaxWidth(50).setName(name).setSortable(true).setTableCellRenderer(renderer);
    }

    public static BGUTableColumn buildColumnPeriod() {
        return new BGUTableColumn().setTitle("\u041f\u0435\u0440\u0438\u043e\u0434").setMinWidth(180).setPrefWidth(180).setMaxWidth(180).setName("period").setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_CENTER);
    }

    public static BGUTableColumn buildColumnTextLeft(String title, String name) {
        return new BGUTableColumn().setTitle(title).setMinWidth(100).setPrefWidth(200).setMaxWidth(300).setName(name).setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_LEFT);
    }

    public static BGUTableColumn buildColumnTextCenter(String title, String name) {
        return new BGUTableColumn().setTitle(title).setMinWidth(100).setPrefWidth(200).setMaxWidth(300).setName(name).setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_CENTER);
    }

    public static BGUTableColumn buildColumnTextColorCenter(String title, String name) {
        return new BGUTableColumn().setTitle(title).setMinWidth(100).setPrefWidth(200).setMaxWidth(300).setName(name).setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_COLOR_CENTER);
    }

    public static BGUTableColumn buildColumnTextRight(String title, String name) {
        return new BGUTableColumn().setTitle(title).setMinWidth(100).setPrefWidth(200).setMaxWidth(300).setName(name).setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_RIGHT);
    }

    public static BGUTableColumn buildColumnComment() {
        return new BGUTableColumn().setTitle("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439").setMinWidth(100).setPrefWidth(100).setMaxWidth(-1).setName("comment").setSortable(false).setTableCellRenderer(BGUTableCellRenderer.TEXT_LEFT);
    }

    public static BGUTableColumn buildColumnDate(String title, String name) {
        return new BGUTableColumn().setTitle(title).setMinWidth(120).setPrefWidth(120).setMaxWidth(120).setName(name).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DATE);
    }

    public static BGUTableColumn buildColumnDecimal(String title, String name) {
        return new BGUTableColumn().setTitle(title).setMinWidth(150).setPrefWidth(150).setMaxWidth(150).setName(name).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DECIMAL);
    }

    public static BGUTableColumn buildColumnDateTime(String title, String name) {
        return new BGUTableColumn().setTitle(title).setMinWidth(180).setPrefWidth(180).setMaxWidth(180).setName(name).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DATE_TIME);
    }

    public static BGUTableColumn buildColumnBoolean(String title, String name, int width) {
        return new BGUTableColumn().setTitle(title).setMinWidth(width).setPrefWidth(width).setMaxWidth(width).setName(name).setClassName(Boolean.TYPE.toString()).setSortable(true).setTableCellRenderer(BGUTableCellRenderer.BOOLEAN);
    }

    public static BGUTableColumn buildColumnUserName() {
        return new BGUTableColumn().setTitle("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c").setMinWidth(150).setPrefWidth(200).setMaxWidth(300).setName("userName").setSortable(true).setTableCellRenderer(BGUTableCellRenderer.TEXT_CENTER);
    }

    public static BGUTableColumn buildColumnLastUpdate() {
        return new BGUTableColumn().setTitle("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f/\u043f\u0440\u0430\u0432\u043a\u0438").setMinWidth(180).setPrefWidth(180).setMaxWidth(180).setName("lastUpdate").setSortable(true).setTableCellRenderer(BGUTableCellRenderer.DATE_TIME);
    }
}

