/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.server.service;

import jakarta.jws.WebService;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.apps.common.bean.AppInfo;
import ru.bitel.bgbilling.kernel.admin.apps.server.bean.AppsCache;
import ru.bitel.bgbilling.kernel.admin.common.bean.FieldNameSQL;
import ru.bitel.bgbilling.kernel.admin.common.service.AdminService;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.PeriodicProcessErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.common.service.AdminService")
public class AdminServiceImpl
extends AbstractService
implements AdminService {
    @Override
    public List<IdTitle> getContractEntries(String values, boolean byTitle) throws BGException {
        List<Object> result = new ArrayList();
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            result = byTitle ? contractDao.getContractsByTitles(Utils.toList((String)values, (String)"\n")) : contractDao.getContracts(Utils.toIntegerList((String)values));
        }
        return result.stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    @Override
    public List<BGModule> getModules() throws BGException {
        return ModuleCache.getInstance().getModulesList();
    }

    @Override
    public List<String> getContractEntriesFromSqlQuery(String query, FieldNameSQL fieldNameSQL) throws BGException {
        if (query == null) {
            throw new BGMessageException("query == null");
        }
        if (fieldNameSQL == null) {
            throw new BGMessageException("fieldNameSQL == null");
        }
        if (query.isEmpty() || !query.toUpperCase().startsWith("SELECT ")) {
            throw new BGMessageException("\u043f\u0443\u0441\u0442\u043e\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u043d\u0435 \u0441 'SELECT '");
        }
        return (List)this.tryReturn(() -> {
            ArrayList<String> result = new ArrayList<String>();
            try (Statement st = this.getConnection().createStatement();
                 ResultSet rs = st.executeQuery(query);){
                while (rs.next()) {
                    result.add(rs.getString(fieldNameSQL.name().toLowerCase()));
                }
            }
            return result;
        });
    }

    @Override
    public void periodicErrorDelete(List<Integer> periodicErrorIds) throws BGException {
        if (Utils.isEmptyCollection(periodicErrorIds)) {
            throw new BGIllegalArgumentException();
        }
        this.tryCall(() -> new PeriodicErrorManager(this.getConnection()).deleteErrorsByIds(periodicErrorIds));
    }

    @Override
    public SearchResult<PeriodicProcessErrorMessage> periodicProcessErrorMessageSearch(String contains, Date month, Period period, Page page) throws BGException {
        if (page == null || month == null) {
            throw new BGIllegalArgumentException();
        }
        if (period != null && period.getDateFrom() == null && period.getDateTo() == null) {
            period = null;
        }
        PeriodicErrorManager manager = new PeriodicErrorManager(this.getConnection());
        SearchResult searchResult = new SearchResult(period, page);
        manager.getErrors((SearchResult<PeriodicProcessErrorMessage>)searchResult, month, contains);
        return searchResult;
    }

    @Override
    public List<AppInfo.AppInfoItem> appInfoItemList() throws BGException {
        return AppsCache.getInstanse().getAppInfos().stream().map(AppInfo::toAppInfoItem).toList();
    }

    @Override
    public AppInfo appInfoGet(int appId) throws BGException {
        return AppsCache.getInstanse().getAppInfos().stream().filter(a -> a.getAppId() == appId).findFirst().orElse(null);
    }
}

