/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services.load;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IPField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.field.BGPasswordField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class SourceEditor
extends BGPanel {
    private String sid = null;
    private String typeID = "1";
    private JTextArea comment = new JTextArea();
    private BGConfigEditorPane config = new BGConfigEditorPane();
    private BGControlPanelPeriod bGControlPanel_07 = new BGControlPanelPeriod();
    private JPasswordField ftpPswd = new JPasswordField();
    private CardLayout cardLayout = new CardLayout();
    private BGComboBox<ComboBoxItem> sourceType = new BGComboBox();
    private BGTextField sourceTitle = new BGTextField();
    private JTextField ftpHost = new JTextField();
    private JTextField ftpUser = new JTextField();
    private JTextField dirPath = new JTextField();
    private JTextField dirUser = new JTextField();
    private JTextField dirPswd = new JTextField();
    private JPanel params = new JPanel(this.cardLayout);
    private IPField netFlowIP = new IPField();
    private IPField sFlowIP = new IPField();
    private IPField snmpIP = new IPField();
    private BGPasswordField snmpCommunity = new BGPasswordField();

    public SourceEditor() {
        this.tryCall(() -> this.jbInit());
        this.comment.setRows(3);
        this.fl = false;
        this.sourceType.addItem(new ComboBoxItem("1", "FTP"));
        this.sourceType.addItem(new ComboBoxItem("2", "\u041b\u043e\u043a\u0430\u043b\u044c\u043d\u0430\u044f \u0438\u043b\u0438 \u0441\u0435\u0442\u0435\u0432\u0430\u044f \u043f\u0430\u043f\u043a\u0430"));
        this.sourceType.addItem(new ComboBoxItem("3", "Netflow"));
        this.sourceType.addItem(new ComboBoxItem("4", "sFlow"));
        this.sourceType.addItem(new ComboBoxItem("5", "SNMP"));
        this.fl = true;
    }

    private void jbInit() throws Exception {
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        JPanel ftpParams = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JPanel fileParams = new JPanel(new GridBagLayout());
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.sourceType.setMaximumSize(new Dimension(Short.MAX_VALUE, 21));
        this.sourceType.setMinimumSize(new Dimension(1, 21));
        this.sourceType.setPreferredSize(new Dimension(100, 21));
        this.sourceType.addItemListener(e -> this.sourceType_itemStateChanged(e));
        jPanel1.setBorder(new BGTitleBorder(" \u0422\u0438\u043f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 "));
        jPanel4.setBorder(new BGTitleBorder(" \u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 "));
        jLabel6.setText("\u041f\u0430\u0440\u043e\u043b\u044c: ");
        jLabel5.setText("\u041b\u043e\u0433\u0438\u043d: ");
        jLabel4.setText("\u0421\u0435\u0440\u0432\u0435\u0440: ");
        ftpParams.setBorder(new BGTitleBorder(" FTP "));
        fileParams.setBorder(new BGTitleBorder(" \u041b\u043e\u043a\u0430\u043b\u044c\u043d\u0430\u044f \u0438\u043b\u0438 \u0441\u0435\u0442\u0435\u0432\u0430\u044f \u043f\u0430\u043f\u043a\u0430 "));
        jLabel1.setText("\u041f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435: ");
        jLabel2.setText("\u041b\u043e\u0433\u0438\u043d: ");
        jLabel3.setText("\u041f\u0430\u0440\u043e\u043b\u044c: ");
        this.ftpHost.setMinimumSize(new Dimension(220, 24));
        this.ftpHost.setPreferredSize(new Dimension(220, 24));
        this.ftpHost.setToolTipText("( \u0434\u043e 50 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 )");
        this.ftpHost.setColumns(20);
        this.ftpUser.setMinimumSize(new Dimension(4, 24));
        this.ftpUser.setPreferredSize(new Dimension(220, 24));
        this.ftpUser.setToolTipText("( \u0434\u043e 15 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 )");
        this.ftpUser.setColumns(20);
        this.ftpPswd.setMinimumSize(new Dimension(4, 24));
        this.ftpPswd.setPreferredSize(new Dimension(220, 24));
        this.ftpPswd.setToolTipText("( \u0434\u043e 15 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 )");
        this.ftpPswd.setColumns(20);
        BGButtonPanelRestoreOkCancelHelp bGControlPanel_02 = new BGButtonPanelRestoreOkCancelHelp();
        bGControlPanel_02.addActionListener(e -> this.bGControlPanel_02_actionPerformed(e));
        this.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.dirPath.setMinimumSize(new Dimension(4, 24));
        this.dirPath.setPreferredSize(new Dimension(4, 24));
        this.dirUser.setMinimumSize(new Dimension(4, 24));
        this.dirUser.setPreferredSize(new Dimension(4, 24));
        this.dirPswd.setMinimumSize(new Dimension(4, 24));
        this.dirPswd.setPreferredSize(new Dimension(4, 24));
        ftpParams.add((Component)jLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        ftpParams.add((Component)this.ftpHost, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.params.add((Component)ftpParams, "1");
        this.add((Component)this.params, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.params.add((Component)fileParams, "2");
        fileParams.add((Component)jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        fileParams.add((Component)this.dirPath, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        JTabbedPane tabPanel = new JTabbedPane();
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)new JScrollPane(this.config), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        tabPanel.add((Component)configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        tabPanel.add((Component)commentPanel, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        this.add((Component)tabPanel, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)jPanel4, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel4.add((Component)this.sourceTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.bGControlPanel_07, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)bGControlPanel_02, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)jPanel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        jPanel1.add(this.sourceType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        ftpParams.add((Component)this.ftpUser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        ftpParams.add((Component)jLabel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        ftpParams.add((Component)this.ftpPswd, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        fileParams.add((Component)this.dirUser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        ftpParams.add((Component)jLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        fileParams.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        fileParams.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        fileParams.add((Component)this.dirPswd, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        JPanel netflowParams = new JPanel(new GridBagLayout());
        netflowParams.setBorder(new BGTitleBorder(" Netflow "));
        netflowParams.add(Box.createGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        netflowParams.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0445\u043e\u0441\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        netflowParams.add((Component)this.netFlowIP, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 3), 0, 0));
        this.params.add((Component)netflowParams, "3");
        JPanel sFlowParams = new JPanel(new GridBagLayout());
        sFlowParams.setBorder(new BGTitleBorder(" sFlow "));
        sFlowParams.add(Box.createGlue(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        sFlowParams.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0445\u043e\u0441\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        sFlowParams.add((Component)this.sFlowIP, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 3), 0, 0));
        this.params.add((Component)sFlowParams, "4");
        this.snmpCommunity.setHorizontalAlignment(0);
        JPanel snmpParams = new JPanel(new GridBagLayout());
        snmpParams.setBorder(new BGTitleBorder(" SNMP "));
        snmpParams.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441 \u0445\u043e\u0441\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        snmpParams.add((Component)this.snmpIP, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 3), 0, 0));
        snmpParams.add((Component)new JLabel("Community:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        snmpParams.add((Component)this.snmpCommunity, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 3), 0, 0));
        snmpParams.add(Box.createGlue(), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.params.add((Component)snmpParams, "5");
    }

    @Override
    public void setData() throws Exception {
        String date2;
        if (this.id == 0) {
            this.sourceTitle.requestFocus();
            return;
        }
        Request request = new Request().setModule("load").setModuleId(this.getModuleId()).setAction("GetSource").setAttribute("id", this.id);
        Document doc = this.getDocument(request);
        Element source = XMLUtils.selectElement(doc, "//source");
        this.typeID = XMLUtils.getAttribute(source, "type", "1");
        String date1 = XMLUtils.getAttribute(source, "date1", null);
        if (date1 != null) {
            this.bGControlPanel_07.setDateString1(date1);
        }
        if ((date2 = XMLUtils.getAttribute(source, "date2", null)) != null) {
            this.bGControlPanel_07.setDateString2(date2);
        }
        this.sourceTitle.setText(XMLUtils.getAttribute(source, "title", ""));
        Element comment = XMLUtils.selectElement(source, "//comment");
        Element config = XMLUtils.selectElement(source, "//config");
        this.config.setText(ClientUtils.linesToString(config));
        this.comment.setText(ClientUtils.linesToString(comment));
        this.fl = false;
        if ("1".equals(this.typeID)) {
            this.sourceType.setSelectedIndex(0);
            this.cardLayout.show(this.params, "1");
            this.ftpHost.setText(XMLUtils.getAttribute(source, "host_or_dir", ""));
            this.ftpUser.setText(XMLUtils.getAttribute(source, "user", ""));
            this.ftpPswd.setText(XMLUtils.getAttribute(source, "pswd", ""));
        } else if ("2".equals(this.typeID)) {
            this.sourceType.setSelectedIndex(1);
            this.cardLayout.show(this.params, "2");
            this.dirPath.setText(XMLUtils.getAttribute(source, "host_or_dir", ""));
            this.dirUser.setText(XMLUtils.getAttribute(source, "user", ""));
            this.dirPswd.setText(XMLUtils.getAttribute(source, "pswd", ""));
        } else if ("3".equals(this.typeID)) {
            this.sourceType.setSelectedIndex(2);
            this.cardLayout.show(this.params, "3");
            this.netFlowIP.setIP(XMLUtils.getAttribute(source, "host_or_dir", "0.0.0.0"));
        } else if ("4".equals(this.typeID)) {
            this.sourceType.setSelectedIndex(3);
            this.cardLayout.show(this.params, "4");
            this.sFlowIP.setIP(XMLUtils.getAttribute(source, "host_or_dir", "0.0.0.0"));
        } else if ("5".equals(this.typeID)) {
            this.sourceType.setSelectedIndex(4);
            this.cardLayout.show(this.params, "5");
            this.snmpIP.setIP(XMLUtils.getAttribute(source, "host_or_dir", "0.0.0.0"));
            this.snmpCommunity.setText(XMLUtils.getAttribute(source, "pswd", ""));
        }
        this.fl = true;
    }

    private void sourceType_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2 || !this.fl) {
            return;
        }
        this.typeID = (String)this.sourceType.getSelectedItem().getObject();
        this.cardLayout.show(this.params, this.typeID);
    }

    private void bGControlPanel_02_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.trySetData();
        } else if ("ok".equals(actionCommand)) {
            Request request = new Request();
            request.setModule("load");
            request.setAction("UpdateSource");
            request.setAttribute("id", this.id);
            request.setModuleId(this.getModuleId());
            if (this.sid != null) {
                request.setAttribute("sid", this.sid);
            }
            request.setAttribute("title", this.sourceTitle.getText().trim());
            if (Utils.isEmptyString(this.bGControlPanel_07.getDateString1())) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return;
            }
            request.setAttribute("date1", this.bGControlPanel_07.getDateString1());
            request.setAttribute("date2", this.bGControlPanel_07.getDateString2());
            request.setAttribute("comment", this.comment.getText().trim());
            request.setAttribute("config", this.config.getText().trim());
            request.setAttribute("type", this.typeID);
            if ("1".equals(this.typeID)) {
                char[] pswd = this.ftpPswd.getPassword();
                request.setAttribute("host", this.ftpHost.getText().trim());
                request.setAttribute("login", this.ftpUser.getText().trim());
                request.setAttribute("passwd", pswd.length == 0 ? "" : new String(pswd));
            } else if ("2".equals(this.typeID)) {
                request.setAttribute("path", this.dirPath.getText().trim());
                request.setAttribute("login", this.dirUser.getText().trim());
                request.setAttribute("passwd", this.dirPswd.getText().trim());
            } else if ("3".equals(this.typeID)) {
                request.setAttribute("host", this.netFlowIP.getIP());
                request.setAttribute("login", "");
                request.setAttribute("passwd", "");
            } else if ("4".equals(this.typeID)) {
                request.setAttribute("host", this.sFlowIP.getIP());
                request.setAttribute("login", "");
                request.setAttribute("passwd", "");
            } else if ("5".equals(this.typeID)) {
                request.setAttribute("host", this.snmpIP.getIP());
                request.setAttribute("login", "");
                request.setAttribute("passwd", new String(this.snmpCommunity.getPassword()));
            }
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setVisible(false);
            }
        } else if ("cancel".equals(actionCommand)) {
            this.setVisible(false);
        } else if ("help".equals(actionCommand)) {
            this.openHelp(SourceEditor.class.getName());
        }
    }
}

