/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.admin.license.common.service.LicenseService;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UnregRequestRecord;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class UserRightMonitoringUnregPanel
extends BGUPanel {
    private final JLabel recordCountLabel = new JLabel("");
    private final BGControlPanelPages pages = new BGControlPanelPages();
    private UnregRequestLogTableModel logTableModel = null;
    private Directory<UserInfo> userDirectory;

    protected void jbInit() throws Exception {
        this.logTableModel = new UnregRequestLogTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.logTableModel));
        table.getPopupMenu().add(this.getActionMap().get("deleteRecords"));
        this.setLayout(new GridBagLayout());
        this.add(this.getUnregRequestControlPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getUnregRequestControlPanel() {
        this.pages.addToHandler(a -> this.performAction("refresh"));
        JButton recheckButton = new JButton(this.getActionMap().get("recheck"));
        JButton clearButton = new JButton(this.getActionMap().get("deleteAllRecords"));
        JButton sendReportButton = new JButton(this.getActionMap().get("devReport"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)recheckButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)clearButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)sendReportButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 0, 5), 0, 0));
        return panel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchResult<UnregRequestRecord> searchResult = ((RoleService)((ClientContext)this.getContext()).getWebService(RoleService.class, 0)).searchUnregRequestRecordList(this.pages.getPage());
            this.logTableModel.setData(searchResult.getList());
            this.pages.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)searchResult.getPage().getRecordCount()));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {});
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {});
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {});
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "deleteRecords", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438", e -> {
            List records = this.logTableModel.getSelectedRows();
            if (!records.isEmpty()) {
                ((RoleService)((ClientContext)this.getContext()).getWebService(RoleService.class, 0)).clearUnregRequestRecordList(records.stream().map(a -> a.getService() != null ? "service_" + a.getService() + "_" + a.getOperation() : "action_" + a.getModuleId() + "_" + a.getAction()).toList());
                this.performAction("refresh");
            }
        });
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "deleteAllRecords", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c", e -> {
            if (ClientUtils.confirmDelete((Object)"\u0432\u0441\u0435 \u0437\u0430\u043f\u0438\u0441\u0438")) {
                this.tryCall(() -> {
                    ((RoleService)((ClientContext)this.getContext()).getWebService(RoleService.class, 0)).clearUnregRequestRecordList(null);
                    this.performAction("refresh");
                });
            }
        });
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "devReport", "\u041e\u0442\u0447\u0435\u0442 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c", e -> this.tryCall(() -> {
            StringBuilder builder = new StringBuilder();
            JSONObject json = new JSONObject(((LicenseService)((ClientContext)this.getContext()).getWebService(LicenseService.class, 0)).aboutGet());
            SearchResult<UnregRequestRecord> searchResult = ((RoleService)((ClientContext)this.getContext()).getWebService(RoleService.class, 0)).searchUnregRequestRecordList(null);
            HashSet componentIds = new HashSet();
            searchResult.getList().forEach(c -> componentIds.add(c.getModuleId()));
            for (String componentId : componentIds) {
                String name = searchResult.getList().stream().filter(z -> z.getModuleId().equals(componentId)).findFirst().map(UnregRequestRecord::getModuleName).orElse("?");
                if ("0".equals(componentId)) {
                    builder.append("server " + String.valueOf(json.query("/server/versionstring")) + "\n");
                    builder.append("client " + String.valueOf(json.query("/client/versionstring")) + "\n\n");
                } else {
                    builder.append("################### " + name + " ###################\n\n");
                }
                ArrayList<UnregRequestRecord> list = new ArrayList<UnregRequestRecord>(searchResult.getList());
                list.sort(Comparator.comparing(UnregRequestRecord::getService));
                list.stream().filter(f -> componentId.equals(f.getModuleId())).forEach(b -> {
                    if (b.getAction() != null) {
                        builder.append("\t<service id=\"\" mask=\"module=").append(b.getModuleName()).append(";action=").append(b.getAction()).append("\" title=\"").append(b.getAction()).append("\"/>\n");
                    } else {
                        builder.append("\t<service id=\"\" name=\"").append(b.getService()).append("\" operation=\"").append(b.getOperation()).append("\" title=\"").append(b.getOperation()).append("\"/>\n");
                    }
                });
                builder.append("\n");
            }
            BGTextArea textArea = new BGTextArea(30, 80);
            textArea.setText(builder.toString());
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), new JScrollPane((Component)textArea), "\u041e\u0442\u0447\u0435\u0442 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430\u043c", 1);
        }));
        new AbstractBGUPanel.BGDefaultAction((AbstractBGUPanel)this, "recheck", "\u041f\u0435\u0440\u0435\u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c", e -> this.tryCall(() -> {
            ((RoleService)((ClientContext)this.getContext()).getWebService(RoleService.class, 0)).recheckUnregRequestRecordList();
            this.performAction("refresh");
        }));
    }

    private Directory<UserInfo> getUserDirectory() {
        if (this.userDirectory == null) {
            this.tryCall(() -> {
                this.userDirectory = ((ClientContext)this.getContext()).getDirectory(UserInfo.class);
            });
        }
        return this.userDirectory;
    }

    class UnregRequestLogTableModel
    extends BGTableModel<UnregRequestRecord> {
        public UnregRequestLogTableModel() {
            super(UnregRequestLogTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u0414\u0430\u0442\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438", 180, 190, 200, "lastTime", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("moduleId", 200, 300, 300, "moduleId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("Action", 200, 250, 300, "action", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("Service", 200, 250, 300, "service", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("Operation", 300, 350, 400, "operation", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("contractId", 100, 100, 100, "contractId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 100, 100, -1, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(UnregRequestRecord val, int column) throws Exception {
            String identifier;
            return switch (identifier = this.getIdentifier(column)) {
                case "moduleId" -> {
                    String moduleId = val.getModuleId();
                    if ("0".equals(moduleId)) {
                        yield "Kernel";
                    }
                    if (val.getModuleId().startsWith("p")) {
                        int pluginId = Utils.parseInt((String)moduleId.substring(1));
                        yield "\u041f\u043b\u0430\u0433\u0438\u043d: " + val.getModuleName() + " [#" + pluginId + "]";
                    }
                    int id = Utils.parseInt((String)moduleId);
                    yield "\u041c\u043e\u0434\u0443\u043b\u044c: " + val.getModuleName() + " [#" + id + "]";
                }
                case "userId" -> {
                    UserInfo userInfo = UserRightMonitoringUnregPanel.this.getUserDirectory().get(val.getUserId());
                    if (userInfo != null) {
                        yield userInfo.getGuiTitle();
                    }
                    yield "#" + val.getUserId();
                }
                default -> super.getValueAt((Object)val, column);
            };
        }
    }
}

