/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.util.HashMap;
import java.util.Map;
import ru.bitel.oss.kernel.directories.address.common.bean.House;

public class ParameterIds {
    private Map<String, Integer> ids = new HashMap<String, Integer>();

    public int getCountryId() {
        return this.ids.get(TableName.COUNTRY.getTableName());
    }

    public int getRegionId() {
        return this.ids.get(TableName.REGION.getTableName());
    }

    public int getCityId() {
        return this.ids.get(TableName.CITY.getTableName());
    }

    public int getStreetId() {
        return this.ids.get(TableName.STREET.getTableName());
    }

    public int getAreaId() {
        return this.ids.get(TableName.AREA.getTableName());
    }

    public int getQuarterId() {
        return this.ids.get(TableName.QUARTER.getTableName());
    }

    public int getHouseId() {
        return this.ids.get(TableName.HOUSE.getTableName());
    }

    public int getCount() {
        return this.ids.size();
    }

    public Map<String, Integer> getIds() {
        return this.ids;
    }

    public ParameterIds setCountryId(int countryId) {
        if (countryId > 0) {
            this.ids.put(TableName.COUNTRY.getTableName(), countryId);
        }
        return this;
    }

    public void setRegionId(int regionId) {
        if (regionId > 0) {
            this.ids.put(TableName.REGION.getTableName(), regionId);
        }
    }

    public ParameterIds setCityId(int cityId) {
        if (cityId > 0) {
            this.ids.put(TableName.CITY.getTableName(), cityId);
        }
        return this;
    }

    public ParameterIds setStreetId(int streetId) {
        if (streetId > 0) {
            this.ids.put(TableName.STREET.getTableName(), streetId);
        }
        return this;
    }

    public ParameterIds setAreaId(int areaId) {
        if (areaId > 0) {
            this.ids.put(TableName.AREA.getTableName(), areaId);
        }
        return this;
    }

    public ParameterIds setQuarterId(int quarterId) {
        if (quarterId > 0) {
            this.ids.put(TableName.QUARTER.getTableName(), quarterId);
        }
        return this;
    }

    public ParameterIds setHouseId(int houseId) {
        if (houseId > 0) {
            this.ids.put(TableName.HOUSE.getTableName(), houseId);
        }
        return this;
    }

    public static ParameterIds from(House house) {
        return new ParameterIds().setCountryId(house.getCountry().getId()).setCityId(house.getCity().getId()).setStreetId(house.getStreet().getId()).setAreaId(house.getArea().getId()).setQuarterId(house.getQuarter().getId()).setHouseId(house.getId());
    }

    static enum TableName {
        COUNTRY("address_country"),
        REGION("address_region"),
        CITY("address_city"),
        STREET("address_street"),
        AREA("address_area"),
        QUARTER("address_quarter"),
        HOUSE("address_house");

        private String tableName;

        private TableName(String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

