/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.task;

import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.sql.Connection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.server.bean.AreaDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.QuarterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;
import ru.bitel.oss.kernel.entity.server.utils.AddressUtils;

public class TaskUpdateAddressDirectory
extends TaskBase {
    private static final String SETUP_KEY_TIME = "address.time";
    private static final String SETUP_KEY_DELETE_ROWS = "address.delete.rows";
    private static final String SETUP_KEY_FLAT_AMOUNT = "key.flat.amount";
    private static final String SETUP_KEY_BOX_INDEX = "key.box.index";
    private static final String DEFAULT_VALUE_FLAT_AMOUNT = ".i.flat.amount";
    private static final String DEFAULT_VALUE_BOX_INDEX = "s.box.index";
    private boolean addressDeleteRows = false;
    private String url = null;
    private String keyFlatAmount = null;
    private String keyBoxIndex = null;

    @Override
    protected boolean initTask() {
        this.url = this.taskSetup.get("url", null);
        this.keyBoxIndex = this.taskSetup.get(SETUP_KEY_BOX_INDEX, DEFAULT_VALUE_BOX_INDEX);
        this.keyFlatAmount = this.taskSetup.get(SETUP_KEY_FLAT_AMOUNT, DEFAULT_VALUE_FLAT_AMOUNT);
        this.addressDeleteRows = Utils.parseBoolean((String)this.taskSetup.get(SETUP_KEY_DELETE_ROWS, "false"));
        return this.url != null;
    }

    @Override
    protected void executeTask() {
        block48: {
            try (Connection con = this.setup.getDBConnectionFromPool();){
                StringBuffer buf = new StringBuffer();
                buf.append(this.url);
                if (this.url.indexOf("?") > -1) {
                    buf.append("&");
                } else {
                    buf.append("?");
                }
                buf.append("time=");
                if (this.addressDeleteRows) {
                    buf.append("0");
                } else {
                    buf.append(ServerUtils.getSetupValue(con, SETUP_KEY_TIME, "0"));
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("serverURL: {}", (Object)buf.toString());
                }
                URL serverURL = URI.create(buf.toString()).toURL();
                HttpURLConnection httpCon = (HttpURLConnection)serverURL.openConnection();
                httpCon.setRequestMethod("GET");
                httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                httpCon.setDoOutput(false);
                httpCon.setDoInput(true);
                if (httpCon.getResponseCode() == 200) {
                    Document doc = XMLUtils.parseDocument((InputSource)new InputSource(httpCon.getInputStream()));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("data = {}", (Object)XMLUtils.serializeToString((Node)doc, (boolean)true));
                    }
                    Element rootElement = doc.getDocumentElement();
                    try (CountryDao countryDao = new CountryDao(con);
                         CityDao cityDao = new CityDao(con);
                         AreaDao areaDao = new AreaDao(con);
                         QuarterDao quarterDao = new QuarterDao(con);
                         StreetDao streetDao = new StreetDao(con);
                         HouseDao houseDao = new HouseDao(con);){
                        if (this.addressDeleteRows) {
                            this.deleteAddressRows(countryDao, cityDao, areaDao, quarterDao, streetDao, houseDao);
                        }
                        int bc = this.updateCountry(countryDao, XMLUtils.selectElement((Node)rootElement, (String)"//address_country"));
                        int cc = this.updateCity(cityDao, XMLUtils.selectElement((Node)rootElement, (String)"//address_city"));
                        int ac = this.updateArea(areaDao, XMLUtils.selectElement((Node)rootElement, (String)"//address_area"));
                        int qc = this.updateAddressQuarter(quarterDao, XMLUtils.selectElement((Node)rootElement, (String)"//address_quarter"));
                        int sc = this.updateAddressStreet(streetDao, XMLUtils.selectElement((Node)rootElement, (String)"//address_street"));
                        int hc = this.updateAddressHouse(houseDao, XMLUtils.selectElement((Node)rootElement, (String)"//address_house"));
                        ServerUtils.setSetupValue(con, SETUP_KEY_TIME, rootElement.getAttribute("time"));
                        this.getLogger().info("Records updated: county's = " + bc + "; city's = " + cc + "; areas = + " + ac + "; quarters = " + qc + "; streets = " + sc + "; houses = " + hc);
                        break block48;
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                    break block48;
                }
                this.getLogger().error("Request result: ResponseCode: {}, ResponseMessage: {}", (Object)httpCon.getResponseCode(), (Object)httpCon.getResponseMessage());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    private void deleteAddressRows(CountryDao countryDao, CityDao cityDao, AreaDao areaDao, QuarterDao quarterDao, StreetDao streetDao, HouseDao houseDao) throws BGException {
        countryDao.deleteRows();
        cityDao.deleteRows();
        areaDao.deleteRows();
        quarterDao.deleteRows();
        quarterDao.deleteRows();
        houseDao.deleteRows();
    }

    private int updateCountry(CountryDao countryDao, Element countryElement) throws Exception {
        int result = 0;
        if (countryElement != null) {
            for (Element recordElement : XMLUtils.selectElements((Node)countryElement, (String)"record")) {
                Country country = new Country().setId(Utils.parseInt((String)recordElement.getAttribute("id"), (int)-1)).setTitle(XMLUtils.getAttribute((Element)recordElement, (String)"title", null));
                if (country.getId() <= 0 || country.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressCountry id: {}, title: {}", (Object)country.getId(), (Object)country.getTitle());
                    countryDao.update(country);
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateCity(CityDao cityDao, Element cityElement) throws Exception {
        int result = 0;
        if (cityElement != null) {
            for (Element recordElement : XMLUtils.selectElements((Node)cityElement, (String)"record")) {
                City city = new City().setId(Utils.parseInt((String)recordElement.getAttribute("id"), (int)-1)).setCountryId(Utils.parseInt((String)recordElement.getAttribute("countryId"), (int)-1)).setTitle(XMLUtils.getAttribute((Element)recordElement, (String)"title", null));
                NodeList recordConfigNodeList = recordElement.getElementsByTagName("config");
                for (int configIndex = 0; configIndex < recordConfigNodeList.getLength(); ++configIndex) {
                    Element recordConfigElement = (Element)recordConfigNodeList.item(configIndex);
                    if (!"pos".equals(recordConfigElement.getAttribute("name"))) continue;
                    city.setPositionIndex(Utils.parseInt((String)recordConfigElement.getAttribute("value"), (int)0));
                    break;
                }
                if (city.getId() <= 0 || city.getCountryId() <= 0 || city.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressCity country_id: {}, city_id: {}", (Object)city.getCountryId(), (Object)city.getId());
                    cityDao.update(city);
                    AddressUtils.onUpdateAddressCity(this.setup, city.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateArea(AreaDao areaDao, Element areaElement) throws Exception {
        int result = 0;
        if (areaElement != null) {
            for (Element recordElement : XMLUtils.selectElements((Node)areaElement, (String)"record")) {
                City city = new City().setId(Utils.parseInt((String)recordElement.getAttribute("cityId"), (int)-1));
                Area area = new Area().setId(Utils.parseInt((String)recordElement.getAttribute("id"), (int)-1)).setCity(city).setTitle(XMLUtils.getAttribute((Element)recordElement, (String)"title", null));
                if (area.getId() <= 0 || area.getCity().getId() <= 0 || area.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressArea city_id: {}, area_id: ", (Object)area.getCity().getId(), (Object)area.getId());
                    areaDao.update(area);
                    AddressUtils.onUpdateAddressArea(this.setup, area.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressQuarter(QuarterDao quarterDao, Element quarterElement) throws Exception {
        int result = 0;
        if (quarterElement != null) {
            for (Element recordElement : XMLUtils.selectElements((Node)quarterElement, (String)"record")) {
                City city = new City().setId(Utils.parseInt((String)recordElement.getAttribute("cityId"), (int)-1));
                Quarter quarter = new Quarter().setId(Utils.parseInt((String)recordElement.getAttribute("id"), (int)-1)).setCity(city).setTitle(XMLUtils.getAttribute((Element)recordElement, (String)"title", null));
                if (quarter.getId() <= 0 || quarter.getCity().getId() <= 0 || quarter.getTitle() == null) continue;
                try {
                    this.getLogger().debug("updateAddressQuarter city_id: {}, quarter_id: {}", (Object)quarter.getCity().getId(), (Object)quarter.getId());
                    quarterDao.update(quarter);
                    AddressUtils.onUpdateAddressQuarter(this.setup, quarter.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressStreet(StreetDao streetDao, Element streetElement) throws Exception {
        int result = 0;
        if (streetElement != null) {
            for (Element recordElement : XMLUtils.selectElements((Node)streetElement, (String)"record")) {
                City city = new City().setId(Utils.parseInt((String)recordElement.getAttribute("cityId"), (int)-1));
                Street street = new Street().setId(Utils.parseInt((String)recordElement.getAttribute("id"), (int)-1)).setCity(city).setTitle(XMLUtils.getAttribute((Element)recordElement, (String)"title", null));
                if (street.getId() <= 0 || street.getCity().getId() <= 0 || street.getTitle() == null) continue;
                this.getLogger().debug("updateAddressStreet city_id: {}, street_id: {}", (Object)street.getCity().getId(), (Object)street.getId());
                try {
                    streetDao.update(street);
                    AddressUtils.onUpdateAddressStreet(this.setup, street.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }

    private int updateAddressHouse(HouseDao houseDao, Element houseElement) throws Exception {
        int result = 0;
        if (houseElement != null) {
            for (Element recordElement : XMLUtils.selectElements((Node)houseElement, (String)"record")) {
                House house = new House().setId(Utils.parseInt((String)recordElement.getAttribute("id"), (int)-1)).setAreaId(Utils.parseInt((String)recordElement.getAttribute("areaId"), (int)-1)).setStreetId(Utils.parseInt((String)recordElement.getAttribute("streetId"), (int)-1)).setQuarterId(Utils.parseInt((String)recordElement.getAttribute("quarterId"), (int)-1)).setHouse(Utils.parseInt((String)recordElement.getAttribute("house"), (int)-1)).setFrac(XMLUtils.getAttribute((Element)recordElement, (String)"frac", null)).setComment(XMLUtils.getAttribute((Element)recordElement, (String)"comment", null));
                NodeList recordConfigNodeList = recordElement.getElementsByTagName("config");
                for (int configIndex = 0; configIndex < recordConfigNodeList.getLength(); ++configIndex) {
                    Element recordConfigElement = (Element)recordConfigNodeList.item(configIndex);
                    String name = recordConfigElement.getAttribute("name");
                    String value = recordConfigElement.getAttribute("value");
                    if (this.keyBoxIndex.equals(name)) {
                        house.setPostIndex(value);
                        continue;
                    }
                    if (!this.keyFlatAmount.equals(name)) continue;
                    house.setAmount(Utils.parseInt((String)value, (int)0));
                }
                if (house.getId() <= 0 || house.getStreet().getId() <= 0 || house.getHouse() <= 0) continue;
                this.getLogger().debug("updateAddressHouse: street_id: {}, house_id: {}", (Object)house.getStreet().getId(), (Object)house.getId());
                try {
                    houseDao.update(house);
                    AddressUtils.onUpdateHouse(this.setup, house.getId());
                }
                catch (Exception e) {
                    this.getLogger().error(e.getMessage(), (Throwable)e);
                }
                ++result;
            }
        }
        return result;
    }
}

