/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius.auth.eap.tls;

import java.util.HashMap;
import ru.bitel.common.Utils;

public class TLSLogHelper {
    public static final byte TLS_MSG_CHANGE_CIPHER_SPEC = 20;
    public static final byte TLS_MSG_ALERT = 21;
    public static final byte TLS_MSG_HANDSHAKE = 22;
    public static final byte TLS_MSG_APPLICATION_DATA = 23;
    private static final HashMap<Integer, String> s_cipherSuiteMap = new HashMap();

    public static String bytesToHex(byte[] data, int k, int len) {
        byte[] a = new byte[len];
        System.arraycopy(data, k, a, 0, len);
        return Utils.bytesToHexString((byte[])a);
    }

    public static String bytesToHex(byte[] data) {
        return Utils.bytesToHexString((byte[])data);
    }

    public static String toHex(short x) {
        return Integer.toHexString(x);
    }

    public static String trace(byte[] data) {
        StringBuilder sb = new StringBuilder();
        try {
            int i = 0;
            byte lastConType = 0;
            while (i < data.length) {
                byte m_contentType = data[i++];
                byte majVer = data[i++];
                byte minVer = data[i++];
                int length = data[i++] << 8 & 0xFF00 | data[i++] & 0xFF;
                int nextI = i + length;
                switch (m_contentType) {
                    case 20: {
                        sb.append("\tChangeCipherSpec,v").append(majVer).append('.').append(minVer);
                        break;
                    }
                    case 21: {
                        byte m_alertLevel = data[i++];
                        byte m_alertDescription = data[i];
                        sb.append("\tAlert,v").append(majVer).append('.').append(minVer);
                        sb.append(",level=").append(TLSLogHelper.getAlertLevelText(m_alertLevel));
                        sb.append(",desc=").append(TLSLogHelper.getAlertDescriptionText(m_alertDescription));
                        break;
                    }
                    case 22: {
                        int hsLen;
                        sb.append("\tHandshake,v").append(majVer).append('.').append(minVer);
                        block21: for (int j = i; j < nextI; j += hsLen) {
                            byte hsType = data[j++];
                            hsLen = data[j++] << 16 & 0xFF0000 | data[j++] << 8 & 0xFF00 | data[j++] & 0xFF;
                            if (lastConType == 20) {
                                sb.append("\t  Finished");
                                continue;
                            }
                            switch (hsType) {
                                case 0: {
                                    sb.append("\t  HelloRequest");
                                    continue block21;
                                }
                                case 1: {
                                    int k = j;
                                    majVer = data[k++];
                                    minVer = data[k++];
                                    byte[] m_clientRandom = new byte[32];
                                    System.arraycopy(data, k, m_clientRandom, 0, 32);
                                    sb.append("\t  ClientHello");
                                    sb.append("\t    version ").append(majVer).append('.').append(minVer);
                                    sb.append("\t    random = ").append(Utils.bytesToHexString((byte[])m_clientRandom));
                                    k += 32;
                                    byte idLen = data[k++];
                                    sb.append("\t    session_id = ").append(TLSLogHelper.bytesToHex(data, k, idLen));
                                    sb.append("\t    cipher_suites");
                                    int csLen = data[(k += idLen) + 1] | data[k] << 8;
                                    k += 2;
                                    for (int csi = 0; csi < csLen; ++csi) {
                                        int cs = data[k + 1] | data[k] << 8;
                                        String suiteName = s_cipherSuiteMap.get(cs);
                                        if (suiteName == null) {
                                            suiteName = "Unknown Cipher Suite 0x" + TLSLogHelper.toHex((short)cs);
                                        }
                                        sb.append("\t      ").append(suiteName);
                                        k += 2;
                                    }
                                    sb.append("\t    compression_methods");
                                    int cmLen = data[k++];
                                    for (int cmi = 0; cmi < cmLen; ++cmi) {
                                        byte cm;
                                        String cmName = (cm = data[k++]) != 0 ? String.valueOf(cm) : "NULL";
                                        sb.append("\t      ").append(cmName);
                                        k += 2;
                                    }
                                    continue block21;
                                }
                                case 2: {
                                    int k = j;
                                    majVer = data[k++];
                                    minVer = data[k++];
                                    byte[] m_serverRandom = new byte[32];
                                    System.arraycopy(data, k, m_serverRandom, 0, 32);
                                    sb.append("\t  ServerHello");
                                    sb.append("\t    version ").append(majVer).append('.').append(minVer);
                                    sb.append("\t    random = ").append(TLSLogHelper.bytesToHex(m_serverRandom));
                                    k += 32;
                                    byte idLen = data[k++];
                                    sb.append("\t    session_id = ").append(TLSLogHelper.bytesToHex(data, k, idLen));
                                    int cs = data[(k += idLen) + 1] | data[k] << 8;
                                    String suiteName = s_cipherSuiteMap.get(cs);
                                    if (suiteName == null) {
                                        suiteName = "Unknown Cipher Suite 0x" + TLSLogHelper.toHex((short)cs);
                                    }
                                    sb.append("\t    cipher_suite = ").append(suiteName);
                                    byte cm = data[k += 2];
                                    String cmName = cm != 0 ? String.valueOf(cm) : "NULL";
                                    sb.append("\t    compression_method = ").append(cmName);
                                    continue block21;
                                }
                                case 11: {
                                    sb.append("\t  Certificate");
                                    continue block21;
                                }
                                case 12: {
                                    sb.append("\t  ServerKeyExchange");
                                    continue block21;
                                }
                                case 13: {
                                    sb.append("\t  CertificateRequest");
                                    continue block21;
                                }
                                case 14: {
                                    sb.append("\t  ServerHelloDone");
                                    continue block21;
                                }
                                case 15: {
                                    sb.append("\t  CertificateVerify");
                                    continue block21;
                                }
                                case 16: {
                                    int k = j;
                                    majVer = data[k++];
                                    minVer = data[k++];
                                    byte[] premasterenc = new byte[46];
                                    System.arraycopy(data, k, premasterenc, 0, 46);
                                    sb.append("\t  ClientKeyExchange");
                                    sb.append("\t    version ").append(majVer).append('.').append(minVer);
                                    sb.append(" " + Utils.bytesToString((byte[])premasterenc));
                                    continue block21;
                                }
                                case 20: {
                                    sb.append("\t  Finished");
                                    continue block21;
                                }
                                default: {
                                    sb.append("\t  UknownHandshake=").append(hsType);
                                }
                            }
                        }
                        break;
                    }
                    case 23: {
                        sb.append("\tApplicationData,v").append(majVer).append('.').append(minVer);
                        break;
                    }
                    default: {
                        sb.append("\tUnknownContentType=").append(m_contentType).append('v').append(majVer).append('.').append(minVer);
                    }
                }
                lastConType = m_contentType;
                i = nextI;
            }
        }
        catch (Exception e) {
            sb.append("Caught ").append(e.toString());
        }
        return sb.toString();
    }

    public static String getAlertLevelText(int level) {
        switch (level) {
            case 1: {
                return "warning";
            }
            case 2: {
                return "fatal";
            }
        }
        return String.valueOf(level);
    }

    public static String getAlertDescriptionText(int desc) {
        switch (desc) {
            case 0: {
                return "close_notify";
            }
            case 10: {
                return "unexpected_message";
            }
            case 20: {
                return "bad_record_mac";
            }
            case 21: {
                return "decryption_failure";
            }
            case 22: {
                return "record_overflow";
            }
            case 30: {
                return "decompression_failure";
            }
            case 40: {
                return "handshake_failure";
            }
            case 42: {
                return "bad_certificate";
            }
            case 43: {
                return "unsupported_certificate";
            }
            case 44: {
                return "certificate_revoked";
            }
            case 45: {
                return "certificate_expired";
            }
            case 46: {
                return "certificate_unknown";
            }
            case 47: {
                return "illegal_parameter";
            }
            case 48: {
                return "unknown_ca";
            }
            case 49: {
                return "access_denied";
            }
            case 50: {
                return "decode_error";
            }
            case 51: {
                return "decrypt_error";
            }
            case 60: {
                return "export_restriction";
            }
            case 70: {
                return "protocol_version";
            }
            case 71: {
                return "insufficient_security";
            }
            case 80: {
                return "internal_error";
            }
            case 90: {
                return "user_canceled";
            }
            case 100: {
                return "no_renegotiation";
            }
        }
        return String.valueOf(desc);
    }

    static {
        s_cipherSuiteMap.put(0, "TLS_NULL_WITH_NULL_NULL");
        s_cipherSuiteMap.put(1, "TLS_RSA_WITH_NULL_MD5");
        s_cipherSuiteMap.put(2, "TLS_RSA_WITH_NULL_SHA");
        s_cipherSuiteMap.put(3, "TLS_RSA_EXPORT_WITH_RC4_40_MD5");
        s_cipherSuiteMap.put(4, "TLS_RSA_WITH_RC4_128_MD5");
        s_cipherSuiteMap.put(5, "TLS_RSA_WITH_RC4_128_SHA");
        s_cipherSuiteMap.put(6, "TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5");
        s_cipherSuiteMap.put(7, "TLS_RSA_WITH_IDEA_CBC_SHA");
        s_cipherSuiteMap.put(8, "TLS_RSA_EXPORT_WITH_DES40_CBC_SHA");
        s_cipherSuiteMap.put(9, "TLS_RSA_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(10, "TLS_RSA_WITH_3DES_EDE_CBC_SHA");
        s_cipherSuiteMap.put(11, "TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA");
        s_cipherSuiteMap.put(12, "TLS_DH_DSS_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(13, "TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA");
        s_cipherSuiteMap.put(14, "TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA");
        s_cipherSuiteMap.put(15, "TLS_DH_RSA_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(16, "TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA");
        s_cipherSuiteMap.put(17, "TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA");
        s_cipherSuiteMap.put(18, "TLS_DHE_DSS_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(19, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA");
        s_cipherSuiteMap.put(20, "TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA");
        s_cipherSuiteMap.put(21, "TLS_DHE_RSA_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(22, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA");
        s_cipherSuiteMap.put(23, "TLS_DH_anon_EXPORT_WITH_RC4_40_MD5");
        s_cipherSuiteMap.put(24, "TLS_DH_anon_WITH_RC4_128_MD5");
        s_cipherSuiteMap.put(25, "TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA");
        s_cipherSuiteMap.put(26, "TLS_DH_anon_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(27, "TLS_DH_anon_WITH_3DES_EDE_CBC_SHA");
        s_cipherSuiteMap.put(28, "TLS_FORTEZZA_DMS_WITH_NULL_SHA");
        s_cipherSuiteMap.put(29, "TLS_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA");
        s_cipherSuiteMap.put(47, "TLS_RSA_WITH_AES_128_CBC_SHA");
        s_cipherSuiteMap.put(48, "TLS_DH_DSS_WITH_AES_128_CBC_SHA");
        s_cipherSuiteMap.put(49, "TLS_DH_RSA_WITH_AES_128_CBC_SHA");
        s_cipherSuiteMap.put(50, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA");
        s_cipherSuiteMap.put(51, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
        s_cipherSuiteMap.put(52, "TLS_DH_anon_WITH_AES_128_CBC_SHA");
        s_cipherSuiteMap.put(53, "TLS_RSA_WITH_AES_256_CBC_SHA");
        s_cipherSuiteMap.put(54, "TLS_DH_DSS_WITH_AES_256_CBC_SHA");
        s_cipherSuiteMap.put(55, "TLS_DH_RSA_WITH_AES_256_CBC_SHA");
        s_cipherSuiteMap.put(56, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA");
        s_cipherSuiteMap.put(57, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA");
        s_cipherSuiteMap.put(58, "TLS_DH_anon_WITH_AES_256_CBC_SHA");
        s_cipherSuiteMap.put(98, "TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(99, "TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA");
        s_cipherSuiteMap.put(100, "TLS_RSA_EXPORT1024_WITH_RC4_56_SHA");
        s_cipherSuiteMap.put(101, "TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA");
        s_cipherSuiteMap.put(102, "TLS_DHE_DSS_WITH_RC4_128_SHA");
        s_cipherSuiteMap.put(65408, "TLS_RSA_WITH_RC2_CBC_MD5");
        s_cipherSuiteMap.put(65409, "TLS_RSA_WITH_IDEA_CBC_MD5");
        s_cipherSuiteMap.put(65410, "TLS_RSA_WITH_DES_CBC_MD5");
        s_cipherSuiteMap.put(65411, "TLS_RSA_WITH_3DES_EDE_CBC_MD5");
    }
}

