/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.label.client.ContractLabelTree;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.common.Utils;

public class ContractLabelEditor
extends BGUPanel {
    private ContractLabelItem node = null;
    private final ContractLabelTree labelTree = new ContractLabelTree(false, true, true);
    private ContractLabelService contractLabelService;
    private final JPanel tablePanel = new JPanel();
    private final JPopupMenu popupMenu = new JPopupMenu();
    private final JCheckBox showHideLabelIds = new JCheckBox("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c/\u0441\u043a\u0440\u044b\u0442\u044c ID \u043c\u0435\u0442\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");

    @Override
    protected void jbInit() throws Exception {
        this.labelTree.setPopupMenu(null);
        this.labelTree.enableSortableDnD(this.getContractLabelService());
        this.setData();
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.add((Component)new JScrollPane(this.labelTree), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.tablePanel.add((Component)this.showHideLabelIds, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.labelTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                boolean isSelectedRow;
                boolean bl = isSelectedRow = ContractLabelEditor.this.labelTree.getSelectedIds() != null && !ContractLabelEditor.this.labelTree.getSelectedIds().isEmpty();
                if (SwingUtilities.isRightMouseButton(e)) {
                    ContractLabelEditor.this.showPopupMenu(e, isSelectedRow);
                } else if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ContractLabelEditor.this.editItem();
                } else if (SwingUtilities.isLeftMouseButton(e) && !isSelectedRow) {
                    ContractLabelEditor.this.labelTree.clearSelection();
                }
            }
        });
        this.showHideLabelIds.addActionListener(e -> this.labelTree.switchVisibleIdLabels());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public boolean performAction(String action) {
        try {
            ContractLabelItem selectedItem = this.labelTree.getSelectedItem();
            if (("editItem".equals(action) || "deleteItem".equals(action)) && selectedItem == null) {
                ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043c\u0435\u0442\u043a\u0430");
                return false;
            }
            if ("deleteItem".equals(action) && ContractLabelType.LABEL.equals((Object)selectedItem.getContractLabelType())) {
                ClientUtils.showErrorMessageDialog("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u0435\u0451 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return false;
            }
            switch (action) {
                case "refresh": {
                    this.labelTree.setData(this.getContractLabelService().getContractLabelTreeItemList(-1, false));
                    break;
                }
                case "newItem": {
                    if (selectedItem == null) {
                        this.addItem(false, 100);
                        break;
                    }
                    if (!selectedItem.getContractLabelType().equals((Object)ContractLabelType.LABEL)) break;
                    this.addItem(false, selectedItem.getId());
                    break;
                }
                case "editItem": {
                    if (selectedItem == null || !ContractLabelType.LABEL.equals((Object)selectedItem.getContractLabelType()) && !ContractLabelType.LABEL_ITEM.equals((Object)selectedItem.getContractLabelType())) break;
                    this.editItem();
                    break;
                }
                case "deleteItem": {
                    if (selectedItem == null || !ContractLabelType.LABEL_ITEM.equals((Object)selectedItem.getContractLabelType())) break;
                    this.deleteItem();
                }
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
        return true;
    }

    private void addItem(boolean isCategory) {
        this.addItem(isCategory, 1);
    }

    private void addItem(boolean isCategory, int parentId) {
        this.node = new ContractLabelItem();
        this.node.setId(0);
        if (isCategory) {
            this.node.setContractLabelType(ContractLabelType.LABEL);
            this.node.setParentId(parentId > 0 ? parentId : 1);
        } else {
            this.node.setContractLabelType(ContractLabelType.LABEL_ITEM);
            ContractLabelItem parentItem = this.labelTree.getSelectedItem();
            int parent = parentId > 1 ? parentId : (parentItem != null ? parentItem.getId() : 100);
            this.node.setParentId(parent);
        }
        new LabelEditorDialog("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043c\u0435\u0442\u043a\u0438", this.node).open();
    }

    public void editItem() {
        this.node = this.labelTree.getSelectedItem();
        if (this.node == null || this.node.getId() == 1) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        if (this.node.getParentId() == 1) {
            ClientUtils.showErrorMessageDialog("\u0414\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0433\u0440\u0443\u043f\u043f \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u0432 \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b - \u0433\u0440\u0443\u043f\u043f\u044b\"");
            return;
        }
        new LabelEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0435\u0442\u043a\u0438", this.node).open();
    }

    private void deleteItem() {
        ContractLabelItem contractLabelItem = this.labelTree.getSelectedItem();
        this.tryCall(() -> {
            if (ClientUtils.confirm("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u043c\u0435\u0442\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
                ContractLabelItem parent;
                int contractsWithLabel = this.getContractLabelService().getContractCountByLabel(contractLabelItem.getId());
                if (contractsWithLabel > 0 && !ClientUtils.confirm("\u0423\u0434\u0430\u043b\u044f\u0435\u043c\u0430\u044f \u043c\u0435\u0442\u043a\u0430 \u0435\u0441\u0442\u044c \u043d\u0430 " + contractsWithLabel + " \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435.\n\u041f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043c\u0435\u0442\u043a\u0430 \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u0430 \u0441\u043e \u0432\u0441\u0435\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432.\n\u0423\u0434\u0430\u043b\u0438\u0442\u044c?", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435")) {
                    return;
                }
                if (contractLabelItem.getParentId() > 0 && (parent = this.labelTree.getLabelItemById(contractLabelItem.getParentId())) != null && Utils.isEmptyCollection(parent.getChildren())) {
                    parent.setContractLabelType(ContractLabelType.LABEL_ITEM);
                    this.getContractLabelService().updateContractLabelTreeItem(parent);
                }
                if (Utils.notEmptyCollection(contractLabelItem.getChildren())) {
                    if (ClientUtils.confirm("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043d\u0435 \u043f\u0443\u0441\u0442\u0430. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u043c\u0435\u0442\u043a\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445. \u0423\u0434\u0430\u043b\u0438\u0442\u044c?", "\u0412\u041d\u0418\u041c\u0410\u041d\u0418\u0415")) {
                        this.getContractLabelService().removeContractLabelTreeItem(contractLabelItem.getId());
                        this.labelTree.setData(this.getContractLabelService().getContractLabelTreeItemList(-1, false));
                    }
                } else {
                    this.getContractLabelService().removeContractLabelTreeItem(contractLabelItem.getId());
                    this.labelTree.setData(this.getContractLabelService().getContractLabelTreeItemList(-1, false));
                }
            }
        });
    }

    public void setData() throws Exception {
        this.labelTree.setData(this.getContractLabelService().getContractLabelTreeItemList(-1, false));
    }

    private void showPopupMenu(MouseEvent mouseEvent, boolean isSelectedRow) {
        JMenuItem addItem = new JMenuItem("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443");
        addItem.addActionListener(e -> this.addItem(false));
        JMenuItem editItem = new JMenuItem("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c");
        editItem.addActionListener(e -> this.editItem());
        JMenuItem switchEditable = new JMenuItem("");
        switchEditable.addActionListener(e -> this.tryCall(() -> {
            ContractLabelItem selectedItem = this.labelTree.getSelectedItem();
            if (selectedItem != null) {
                selectedItem.setForbiddenEdit(!selectedItem.isForbiddenEdit());
                this.getContractLabelService().updateContractLabelTreeItem(selectedItem);
                this.performAction("refresh");
            }
        }));
        this.popupMenu.removeAll();
        if (isSelectedRow) {
            ContractLabelItem selectedItem = this.labelTree.getSelectedItem();
            if (selectedItem == null || selectedItem.getId() <= 0) {
                return;
            }
            switch (selectedItem.getContractLabelType()) {
                case LABEL: {
                    this.popupMenu.add(addItem);
                    this.popupMenu.add(editItem);
                    break;
                }
                case LABEL_ITEM: {
                    if (selectedItem.getParentId() == 100) {
                        this.popupMenu.add(addItem);
                    }
                    this.popupMenu.add(editItem);
                    this.popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u0435\u0442\u043a\u0443").addActionListener(e -> this.deleteItem());
                    this.popupMenu.addSeparator();
                    switchEditable.setText(selectedItem.isForbiddenEdit() ? "\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u043a\u0443" : "\u0417\u0430\u043f\u0440\u0435\u0442\u0438\u0442\u044c \u043f\u0440\u0430\u0432\u043a\u0443");
                    this.popupMenu.add(switchEditable);
                    break;
                }
                case GROUP: 
                case GROUP_ITEM: {
                    if (selectedItem.getId() >= 66) break;
                    ClientUtils.showErrorMessageDialog("\u0414\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0433\u0440\u0443\u043f\u043f \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u0432 \u0440\u0430\u0437\u0434\u0435\u043b \"\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b - \u0433\u0440\u0443\u043f\u043f\u044b\"");
                    return;
                }
            }
        }
        this.popupMenu.show(this.labelTree, mouseEvent.getX(), mouseEvent.getY());
    }

    private ContractLabelService getContractLabelService() {
        if (this.contractLabelService == null) {
            this.contractLabelService = ((ClientContext)this.getContext()).getPort(ContractLabelService.class);
        }
        return this.contractLabelService;
    }

    class LabelEditorDialog
    extends BGEditorDialog<ContractLabelItem> {
        private JTextField upId;
        private JTextField titleName;
        private JTextArea comment;

        public LabelEditorDialog(String title, ContractLabelItem data) {
            super(title, data);
            this.upId = new JTextField("");
            this.titleName = new JTextField(40);
            this.comment = new JTextArea(3, 40);
        }

        @Override
        public void doDialogPanel() {
            this.upId.setEnabled(false);
            this.titleName.setMinimumSize(new Dimension(4, 24));
            this.titleName.setPreferredSize(new Dimension(4, 24));
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.comment.setWrapStyleWord(true);
            this.comment.setLineWrap(true);
            this.panel.add((Component)new JLabel("ID \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044f"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.upId, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.titleName, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.upId.setText(String.valueOf(((ContractLabelItem)this.data).getParentId()));
            this.titleName.setText(((ContractLabelItem)this.data).getTitle());
            this.comment.setText(((ContractLabelItem)this.data).getComment());
        }

        @Override
        public boolean doApply() throws Exception {
            ContractLabelItem parent;
            if (Utils.isBlankString(this.titleName.getText())) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (((ContractLabelItem)this.data).getParentId() > 0 && (parent = ContractLabelEditor.this.labelTree.getSelectedItem()) != null && parent.getId() == ((ContractLabelItem)this.data).getParentId() && parent.getContractLabelType().equals((Object)ContractLabelType.LABEL_ITEM)) {
                parent.setContractLabelType(ContractLabelType.LABEL);
                ContractLabelEditor.this.getContractLabelService().updateContractLabelTreeItem(parent);
            }
            ((ContractLabelItem)this.data).setTitle(this.titleName.getText());
            ((ContractLabelItem)this.data).setComment(this.comment.getText());
            ContractLabelEditor.this.getContractLabelService().updateContractLabelTreeItem((ContractLabelItem)this.data);
            ContractLabelEditor.this.setData();
            return true;
        }
    }
}

