/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGFileFilter;
import ru.bitel.bgbilling.client.common.field.BGTextField;

public class BGSelectFilePanel
extends JPanel {
    private int fileSelectionMode = 0;
    private boolean showPath = false;
    private File[] _files;
    private BGFileFilter[] filters;
    private boolean saveDialog = false;
    private boolean multiSelect = false;
    private BGTextField fileName_TF = new BGTextField();
    private BGButton jButton1 = new BGButton();
    private File currentDirectory;
    private String dialogTitle = null;

    public BGSelectFilePanel() {
        this(false, false, false);
    }

    public BGSelectFilePanel(boolean saveDialog) {
        this(saveDialog, false, false);
    }

    public BGSelectFilePanel(boolean saveDialog, boolean multiSelect, boolean showPath) {
        this.saveDialog = saveDialog;
        this.multiSelect = multiSelect;
        this.showPath = showPath;
        this.fileName_TF.setEditable(false);
        this.fileName_TF.setText("");
        this.jButton1.setForeground(new Color(66, 0, 25));
        this.jButton1.setPreferredSize(new Dimension(26, 26));
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.setText("...");
        this.jButton1.setToolTipText("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0444\u0430\u0439\u043b(\u044b)");
        this.jButton1.addActionListener(e -> this.jButton1_actionPerformed(e));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.fileName_TF, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jButton1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void setColumns(int columns) {
        this.fileName_TF.setColumns(columns);
    }

    public void setCurrentDirectory(File value) {
        this.currentDirectory = value;
        if (this.showPath && this.currentDirectory != null) {
            this.fileName_TF.setText(this.currentDirectory.getAbsolutePath());
        }
    }

    public void setFileFilter(String ext, String filterName) {
        this.filters = new BGFileFilter[]{new BGFileFilter(ext, filterName)};
    }

    private String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    private void jButton1_actionPerformed(ActionEvent actionEvent) {
        BGFileChooser.initFileChooser();
        BGFileChooser choose = new BGFileChooser(this);
        choose.setAcceptAllFileFilterUsed(false);
        if (this.dialogTitle != null) {
            choose.setDialogTitle(this.dialogTitle);
        }
        choose.setFileSelectionMode(this.fileSelectionMode);
        if (this.currentDirectory != null) {
            choose.setCurrentDirectory(this.currentDirectory);
        }
        if (this.filters != null && this.filters.length > 0) {
            for (int i = 0; i < this.filters.length; ++i) {
                choose.addChoosableFileFilter(this.filters[i]);
            }
        }
        boolean fileSelected = false;
        if (this.saveDialog) {
            if (choose.showSaveDialog(JOptionPane.getRootFrame()) == 0) {
                FileFilter cur;
                File _file = choose.getSelectedFile();
                if (_file != null && this.filters != null && this.filters.length > 0 && this.getExtension(_file) == null && (cur = choose.getFileFilter()).getClass().isInstance(this.filters[0])) {
                    _file = new File(_file.getParentFile(), _file.getName() + "." + ((BGFileFilter)cur).getExt());
                }
                this.fileName_TF.setText(_file.getAbsolutePath());
                this._files = new File[]{_file};
                fileSelected = true;
            }
        } else {
            if (this.multiSelect) {
                choose.setMultiSelectionEnabled(true);
            }
            if (choose.showOpenDialog(JOptionPane.getRootFrame()) == 0) {
                this._files = choose.getSelectedFiles();
                File selectedFile = choose.getSelectedFile();
                if ((this._files == null || this._files.length == 0) && selectedFile != null) {
                    this._files = new File[]{selectedFile};
                }
                StringBuilder sb = new StringBuilder(50);
                for (File file : this._files) {
                    if (sb.length() > 0) {
                        sb.append("; ");
                    }
                    sb.append(this.showPath ? file.getAbsolutePath() : file.getName());
                }
                this.fileName_TF.setText(sb.toString());
                fileSelected = true;
            }
        }
        if (fileSelected) {
            this.firePropertyChange("fileSelected", false, true);
        }
    }

    public File getSelectedFile() {
        return this._files == null || this._files.length == 0 ? null : this._files[0];
    }

    public File[] getSelectedFiles() {
        return this._files;
    }

    public void setSelectFile(File file) {
        this._files = new File[]{file};
    }

    public void reset() {
        this.fileName_TF.setText("");
        this._files = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.jButton1.setEnabled(enabled);
    }

    public void setFileFieldBackground(Color color) {
        this.fileName_TF.setBackground(color);
    }

    public void setShowPath(boolean showPath) {
        this.showPath = showPath;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this.fileSelectionMode = fileSelectionMode;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }
}

