/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client.parameter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamBankData;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamBankTableModel;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamBankToolBar;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamCommonPanel;
import ru.bitel.bgbilling.kernel.customer.client.parameter.CustomerParamPanel;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;

public class CustomerParamBankPanel
extends CustomerParamCommonPanel {
    private ParamBankTableModel tableModel = new ParamBankTableModel();
    private BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
    private ParamBankToolBar toolBar = new ParamBankToolBar(this.table, this.tableModel);

    protected CustomerParamBankPanel(CustomerParamPanel customerParamPanel) {
        super(customerParamPanel);
        this.toolBar.addPropertyChangeListener(e -> {
            if ("updateData".equals(e.getPropertyName())) {
                this.updateData();
            }
        });
    }

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.toolBar), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
    }

    public void setData(JSONArray bankData) {
        this.tableModel.setData(Collections.emptyList());
        bankData.forEach(a -> {
            if (a instanceof JSONObject) {
                JSONObject json = (JSONObject)a;
                this.tableModel.addRow(new ParamBankData(json.optString("uuid"), json.optString("bik"), json.optString("name"), json.optString("accountR"), json.optString("accountC")));
            }
        });
    }

    public void updateData() {
        JSONArray banks = new JSONArray();
        this.tableModel.getRows().forEach(a -> {
            JSONObject bank = new JSONObject().put("uuid", (Object)a.getUuid()).put("bik", (Object)a.getBik()).put("name", (Object)a.getName()).put("accountR", (Object)a.getAccountR()).put("accountC", (Object)a.getAccountC());
            banks.put((Object)bank);
        });
        this.customerParamPanel.updateCustomerBank(banks);
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.toolBar.actionPerformed(new ActionEvent((Object)this, 1, "editItem")));
    }
}

